<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" indent="yes" />
	<!-- This rule is to copy all the nodes and attributes -->
	<xsl:template match="@*|node()">
		<xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
  	</xsl:template>
  	<!-- This rule is to replace "Default Group" with "Laptops and Desktops" and "Servers" groups, and "Laptops and Desktops" is the default for SBE -->
  	<xsl:template match="SemClientGroupTree/SemClientGroup/SemClientGroup[@Name='$$I18N.DefaultGroup.Name$$']">
	  	<SemClientGroup CreationTime="$$AUTOTIME$$" Creator="AF3C39A10A320801000000DBF200C60A" Id="$$ID.DEFAULTGROUP$$" ModifiedTime="$$AUTOTIME$$" Name="$$I18N.TemporaryGroup.Name$$" Type="TEMPORARY" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
  			<ObjReference Name="PolicyApplied" TargetId="$$ID.SGP.3$$" TargetType="SemGroupPolicy" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
    	</SemClientGroup>
	  	<SemClientGroup CreationTime="$$AUTOTIME$$" Creator="AF3C39A10A320801000000DBF200C60A" Id="$$AUTOID$$" ModifiedTime="$$AUTOTIME$$" Name="$$I18N.Server.Name$$" Type="TEMPORARY" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
	      	<ObjReference Name="PolicyApplied" TargetId="$$ID.SGP.4$$" TargetType="SemGroupPolicy" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
	    </SemClientGroup>
  	</xsl:template>
  	
</xsl:stylesheet>