<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" indent="yes" />
	<!-- This rule is to copy all the nodes and attributes -->
	<xsl:template match="@*|node()">
		<xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
  	</xsl:template>
  	<!-- This rule is to repace Communication tag with attribute values set for large enterprise (1000+ clients) -->
  	<xsl:template match="Communication">
        <Communication Mode="PULL" PollModeHeartbeatFreq="1800" UploadLogHeartbeatFreq="1800" UploadOpStateHeartbeatFreq="1800" UploadCmdStateHeartbeatFreq="1800" RandomizationRange="1800" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
            <AppUpload Enable="0" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
            <ObjReference Name="DefaultServerListLink" TargetId="$$ID.SS.1$$" TargetType="DefaultServerList" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
        </Communication>
  	</xsl:template>
</xsl:stylesheet>
