<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" indent="yes" />
	<!-- This rule is to copy all the nodes and attributes -->
	<xsl:template match="@*|node()">
		<xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
  	</xsl:template>
  	<!-- This rule is to repace SemGroupPolicy $$ID.SGP.2$$ with $$ID.SGP.3$$ and $$ID.SGP.4$$-->
  	<xsl:template match="SemGroupPolicy[@Id='$$ID.SGP.2$$']">
	  	<SemGroupPolicy Id="$$ID.SGP.3$$" Name="$$I18N.TemporaryGroup.Name$$" NameSpace="schema" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
			<Inheritance Mode="USE_LOCAL" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
			<ObjReference Name="AgentPolicyLink" TargetId="$$ID.SAP.3$$" TargetType="SemAgentPolicy" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
		</SemGroupPolicy>
		<SemGroupPolicy Id="$$ID.SGP.4$$" Name="$$I18N.Server.Name$$" NameSpace="schema" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
			<Inheritance Mode="USE_LOCAL" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
			<ObjReference Name="AgentPolicyLink" TargetId="$$ID.SAP.4$$" TargetType="SemAgentPolicy" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
		</SemGroupPolicy>
  	</xsl:template>
  	<!-- This rule is to add SemAgentPolicy $$ID.SAP.3$$ and $$ID.SAP.4$$ -->
  	<xsl:template match="SemAgentPolicy[@Id='$$ID.SAP.1$$']">
  		<xsl:copy>
        	<xsl:apply-templates select="@*|node()"/>
      	</xsl:copy>
  		<SemAgentPolicy Id="$$ID.SAP.3$$" Name="$$I18N.ClientPolicy$$" NameSpace="schema" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
			<AutoLocation LocationCheckFrequency="4" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
				<EnableAutoLocationSwitching  _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
				$$LICENSE.AL$$
				</EnableAutoLocationSwitching>
				<LocationArray DefaultLocation="$$ID.SL.3$$"  _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
					<Location Id="$$ID.SL.3$$" Name="$$I18N.Location.Default$$" Description="$$I18N.Location.Default.Desc$$" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
						<ObjReference Name="LocationConfigLink" TargetId="$$ID.SLC.3$$" TargetType="SemLocationConfig" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
					</Location>
				</LocationArray>
			</AutoLocation>
			<AppAuthenticationProtection Enable="0" EnableDllAuthentication="0" Action="ASK" AllowNewDll="1" AllowDllChange="1" AllowKnownNewDll="1" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
				<ExcludedAppArray _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
			</AppAuthenticationProtection>
			<!-- etrack 3873664, the AdminPassword tag is missing in a new group's policy profile, this can cause problem when moving a client from a group that has passwordprotection on to a newly created
			group. Add PasswordProtection object here to ensure by default a new group's policy always has AdminPassword tag in policy profile. The hashed password here is qalabs, they are just place holder 
			to avoid problem on client side, will be overwritten when user sets passwordProtection from sepm ui-->
			<PasswordProtection Enable="0" AskPwdWhenOpenAgentGUI="0" AskPwdWhenExit="0" AskPwdWhenImportOrExportProfile="0" AskPwdWhenUninstall="0" AskPwdWhenCleanwipe="0" PasswordHash="6D0B6C38A24100185F747205406A346D" Password2Hash="01B7C62D689D8EC84BFAC10C192D4B6EB8BFD3207ED2B721801593AC437DCFD64024A4460DAE92E2E5C7747B754F17C5F020EF95ED3D36108DD6D44295617803A1" Password3Hash="010704CBB867E9F9B139BC77C7FB1CFAE7A16A905B82D3695D1912689E96DA8CEB8B8C9AE1AF5BAA1EA806230290C825B11802210C40C0A0066565A8A9D688085A" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
			<Log _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
				<SystemLogSetting MaxLogSize="524288" MaxLogDays="14" MaxLogDamperIdleTime="10" MaxLogDamperPeriod="7200" UploadIt="1" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
				<SecurityLogSetting MaxLogSize="524288" MaxLogDays="14" MaxLogDamperIdleTime="10" MaxLogDamperPeriod="7200" UploadIt="1" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
				<TrafficLogSetting MaxLogSize="524288" MaxLogDays="14" MaxLogDamperIdleTime="10" MaxLogDamperPeriod="7200" UploadIt="$$LICENSE.FW$$" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
				<PacketLogSetting MaxLogSize="1048576" MaxLogDays="14" MaxLogDamperIdleTime="10" MaxLogDamperPeriod="7200" UploadIt="$$LICENSE.FW$$" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
				<BehaviorLogSetting MaxLogSize="1048576" MaxLogDays="14" MaxLogDamperIdleTime="10" MaxLogDamperPeriod="7200" UploadIt="$$LICENSE.OSP$$" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
				<LogUpload MaxUploadLogSize="100" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
			</Log>
			<PrestartingProtection Enable="0" AllowInitTraffic="1" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
			<AgentServiceProtection Enable="$$LICENSE.SEP$$" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
			<Communication Mode="PUSH" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
				<AppUpload Enable="0" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
				<ObjReference Name="DefaultServerListLink" TargetId="$$ID.SS.1$$" TargetType="DefaultServerList" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
			</Communication>
			<LuContentSelection _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="3">
				<ObjReference Name="LuContentPolicyApplied" TargetId="$$ID.LU.CONTENT.1$$" TargetType="LuContentPolicy" _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="5"/>
			</LuContentSelection>
			<ServerCertificate EnableSignatureValidation="1" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
			<!-- Tamper Protection Policy -->
            		<TamperProtectionPolicy Creator="admin" Description="$$I18N.DefaultSPlcyTp.DEFAULT.DESC$$" Id="$$ID.TPP.2$$" Name="Tamper protection policy" NameSpace="schema" _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="7">
			    <TamperProtection DisplayNotificationMessage="0" ProtectAfterAVshutdown="1" EnableTP="1" DisableDefaultEventExclusions="0" EventTimeoutQuery="60000" EventTimeoutSet="60000" EventTimeoutDefault="60000" LockDisplayNotificationMessage="0" LockEnableTP="0" LockProtectAfterAVshutdown="0" LockDisableDefaultEventExclusions="0" LockEventTimeoutQuery="0" LockEventTimeoutSet="0" LockEventTimeoutDefault="0" _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="13">
			      <TamperProcessSettings _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="3">
			        <TamperProtectionSettings Action="BLOCK_WITHOUT_LOG" DisplayNotificationMessage="0" Enabled="1" LockAction="0" LockDisplayNotificationMessage="0" LockEnabled="0" _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="8"/>
			      </TamperProcessSettings>
			      <TamperNamedObjectSettings _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="3">
			        <TamperProtectionSettings Action="BLOCK" DisplayNotificationMessage="0" Enabled="0" LockAction="0" LockDisplayNotificationMessage="0" LockEnabled="0" _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="8"/>
			      </TamperNamedObjectSettings>
			      <TamperRegistrySettings _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="3">
			        <TamperProtectionSettings Action="BLOCK" DisplayNotificationMessage="0" Enabled="1" LockAction="0" LockDisplayNotificationMessage="0" LockEnabled="0" _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="8"/>
			      </TamperRegistrySettings>
			      <TamperFileSettings _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="3">
			        <TamperProtectionSettings Action="BLOCK" DisplayNotificationMessage="0" Enabled="1" LockAction="0" LockDisplayNotificationMessage="0" LockEnabled="0" _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="8"/>
			      </TamperFileSettings>
			      <NotificationMessage _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="3"><![CDATA[$$I18N.PolicyTmpl.TpNotificationMessage$$]]></NotificationMessage>
			    </TamperProtection>
			</TamperProtectionPolicy>
  			<!-- End of Tamper Protection Policy -->
		</SemAgentPolicy>

		<SemAgentPolicy Id="$$ID.SAP.4$$" Name="$$I18N.ClientPolicy$$" NameSpace="schema" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
			<AutoLocation LocationCheckFrequency="4" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
				<EnableAutoLocationSwitching  _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
				$$LICENSE.AL$$
				</EnableAutoLocationSwitching>
				<LocationArray DefaultLocation="$$ID.SL.4$$"  _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
					<Location Id="$$ID.SL.4$$" Name="$$I18N.Location.Default$$" Description="$$I18N.Location.Default.Desc$$" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
						<ObjReference Name="LocationConfigLink" TargetId="$$ID.SLC.4$$" TargetType="SemLocationConfig" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
					</Location>
				</LocationArray>
			</AutoLocation>
			<AppAuthenticationProtection Enable="0" EnableDllAuthentication="0" Action="ASK" AllowNewDll="1" AllowDllChange="1" AllowKnownNewDll="1" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
				<ExcludedAppArray _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
			</AppAuthenticationProtection>
			<Log _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
				<SystemLogSetting MaxLogSize="524288" MaxLogDays="14" MaxLogDamperIdleTime="10" MaxLogDamperPeriod="7200" UploadIt="1" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
				<SecurityLogSetting MaxLogSize="524288" MaxLogDays="14" MaxLogDamperIdleTime="10" MaxLogDamperPeriod="7200" UploadIt="1" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
				<TrafficLogSetting MaxLogSize="524288" MaxLogDays="14" MaxLogDamperIdleTime="10" MaxLogDamperPeriod="7200" UploadIt="$$LICENSE.FW$$" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
				<PacketLogSetting MaxLogSize="1048576" MaxLogDays="14" MaxLogDamperIdleTime="10" MaxLogDamperPeriod="7200" UploadIt="$$LICENSE.FW$$" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
				<BehaviorLogSetting MaxLogSize="1048576" MaxLogDays="14" MaxLogDamperIdleTime="10" MaxLogDamperPeriod="7200" UploadIt="$$LICENSE.OSP$$" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
				<LogUpload MaxUploadLogSize="100" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
			</Log>
			<PrestartingProtection Enable="0" AllowInitTraffic="1" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
			<AgentServiceProtection Enable="$$LICENSE.SEP$$" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
			<Communication Mode="PUSH" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
				<AppUpload Enable="0" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
				<ObjReference Name="DefaultServerListLink" TargetId="$$ID.SS.1$$" TargetType="DefaultServerList" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
			</Communication>
			<LuContentSelection _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="3">
				<ObjReference Name="LuContentPolicyApplied" TargetId="$$ID.LU.CONTENT.1$$" TargetType="LuContentPolicy" _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="5"/>
			</LuContentSelection>
			<ServerCertificate EnableSignatureValidation="1" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
			<!-- Tamper Protection Policy -->
            		<TamperProtectionPolicy Creator="admin" Description="$$I18N.DefaultSPlcyTp.DEFAULT.DESC$$" Id="$$ID.TPP.2$$" Name="Tamper protection policy" NameSpace="schema" _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="7">
			    <TamperProtection DisplayNotificationMessage="0" ProtectAfterAVshutdown="1" EnableTP="1" DisableDefaultEventExclusions="0" EventTimeoutQuery="60000" EventTimeoutSet="60000" EventTimeoutDefault="60000" LockDisplayNotificationMessage="0" LockEnableTP="0" LockProtectAfterAVshutdown="0" LockDisableDefaultEventExclusions="0" LockEventTimeoutQuery="0" LockEventTimeoutSet="0" LockEventTimeoutDefault="0" _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="13">
			      <TamperProcessSettings _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="3">
			        <TamperProtectionSettings Action="BLOCK_WITHOUT_LOG" DisplayNotificationMessage="0" Enabled="1" LockAction="0" LockDisplayNotificationMessage="0" LockEnabled="0" _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="8"/>
			      </TamperProcessSettings>
			      <TamperNamedObjectSettings _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="3">
			        <TamperProtectionSettings Action="BLOCK" DisplayNotificationMessage="0" Enabled="0" LockAction="0" LockDisplayNotificationMessage="0" LockEnabled="0" _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="8"/>
			      </TamperNamedObjectSettings>
			      <TamperRegistrySettings _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="3">
			        <TamperProtectionSettings Action="BLOCK" DisplayNotificationMessage="0" Enabled="1" LockAction="0" LockDisplayNotificationMessage="0" LockEnabled="0" _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="8"/>
			      </TamperRegistrySettings>
			      <TamperFileSettings _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="3">
			        <TamperProtectionSettings Action="BLOCK" DisplayNotificationMessage="0" Enabled="1" LockAction="0" LockDisplayNotificationMessage="0" LockEnabled="0" _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="8"/>
			      </TamperFileSettings>
			      <NotificationMessage _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="3"><![CDATA[$$I18N.PolicyTmpl.TpNotificationMessage$$]]></NotificationMessage>
			    </TamperProtection>
			</TamperProtectionPolicy>
  			<!-- End of Tamper Protection Policy -->
		</SemAgentPolicy>
  	</xsl:template>
  	<!-- This rule is to add  SemLocationConfig $$ID.SLC.3$$ and $$ID.SLC.4$$-->
 	<xsl:template match="SemLocationConfig[@Id='$$ID.SLC.1$$']">
 		<xsl:copy>
        	<xsl:apply-templates select="@*|node()"/>
      	</xsl:copy>
  		<SemLocationConfig Id="$$ID.SLC.3$$" NameSpace="schema" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
			<Metadata Owner="$$ID.SAP.3$$"/>
			<AppliedPolicyArray _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
			  <ObjReference Name="AvPolicyApplied" TargetType="AvPolicy" TargetId="$$ID.AVP.1$$" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
			  <ObjReference Name="FirewallPolicyApplied" TargetType="FwFirewallPolicy" TargetId="$$ID.FWP.1$$" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
			  <ObjReference Name="OpAppProtectionPolicyApplied" TargetType="OpAppProtectionPolicy" TargetId="$$ID.OSP.1$$" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
			  <ObjReference Name="LuPolicyApplied" TargetType="LuPolicy" TargetId="$$ID.LU.1$$" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
                          <ObjReference Name="IdsPolicyApplied" TargetType="IdsPolicy" TargetId="$$ID.IDS.1$$" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
                          <ObjReference Name="PolicyOverrideApplied" TargetType="PolicyOverride" TargetId="$$ID.POR.1$$" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
			</AppliedPolicyArray>
			<UserInterface Mode="SERVER_CTRL" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
				<GeneralGui Enable="1" HideSystemTrayIcon="0" ShowTestButton="0" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
					<MasterSwitchButton Enable="0" ActiveTimer="0" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
					<GuiNotification _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
						<SecurityEventNotification Enable="1" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
					</GuiNotification>
				</GeneralGui>
			</UserInterface>
		</SemLocationConfig>
		<SemLocationConfig Id="$$ID.SLC.4$$" NameSpace="schema" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
			<Metadata Owner="$$ID.SAP.4$$"/>
			<AppliedPolicyArray _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
			  <ObjReference Name="AvPolicyApplied" TargetType="AvPolicy" TargetId="$$ID.AVP.1$$" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
			  <ObjReference Name="FirewallPolicyApplied" TargetType="FwFirewallPolicy" TargetId="$$ID.FWP.1$$" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
			  <ObjReference Name="OpAppProtectionPolicyApplied" TargetType="OpAppProtectionPolicy" TargetId="$$ID.OSP.1$$" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
			  <ObjReference Name="LuPolicyApplied" TargetType="LuPolicy" TargetId="$$ID.LU.1$$" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
              <ObjReference Name="IdsPolicyApplied" TargetType="IdsPolicy" TargetId="$$ID.IDS.1$$" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
              <ObjReference Name="PolicyOverrideApplied" TargetType="PolicyOverride" TargetId="$$ID.POR.1$$" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
              <ObjReference Name="HidPolicyApplied" TargetType="HidPolicy" TargetId="$$ID.HID.1$$" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
			  <ObjReference Name="MemPolicyApplied" TargetType="MemPolicy" TargetId="$$ID.MEM.1$$" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
			  <ObjReference Name="NtrPolicyApplied" TargetType="NtrPolicy" TargetId="$$ID.NTR.1$$" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
			</AppliedPolicyArray>
			<UserInterface Mode="SERVER_CTRL" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
				<GeneralGui Enable="1" HideSystemTrayIcon="0" ShowTestButton="0" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
					<MasterSwitchButton Enable="0" ActiveTimer="0" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
					<GuiNotification _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
						<SecurityEventNotification Enable="1" _d="0" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1"/>
					</GuiNotification>
				</GeneralGui>
			</UserInterface>
		</SemLocationConfig>
  	</xsl:template>
	<xsl:template match="SemLocationConfig[@Id='$$ID.SLC.1$$']/UserInterface/GeneralGui/MasterSwitchButton/@Enable">
		<xsl:attribute name="{name()}">0</xsl:attribute>
	</xsl:template>
</xsl:stylesheet>
