<?xml version="1.0"?>
<xsl:transform version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"> 
	<xsl:output method="xml" omit-xml-declaration="yes" encoding="UTF-8"/>
    
	<!-- Remove unwanted attributes  -->	
	<xsl:template match = "@_i | @_t | @_d | @_v | @NameSpace"/>
    
    <!-- Remove password, PII info  -->		
    <xsl:template match="AdminPassword/text() | NetScanPassword/text() | NetScanPassword2/text()">
		<xsl:call-template name="mask">
			  <xsl:with-param name="input" select="."/>
		</xsl:call-template>
	</xsl:template>
	
    <xsl:template match="@Password | @EncryptedPassword | @UserName | @HostName | @Host | @MasterClientHost ">
		<xsl:attribute name="{name()}">
			<xsl:call-template name="mask">
				<xsl:with-param name="input" select="."/>		  
			</xsl:call-template>
		</xsl:attribute>			
	</xsl:template>
	
	
	<xsl:template name="mask">
		<xsl:param name="input"/>
		<xsl:choose>
				<xsl:when test="string-length($input)!=0">
				<!-- Frame unique ID using string-length's after filtering statistically widely occuring characters -->
					<xsl:value-of select="concat('#',
											string-length($input) - string-length(translate($input, 'A','')),
											string-length($input) - string-length(translate($input, 'ee','')),
											string-length($input) - string-length(translate($input, 'B','')),
											string-length($input) - string-length(translate($input, 'tT','')),
											string-length($input) - string-length(translate($input, 'C','')),
											string-length($input) - string-length(translate($input, 'nN','')),
											string-length($input) - string-length(translate($input, 'D','')),
											string-length($input) - string-length(translate($input, 'sS','')),
											string-length($input) - string-length(translate($input, 'E','')),
											string-length($input) - string-length(translate($input, 'hH','')),
											string-length($input), 											
											string-length($input) - string-length(translate($input, 'F','')),
											string-length($input) - string-length(translate($input, 'aeiouAEIOU','')),
											string-length($input) - string-length(translate($input, ' @0123456789','')),
											string-length($input) - string-length(translate($input, 'èôŒœÖÙûü','')),
											string-length($input) - string-length(translate($input, 'àçéÔöùÛÜ','')),
											string-length($input) - string-length(translate($input, substring($input, string-length($input) mod 3, 3), '')),
											string-length($input) - string-length(translate($input, substring($input, string-length($input) mod 5, 1), '')),											
										'#')" />
				</xsl:when>
		</xsl:choose> 		
	</xsl:template> 
	

    <!-- Copy rest of the items -->
    <xsl:template match="@* | node()">
		<xsl:copy>
		  <xsl:apply-templates select="@* | node()"/>
		</xsl:copy>
	</xsl:template>
 
</xsl:transform>