<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" indent="yes" cdata-section-elements="NotificationMessage MessageBody InfectionInfo"/>
	<xsl:template match="@*|node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="SchemaContainer/SchemaContainer/AvPolicy[@Id='$$ID.AVP.1$$']/AvAutoProtect/AvFileAp/ApFileScanDetails/DriveTypes/@EnableNetworkDrive">
      <xsl:attribute name="{name()}">0</xsl:attribute>
  </xsl:template>
  <xsl:template match="SchemaContainer/SchemaContainer/AvPolicy[@Id='$$ID.AVP.1$$']/AvAutoProtect/AvFileAp/ApFileScanDetails/DriveTypes/@LockEnableNetworkDrive">
      <xsl:attribute name="{name()}">0</xsl:attribute>
  </xsl:template>
  <xsl:template match="SchemaContainer/SchemaContainer/AvPolicy[@Id='$$ID.AVP.HIGH$$']/AvAutoProtect/AvFileAp/ApFileScanDetails/DriveTypes/@EnableNetworkDrive">
      <xsl:attribute name="{name()}">1</xsl:attribute>
  </xsl:template>
  <xsl:template match="SchemaContainer/SchemaContainer/AvPolicy[@Id='$$ID.AVP.HIGH$$']/AvAutoProtect/AvFileAp/ApFileScanDetails/DriveTypes/@LockEnableNetworkDrive">
      <xsl:attribute name="{name()}">0</xsl:attribute>
  </xsl:template>
  <xsl:template match="SchemaContainer/SchemaContainer/AvPolicy[@Id='$$ID.AVP.LIGHT$$']/AvAutoProtect/AvFileAp/ApFileScanDetails/DriveTypes/@EnableNetworkDrive">
      <xsl:attribute name="{name()}">0</xsl:attribute>
  </xsl:template>
  <xsl:template match="SchemaContainer/SchemaContainer/AvPolicy[@Id='$$ID.AVP.LIGHT$$']/AvAutoProtect/AvFileAp/ApFileScanDetails/DriveTypes/@LockEnableNetworkDrive">
      <xsl:attribute name="{name()}">0</xsl:attribute>
  </xsl:template>
  <xsl:template match="SchemaContainer/SchemaContainer/AvPolicy[@Id='$$ID.AVP.1$$']/HppPolicy/BASHPolicy/BASHConfidenceSettings/BASHLowConfidence/@LowConfidenceAction">
      <xsl:attribute name="{name()}">DISABLED</xsl:attribute>
  </xsl:template>
  <xsl:template match="SchemaContainer/SchemaContainer/AvPolicy[@Id='$$ID.AVP.LIGHT$$']/HppPolicy/BASHPolicy/BASHConfidenceSettings/BASHLowConfidence/@LowConfidenceAction">
      <xsl:attribute name="{name()}">DISABLED</xsl:attribute>
  </xsl:template>  
  <xsl:template match="SchemaContainer/SchemaContainer/AvPolicy/HppPolicy/BASHPolicy/HppNotifications/@DisplayAlert">
      <xsl:attribute name="{name()}">0</xsl:attribute>
  </xsl:template>
  <xsl:template match="SchemaContainer/SchemaContainer/AvPolicy/HppPolicy/HppNotifications/@DisplayAlert">
      <xsl:attribute name="{name()}">0</xsl:attribute>
  </xsl:template>
  <xsl:template match="SchemaContainer/SchemaContainer/LuPolicy/@Name">
      <xsl:attribute name="{name()}">$$I18N.DefaultSPlcyTp.LuPolicy.NAME$$.sb</xsl:attribute>
  </xsl:template>
  <xsl:template match="SchemaContainer/SchemaContainer/FwFirewallPolicy[@Id='$$ID.FWP.1$$']/FirewallRuleSystem/BaselineFirewallRuleArray/FirewallRule[position()=21]">
      <!-- Rule No#22. Rule addded in DC (Low, Medium, High) EE Fresh install won't have security level, SBE will have this rule -->
      <!--  In Amber changing it to high level rule by default for Small business edition.  Refer #defect 2294698-->
          <FirewallRule RuleType="H" Enable="1" Id="$$AUTOID$$" Name="$$I18N.PolicyHighSecurityLevelDescription.NAME$$" Severity="5" _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="1">
            <TriggerCondition _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="2">
             <FwServiceTrigger _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="2">
                <FwProtocolContainer ContainerName="" Enable="1" _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="2">
                  <RawIp FollowingFragment="0" ProtocolNumber="" _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="2"/>
                </FwProtocolContainer>
              </FwServiceTrigger>
               <FwNetworkInterfaceTrigger _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="2">
                <ObjReference Name="All Adapters" TargetId="$$ID.FWNIG.1$$" TargetType="FwNetworkInterfaceGroup" _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="3"/>
              </FwNetworkInterfaceTrigger>
              <FwScreenSaverTrigger _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="2"/>
            </TriggerCondition>
            <Action _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="2">
              <PacketProcess PacketProcess="DROP" _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="2"/>
              <LogProcess _d="false" _i="$$AUTOID$$" _t="$$AUTOTIME$$" _v="2"/>
            </Action>
          </FirewallRule>
		  <xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		  </xsl:copy>
  </xsl:template>   
  <xsl:template match="SchemaContainer/SchemaContainer/FwFirewallPolicy[@Id='$$ID.FWP.1$$']/SecuritySetting/FwPortScan/@Enable">
      <xsl:attribute name="{name()}">0</xsl:attribute>
  </xsl:template>
  <xsl:template match="SchemaContainer/SchemaContainer/FwFirewallPolicy[@Id='$$ID.FWP.1$$']/SecuritySetting/FwDosProtection/@Enable">
      <xsl:attribute name="{name()}">0</xsl:attribute>
  </xsl:template>
  <xsl:template match="SchemaContainer/SchemaContainer/FwFirewallPolicy[@Id='$$ID.FWP.2$$']">
   <!--  SBE should not include the Quarantine Firewall Policy -->   
   </xsl:template>
  <xsl:template match="SchemaContainer/AvPolicy[@Id='$$ID.AVP.1$$']/AvAutoProtect/MsftExchangeAp/@Enable">
	<xsl:attribute name="{name()}">1</xsl:attribute>
  </xsl:template>
  <xsl:template match="SchemaContainer/AvPolicy[@Id='$$ID.AVP.1$$']/AvAutoProtect/WebMailAp/@Enable">
	<xsl:attribute name="{name()}">1</xsl:attribute>
  </xsl:template>
  <xsl:template match="SchemaContainer/OpAppProtectionPolicy[@Name='$$I18N.DefaultSPlcyTp.OpAppProtectionPolicy.1.NAME$$']/@Enable">
	<xsl:attribute name="{name()}">0</xsl:attribute>
  </xsl:template>
</xsl:stylesheet>
