<!--
Copyright (c) 2020 Broadcom. All rights reserved. The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.

This software and all information contained therein is confidential and proprietary and shall not be 
duplicated, used, disclosed or disseminated in any way except as authorized by the applicable license 
agreement, without the express written permission of Broadcom. All authorized reproductions must be marked 
with this language.

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED BY APPLICABLE LAW OR 
AS AGREED BY BROADCOM IN ITS APPLICABLE LICENSE AGREEMENT, BROADCOM PROVIDES THIS DOCUMENTATION "AS IS" 
WITHOUT WARRANTY OF ANY KIND, INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY, 
FITNESS FOR A PARTICULAR PURPOSE, OR NONINFRINGEMENT. IN NO EVENT WILL BROADCOM BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF THIS DOCUMENTATION, INCLUDING 
WITHOUT LIMITATION, LOST PROFITS, LOST INVESTMENT, BUSINESS INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF 
BROADCOM IS EXPRESSLY ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH LOSS OR DAMAGE.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" >
<xsl:output method="html"/>
<xsl:param name="fontName" select="'tahoma,arial,helvetica,sans-serif'"/>
<xsl:template match="/ClientGroupProperties">
<HTML>
<HEAD>
	<style type="text/css">
	%CSSSTYLE%
	</style>
</HEAD>

<BODY>

<TABLE width="100%" border="0" valign='top'>
  <TR>
    <TD align='left'>
      <TABLE width="100%" border='0' cellspacing='1' align='left'  valign='middle'>
          <TR class="adminBasePanelTRWithBg" BGCOLOR="%STRIPE_COLOR%">
            <TD><xsl:value-of select="/ClientGroupProperties/TableInfo/GroupID/@Info"/></TD><TD>%GROUP_ID%</TD>
          </TR>
        <TR>
          <TD  width='150'><xsl:value-of select="/ClientGroupProperties/TableInfo/GroupName/@Info"/></TD><TD>%GROUP_NAME%</TD>
        </TR>	
        <TR class="adminBasePanelTRWithBg" BGCOLOR="%STRIPE_COLOR%">
            <TD><xsl:value-of select="/ClientGroupProperties/TableInfo/Description/@Info"/></TD><TD>%GROUP_DESCRIPTION%</TD>
          </TR>
          <TR>
            <TD><xsl:value-of select="/ClientGroupProperties/TableInfo/FullPathName/@Info"/></TD><TD>%GROUP_FULL_PATHNAME%</TD>
          </TR>
          <TR class="adminBasePanelTRWithBg" BGCOLOR="%STRIPE_COLOR%">
            <TD><xsl:value-of select="/ClientGroupProperties/TableInfo/NoOfPhysicalComputers/@Info"/></TD><TD>%GROUP_NUM_PHYSICAL_COMPUTERS%</TD>
          </TR>
          <TR>
            <TD><xsl:value-of select="/ClientGroupProperties/TableInfo/NoOfRegisteredUsers/@Info"/></TD><TD>%GROUP_NUM_REGISTERED_USERS%</TD>
          </TR>
          <TR class="adminBasePanelTRWithBg" BGCOLOR="%STRIPE_COLOR%">
            <TD><xsl:value-of select="/ClientGroupProperties/TableInfo/CreatedBy/@Info"/></TD><TD>%GROUP_CREATOR%</TD>
          </TR>
          <TR>
            <TD><xsl:value-of select="/ClientGroupProperties/TableInfo/CreationDate/@Info"/></TD><TD>%GROUP_CREATION_TIME%</TD>
          </TR>
          <TR class="adminBasePanelTRWithBg" BGCOLOR="%STRIPE_COLOR%">
            <TD><xsl:value-of select="/ClientGroupProperties/TableInfo/ModificationDate/@Info"/></TD><TD>%GROUP_MODIFIED_TIME%</TD>
          </TR>
          <TR>
            <TD><xsl:value-of select="/ClientGroupProperties/TableInfo/ProfileSerialNumber/@Info"/></TD><TD>%GROUP_PROFILE_SERIAL_NUMBER%</TD>
          </TR>
          <TR class="adminBasePanelTRWithBg" BGCOLOR="%STRIPE_COLOR%">
	    <TD><xsl:value-of select="/ClientGroupProperties/TableInfo/ProfileDate/@Info"/></TD><TD>%GROUP_PROFILE_POLICY_DATE%</TD>
          </TR>
	  <xsl:if test="@ProductName!='SNAC'">
	  <TR>
            <TD  width='375'><xsl:value-of select="/ClientGroupProperties/TableInfo/IntrusionPreventionChecksum/@Info"/></TD><TD>%GROUP_SIGNATURE_FILE_SERIAL_NUMBER%</TD>
          </TR>

          <TR class="adminBasePanelTRWithBg" BGCOLOR="%STRIPE_COLOR%">
            <TD><xsl:value-of select="/ClientGroupProperties/TableInfo/BlockNewUserComputer/@Info"/></TD><TD>%GROUP_BLOCK_NEW_CLIENT%</TD>
          </TR>          
	  </xsl:if>
      </TABLE>
    </TD>
  </TR>
</TABLE>

</BODY>
</HTML>
</xsl:template>
</xsl:stylesheet>