<!--
Copyright (c) 2020 Broadcom. All rights reserved. The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.

This software and all information contained therein is confidential and proprietary and shall not be 
duplicated, used, disclosed or disseminated in any way except as authorized by the applicable license 
agreement, without the express written permission of Broadcom. All authorized reproductions must be marked 
with this language.

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED BY APPLICABLE LAW OR 
AS AGREED BY BROADCOM IN ITS APPLICABLE LICENSE AGREEMENT, BROADCOM PROVIDES THIS DOCUMENTATION "AS IS" 
WITHOUT WARRANTY OF ANY KIND, INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY, 
FITNESS FOR A PARTICULAR PURPOSE, OR NONINFRINGEMENT. IN NO EVENT WILL BROADCOM BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF THIS DOCUMENTATION, INCLUDING 
WITHOUT LIMITATION, LOST PROFITS, LOST INVESTMENT, BUSINESS INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF 
BROADCOM IS EXPRESSLY ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH LOSS OR DAMAGE.
-->
	
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" >
<xsl:output method="html"/>
<xsl:param name="fontName" select="'tahoma,arial,helvetica,sans-serif'"/>

<xsl:template match="/GroupPolicy">
<html>
<head>
	<style type="text/css">
	<xsl:text disable-output-escaping="yes">BODY{background-color: &amp;ffffff; color: &amp;000;margin:0px 0px 0px 0px;}</xsl:text>
	<xsl:text disable-output-escaping="yes">  a{font-family:</xsl:text>
	<xsl:value-of select="$fontName"/>
	<xsl:text disable-output-escaping="yes">;font-size:9px; }</xsl:text>
	</style>
</head>
<body>

<table width="100%" valign="top" style="font-family:{$fontName};font-size:9px" border="0">
<tr>
<td>

<table width="100%">
<tr>
	<td>
		<table width="100%">
		<tr>
			<td><font color="#ff6600" size="5"><b><xsl:value-of select="/GroupPolicy/TableInfo/AgentPolicyAt/@Info"/><xsl:apply-templates select="@Name"/></b></font></td>
			<td rowspan="2" width="260" align="right">
				<table cellpadding="1" bgcolor="#7E7E7E" width="100%" valign="bottom">
				<tr><td>
					<table width="100%" bgcolor="#ffffcc">
					<tr>
						<td width="30%" nowrap="nowrap"><xsl:value-of select="/GroupPolicy/TableInfo/PolicySerialNo/@Info"/></td>
						<td><xsl:apply-templates select="@PolicySN"/></td>
					</tr>
					<tr>
						<td width="30%" nowrap="nowrap"><xsl:value-of select="/GroupPolicy/TableInfo/PolicyDate/@Info"/></td>
						<td><xsl:apply-templates select="@PolicyDate"/></td>
					</tr>
					<!--
					<tr>
						<td width="30%" nowrap="nowrap"><xsl:value-of select="/GroupPolicy/TableInfo/PolicySize/@Info"/></td>
						<td><xsl:apply-templates select="@PolicySize"/> </td>
					</tr>
					-->
					<xsl:if test="count(@IDSSN)>0">
					<tr>
						<td width="30%" nowrap="nowrap"><xsl:value-of select="/GroupPolicy/TableInfo/IPSSerialNo/@Info"/></td>
						<td><xsl:apply-templates select="@IDSSN"/></td>
					</tr>
					</xsl:if>
					</table>
				</td>
				</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td>
				<xsl:choose>
				<xsl:when test="@IsGlobal='false'">
					<xsl:text disable-output-escaping="yes">&lt;a href="#inherit"&gt;</xsl:text>
					<xsl:choose>
					<xsl:when test="@Inherit='true'">
						<img src="checkedbox.gif" width="12" height="12" border="0"/>
					</xsl:when>
					<xsl:otherwise>
						<img src="uncheckedbox.gif" width="12" height="12" border="0"/>
					</xsl:otherwise>
					</xsl:choose>
					<xsl:text disable-output-escaping="yes">&lt;/a&gt;&amp;nbsp;&amp;nbsp;</xsl:text>
					 <xsl:value-of select="/GroupPolicy/TableInfo/UseSamePolicyAsParentGroup/@Info"/>
				</xsl:when>
				</xsl:choose>
			</td>
		</tr>
		</table>
		<hr/>
	</td>
</tr>
<tr>
	<td>
		<table width="100%">
		<tr>
			<td>
				<table width="100%">
				<tr>
					<td width="100%">
						<table width="100%">
						<tr>
							<td width="48"><img src="ECam.gif" width="28" height="28" border="0"/></td>
							<td align="left" style="font-size:16px;color:#3399ff"><xsl:value-of select="/GroupPolicy/TableInfo/LocationOverview/@Info"/></td>
						</tr>
						</table>
					</td>
				</tr>
	<xsl:for-each select="Location">
	<tr>
		<td>
		<table width="100%" cellpadding="1" bgcolor="#3399ff">
		<tr><td>
		<table width="100%" valign="top" bgcolor="#ffffff">
		<tr>
			<xsl:choose>
			<xsl:when test="@Enabled='true'">
			<td colspan="4" bgcolor="#3399ff" style="font-size:11px;color:#ffffff;font-weight:bold;">
			<xsl:value-of select="/GroupPolicy/TableInfo/Location/@Info"/><xsl:apply-templates select="@Name"/>
			</td>
			</xsl:when>
			<xsl:otherwise>
			<td colspan="4" bgcolor="#808080" style="font-size:11px;color:#ffffff;font-weight:bold;">
			Location: <xsl:apply-templates select="@Name"/>
			</td>
			</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
			<xsl:when test="@Enabled='true'">
			<xsl:text disable-output-escaping="yes">&lt;td bgcolor="#3399ff" align="right" width="20"&gt;</xsl:text>
			</xsl:when>
			<xsl:otherwise>
			<xsl:text disable-output-escaping="yes">&lt;td bgcolor="#808080" align="right" width="20"&gt;</xsl:text>
			</xsl:otherwise>
			</xsl:choose>
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">;ExpandLoc</xsl:text>
			
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="@ExpandLoc"/>
			<xsl:text disable-output-escaping="yes">#loc_expand"&gt;</xsl:text>
			<xsl:choose>
			<xsl:when test="@ExpandLoc='true'">
			<img src="icon_bttnCllps.gif" width="16" height="16" border="0"/>
			</xsl:when>
			<xsl:otherwise>
			<img width="16" height="16" src="icon_bttnExpnd.gif" border="0"/>
			</xsl:otherwise>
			</xsl:choose>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			<xsl:text disable-output-escaping="yes">&lt;/td&gt;</xsl:text>
		</tr>
		<xsl:if test="@ExpandLoc='true'">
		<tr>
			<td width="5"></td>
			<td colspan="2" bgcolor="#d6ebff" style="font-weight:bold;"><xsl:value-of select="/GroupPolicy/TableInfo/SwitchToThisLocationWhen/@Info"/></td>
			<td bgcolor="#d6ebff" align="right" nowrap="nowrap">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">#edit_location"&gt;</xsl:text>
			<xsl:value-of select="/GroupPolicy/TableInfo/Edit/@Info"/>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
			<td align="right" bgcolor="#d6ebff">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">;ExpandLocCondition</xsl:text>
			
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="@ExpandLocCondition"/>
			<xsl:text disable-output-escaping="yes">#loc_expand"&gt;</xsl:text>
			<xsl:choose>
			<xsl:when test="@ExpandLocCondition='true'">
			<img src="icon_bttnCllps.gif" width="16" height="16" border="0"/>
			</xsl:when>
			<xsl:otherwise>
			<img width="16" height="16" src="icon_bttnExpnd.gif" border="0"/>
			</xsl:otherwise>
			</xsl:choose>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
		</tr>
		<xsl:if test="@ExpandLocCondition='true'">
		<tr>
			<td width="5"></td>
			<td width="20"></td>
			<td>
			<xsl:choose>
			<xsl:when test="count(AlSignature)=0">
			<xsl:value-of select="/GroupPolicy/TableInfo/NoConditionSpecifiedForThisLocation/@Info"/><xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
			</xsl:when>
			<xsl:otherwise>
			<xsl:for-each select="AlSignature">
				<xsl:if test="position()>1">
					<xsl:text disable-output-escaping="yes">&lt;b&gt;</xsl:text>
					<xsl:value-of select="/GroupPolicy/TableInfo/AND/@Info"/>
					<xsl:text disable-output-escaping="yes">&lt;/b&gt;&amp;nbsp;</xsl:text>
				</xsl:if>
				<xsl:for-each select="Address">
				<xsl:if test="position()>1">
					<xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;&lt;b&gt;</xsl:text>
					<xsl:value-of select="/GroupPolicy/TableInfo/OR/@Info"/>
					<xsl:text disable-output-escaping="yes">&lt;/b&gt;&amp;nbsp;</xsl:text>
				</xsl:if>
				<xsl:value-of select="." disable-output-escaping="yes"/><br/>
				</xsl:for-each>
			</xsl:for-each>
			</xsl:otherwise>
			</xsl:choose>
			</td>
			<td align="right"></td>
			<td align="right"></td>
		</tr>
		</xsl:if>
		<tr>
			<td width="5"></td>
			<td colspan="2" bgcolor="#d6ebff" style="font-weight:bold;"><xsl:value-of select="/GroupPolicy/TableInfo/Policies/@Info"/></td>
			<td bgcolor="#d6ebff" align="right" nowrap="nowrap">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">;normal#add_more_policy"&gt;</xsl:text>
			<xsl:value-of select="/GroupPolicy/TableInfo/Add/@Info"/>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
			<td align="right" bgcolor="#d6ebff">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">;ExpandPolicy</xsl:text>
			
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="@ExpandPolicy"/>
			<xsl:text disable-output-escaping="yes">#loc_expand"&gt;</xsl:text>
			<xsl:choose>
			<xsl:when test="@ExpandPolicy='true'">
			<img src="icon_bttnCllps.gif" width="16" height="16" border="0"/>
			</xsl:when>
			<xsl:otherwise>
			<img width="16" height="16" src="icon_bttnExpnd.gif" border="0"/>
			</xsl:otherwise>
			</xsl:choose>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
		</tr>
		<xsl:if test="@ExpandPolicy='true'">
		<xsl:if test="(count(FirewallPolicy)=0) and (count(HostIntegrityPolicy)=0) and (count(OSProtectionPolicy)=0) and (count(AvPolicy)=0) and (count(OverridePolicy)=0) and (count(LiveUpdatePolicy)=0) and (count(MemPolicy)=0)  and (count(NtrPolicy)=0)">
		<tr>
			<td width="5"></td>
			<td width="20"></td>
			<td><xsl:value-of select="/GroupPolicy/TableInfo/NoPolicyAppliedToThisLocation/@Info"/></td>
			<td></td>
			<td></td>
		</tr>
		</xsl:if>
		<xsl:if test="count(AvPolicy)>0">
		<tr>
			<td width="5"></td>
			<xsl:choose>
			<xsl:when test="AvPolicy/@IsLocalPolicy='true'">
			<td width="20"><img src="icon_FW_policy.gif" width="16" height="16" border="0"/></td>
			</xsl:when>
			<xsl:otherwise>
			<td width="20"><img src="fw_policy_lib2.gif" width="16" height="16" border="0"/></td>
			</xsl:otherwise>
			</xsl:choose>
			<td><xsl:value-of select="AvPolicy/@Description"/></td>
			<td align="right" nowrap="nowrap">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?AvPolicy;AvPolicyApplied;</xsl:text>
			<xsl:value-of select="AvPolicy/@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="AvPolicy/@IsLocalPolicy"/>
			<xsl:text disable-output-escaping="yes">#edit_policy"&gt;</xsl:text>
			<xsl:value-of select="/GroupPolicy/TableInfo/Edit/@Info"/>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
			<td align="right">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?AvPolicy;AvPolicyApplied;</xsl:text>
			<xsl:value-of select="AvPolicy/@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="AvPolicy/@IsLocalPolicy"/>
			<xsl:text disable-output-escaping="yes">#more_options"&gt;</xsl:text>
			<img src="icon_bttnMore.gif" width="16" height="16" border="0"/>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
		</tr>
		</xsl:if>
		<xsl:if test="count(FirewallPolicy)>0">
		<tr>
			<td width="5"></td>
			<xsl:choose>
			<xsl:when test="FirewallPolicy/@IsLocalPolicy='true'">
			<td width="20"><img src="icon_FW_policy.gif" width="16" height="16" border="0"/></td>
			</xsl:when>
			<xsl:otherwise>
			<td width="20"><img src="fw_policy_lib2.gif" width="16" height="16" border="0"/></td>
			</xsl:otherwise>
			</xsl:choose>
			<td><xsl:value-of select="FirewallPolicy/@Description"/></td>
			<td align="right" nowrap="nowrap">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?FwFirewallPolicy;FirewallPolicyApplied;</xsl:text>
			<xsl:value-of select="FirewallPolicy/@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="FirewallPolicy/@IsLocalPolicy"/>
			<xsl:text disable-output-escaping="yes">#edit_policy"&gt;</xsl:text>
			<xsl:value-of select="/GroupPolicy/TableInfo/Edit/@Info"/>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
			<td align="right">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?FwFirewallPolicy;FirewallPolicyApplied;</xsl:text>
			<xsl:value-of select="FirewallPolicy/@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="FirewallPolicy/@IsLocalPolicy"/>
			<xsl:text disable-output-escaping="yes">#more_options"&gt;</xsl:text>
			<img src="icon_bttnMore.gif" width="16" height="16" border="0"/>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
		</tr>
		</xsl:if>
		<xsl:if test="count(HostIntegrityPolicy)>0">
		<tr>
			<td width="5"></td>
			<xsl:choose>
			<xsl:when test="HostIntegrityPolicy/@IsLocalPolicy='true'">
			<td width="20"><img src="icon_HI_policy.gif" width="16" height="16" border="0"/></td>
			</xsl:when>
			<xsl:otherwise>
			<td width="20"><img src="hi_policy_lib2.gif" width="16" height="16" border="0"/></td>
			</xsl:otherwise>
			</xsl:choose>
			<td><xsl:value-of select="HostIntegrityPolicy/@Description"/></td>
			<td align="right" nowrap="nowrap">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?HiHostIntegrityPolicy;HostIntegrityApplied;</xsl:text>
			<xsl:value-of select="HostIntegrityPolicy/@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="HostIntegrityPolicy/@IsLocalPolicy"/>
			<xsl:text disable-output-escaping="yes">#edit_policy"&gt;</xsl:text>
			<xsl:value-of select="/GroupPolicy/TableInfo/Edit/@Info"/>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
			<td align="right">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?HiHostIntegrityPolicy;HostIntegrityApplied;</xsl:text>
			<xsl:value-of select="HostIntegrityPolicy/@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="HostIntegrityPolicy/@IsLocalPolicy"/>
			<xsl:text disable-output-escaping="yes">#more_options"&gt;</xsl:text>
			<img src="icon_bttnMore.gif" width="16" height="16" border="0"/>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
		</tr>
		</xsl:if>

		<xsl:if test="count(OSProtectionPolicy)>0">
		<tr>
			<td width="5"></td>
			<xsl:choose>
			<xsl:when test="OSProtectionPolicy/@IsLocalPolicy='true'">
			<td width="20"><img src="icon_os_policy.gif" width="16" height="16" border="0"/></td>
			</xsl:when>
			<xsl:otherwise>
			<td width="20"><img src="os_policy_lib2.gif" width="16" height="16" border="0"/></td>
			</xsl:otherwise>
			</xsl:choose>
			<td><xsl:value-of select="OSProtectionPolicy/@Description"/></td>
			<td align="right" nowrap="nowrap">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?OpAppProtectionPolicy;OpAppProtectionPolicyApplied;</xsl:text>
			<xsl:value-of select="OSProtectionPolicy/@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="OSProtectionPolicy/@IsLocalPolicy"/>
			<xsl:text disable-output-escaping="yes">#edit_policy"&gt;</xsl:text>
			<xsl:value-of select="/GroupPolicy/TableInfo/Edit/@Info"/>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
			<td align="right">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?OpAppProtectionPolicy;OpAppProtectionPolicyApplied;</xsl:text>
			<xsl:value-of select="OSProtectionPolicy/@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="OSProtectionPolicy/@IsLocalPolicy"/>
			<xsl:text disable-output-escaping="yes">#more_options"&gt;</xsl:text>
			<img src="icon_bttnMore.gif" width="16" height="16" border="0"/>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
		</tr>

		</xsl:if>
		<xsl:if test="count(OverridePolicy)>0">
		<tr>
			<td width="5"></td>
			<xsl:choose>
			<xsl:when test="OverridePolicy/@IsLocalPolicy='true'">
			<td width="20"><img src="icon_FW_policy.gif" width="16" height="16" border="0"/></td>
			</xsl:when>
			<xsl:otherwise>
			<td width="20"><img src="fw_policy_lib2.gif" width="16" height="16" border="0"/></td>
			</xsl:otherwise>
			</xsl:choose>
			<td><xsl:value-of select="OverridePolicy/@Description"/></td>
			<td align="right" nowrap="nowrap">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?PolicyOverride;PolicyOverrideApplied;</xsl:text>
			<xsl:value-of select="OverridePolicy/@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="OverridePolicy/@IsLocalPolicy"/>
			<xsl:text disable-output-escaping="yes">#edit_policy"&gt;</xsl:text>
			<xsl:value-of select="/GroupPolicy/TableInfo/Edit/@Info"/>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
			<td align="right">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?PolicyOverride;PolicyOverrideApplied;</xsl:text>
			<xsl:value-of select="OverridePolicy/@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="OverridePolicy/@IsLocalPolicy"/>
			<xsl:text disable-output-escaping="yes">#more_options"&gt;</xsl:text>
			<img src="icon_bttnMore.gif" width="16" height="16" border="0"/>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
		</tr>
		</xsl:if>
                <xsl:if test="count(HidPolicy)>0">
		<tr>
			<td width="5"></td>
			<xsl:choose>
			<xsl:when test="HidPolicy/@IsLocalPolicy='true'">
			<td width="20"><img src="icon_FW_policy.gif" width="16" height="16" border="0"/></td>
			</xsl:when>
			<xsl:otherwise>
			<td width="20"><img src="fw_policy_lib2.gif" width="16" height="16" border="0"/></td>
			</xsl:otherwise>
			</xsl:choose>
			<td><xsl:value-of select="HidPolicy/@Description"/></td>
			<td align="right" nowrap="nowrap">
			</td>
			
		</tr>
		</xsl:if>
		<xsl:if test="count(LiveUpdatePolicy)>0">
		<tr>
			<td width="5"></td>
			<xsl:choose>
			<xsl:when test="LiveUpdatePolicy/@IsLocalPolicy='true'">
			<td width="20"><img src="icon_FW_policy.gif" width="16" height="16" border="0"/></td>
			</xsl:when>
			<xsl:otherwise>
			<td width="20"><img src="fw_policy_lib2.gif" width="16" height="16" border="0"/></td>
			</xsl:otherwise>
			</xsl:choose>
			<td><xsl:value-of select="LiveUpdatePolicy/@Description"/></td>
			<td align="right" nowrap="nowrap">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?LuPolicy;LuPolicyApplied;</xsl:text>
			<xsl:value-of select="LiveUpdatePolicy/@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="LiveUpdatePolicy/@IsLocalPolicy"/>
			<xsl:text disable-output-escaping="yes">#edit_policy"&gt;</xsl:text>
			<xsl:value-of select="/GroupPolicy/TableInfo/Edit/@Info"/>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
			<td align="right">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?LuPolicy;LuPolicyApplied;</xsl:text>
			<xsl:value-of select="LiveUpdatePolicy/@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="LiveUpdatePolicy/@IsLocalPolicy"/>
			<xsl:text disable-output-escaping="yes">#more_options"&gt;</xsl:text>
			<img src="icon_bttnMore.gif" width="16" height="16" border="0"/>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
		</tr>
		</xsl:if>
			<xsl:if test="count(MemPolicy)>0">
		<tr>
			<td width="5"></td>
			<xsl:choose>
			<xsl:when test="MemPolicy/@IsLocalPolicy='true'">
			<td width="20"><img src="icon_FW_policy.gif" width="16" height="16" border="0"/></td>
			</xsl:when>
			<xsl:otherwise>
			<td width="20"><img src="fw_policy_lib2.gif" width="16" height="16" border="0"/></td>
			</xsl:otherwise>
			</xsl:choose>
			<td><xsl:value-of select="MemPolicy/@Description"/></td>
			<td align="right" nowrap="nowrap">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?MemPolicy;MemPolicyApplied;</xsl:text>
			<xsl:value-of select="MemPolicy/@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="MemPolicy/@IsLocalPolicy"/>
			<xsl:text disable-output-escaping="yes">#edit_policy"&gt;</xsl:text>
			<xsl:value-of select="/GroupPolicy/TableInfo/Edit/@Info"/>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
			<td align="right">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?MemPolicy;MemPolicyApplied;</xsl:text>
			<xsl:value-of select="MemPolicy/@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="MemPolicy/@IsLocalPolicy"/>
			<xsl:text disable-output-escaping="yes">#more_options"&gt;</xsl:text>
			<img src="icon_bttnMore.gif" width="16" height="16" border="0"/>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
		</tr>
		</xsl:if>
		
		<xsl:if test="count(NtrPolicy)>0">
		<tr>
			<td width="5"></td>
			<xsl:choose>
			<xsl:when test="NtrPolicy/@IsLocalPolicy='true'">
			<td width="20"><img src="icon_FW_policy.gif" width="16" height="16" border="0"/></td>
			</xsl:when>
			<xsl:otherwise>
			<td width="20"><img src="fw_policy_lib2.gif" width="16" height="16" border="0"/></td>
			</xsl:otherwise>
			</xsl:choose>
			<td><xsl:value-of select="NtrPolicy/@Description"/></td>
			<td align="right" nowrap="nowrap">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?NtrPolicy;NtrPolicyApplied;</xsl:text>
			<xsl:value-of select="NtrPolicy/@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="NtrPolicy/@IsLocalPolicy"/>
			<xsl:text disable-output-escaping="yes">#edit_policy"&gt;</xsl:text>
			<xsl:value-of select="/GroupPolicy/TableInfo/Edit/@Info"/>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
			<td align="right">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?NtrPolicy;NtrPolicyApplied;</xsl:text>
			<xsl:value-of select="NtrPolicy/@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="NtrPolicy/@IsLocalPolicy"/>
			<xsl:text disable-output-escaping="yes">#more_options"&gt;</xsl:text>
			<img src="icon_bttnMore.gif" width="16" height="16" border="0"/>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
		</tr>
		</xsl:if>
		
		</xsl:if>		
		
		<xsl:if test="@HasQuarantine='true'">
		<tr>
			<td width="5"></td>
			<td colspan="2" bgcolor="#d6ebff" style="font-weight:bold"><xsl:value-of select="/GroupPolicy/TableInfo/QuarantinePoliciesWhenHostIntegrityFails/@Info"/></td>
			<td bgcolor="#d6ebff" align="right">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">;quaratine#add_more_policy"&gt;</xsl:text>
			<xsl:value-of select="/GroupPolicy/TableInfo/Add/@Info"/>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
			<td align="right" bgcolor="#d6ebff" width="20">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">;ExpandQuaratinePolicy;</xsl:text>
			<xsl:value-of select="@ExpandQuaratinePolicy"/>
			<xsl:text disable-output-escaping="yes">#loc_expand"&gt;</xsl:text>
			<xsl:choose>
			<xsl:when test="@ExpandQuaratinePolicy='true'">
			<img width="16" height="16" src="icon_bttnCllps.gif" border="0"/>
			</xsl:when>
			<xsl:otherwise>
			<img width="16" height="16" src="icon_bttnExpnd.gif" border="0"/>
			</xsl:otherwise>
			</xsl:choose>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
		</tr>
		<xsl:if test="@ExpandQuaratinePolicy='true'">
		<xsl:if test="count(QuarantineFirewallPolicy)+count(QuarantineOSPPolicy)=0">
		<tr>
			<td width="5"></td>
			<td width="20"></td>
			<td><xsl:value-of select="/GroupPolicy/TableInfo/NoPolicyAppliedToThisLocation/@Info"/></td>
			<td align="right"></td>
			<td align="right"></td>
		</tr>
		</xsl:if>
		<xsl:if test="count(QuarantineFirewallPolicy)>0">
		<tr>
			<td width="5"></td>
			<xsl:choose>
			<xsl:when test="QuarantineFirewallPolicy/@IsLocalPolicy='true'">
			<td width="20"><img src="icon_FW_policy.gif" width="16" height="16" border="0"/></td>
			</xsl:when>
			<xsl:otherwise>
			<td width="20"><img src="fw_policy_lib2.gif" width="16" height="16" border="0"/></td>
			</xsl:otherwise>
			</xsl:choose>
			<td><xsl:value-of select="QuarantineFirewallPolicy/@Description"/></td>
			<td align="right" nowrap="nowrap">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?FwFirewallPolicy;QuarantineFWPolicyApplied;</xsl:text>
			<xsl:value-of select="QuarantineFirewallPolicy/@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="QuarantineFirewallPolicy/@IsLocalPolicy"/>
			<xsl:text disable-output-escaping="yes">#edit_policy"&gt;</xsl:text>
			<xsl:value-of select="/GroupPolicy/TableInfo/Edit/@Info"/>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
			<td align="right">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?FwFirewallPolicy;QuarantineFWPolicyApplied;</xsl:text>
			<xsl:value-of select="QuarantineFirewallPolicy/@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="QuarantineFirewallPolicy/@IsLocalPolicy"/>
			<xsl:text disable-output-escaping="yes">#more_options"&gt;</xsl:text>
			<img src="icon_bttnMore.gif" width="16" height="16" border="0"/>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
		</tr>
		</xsl:if>
		<xsl:if test="count(QuarantineOSPPolicy)>0">
		<tr>
			<td width="5"></td>
			<xsl:choose>
			<xsl:when test="QuarantineOSPPolicy/@IsLocalPolicy='true'">
			<td width="20"><img src="icon_os_policy.gif" width="16" height="16" border="0"/></td>
			</xsl:when>
			<xsl:otherwise>
			<td width="20"><img src="os_policy_lib2.gif" width="16" height="16" border="0"/></td>
			</xsl:otherwise>
			</xsl:choose>
			<td><xsl:value-of select="QuarantineOSPPolicy/@Description"/></td>
			<td align="right" nowrap="nowrap">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?OpAppProtectionPolicy;QuarantineOSPPolicyApplied;</xsl:text>
			<xsl:value-of select="QuarantineOSPPolicy/@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="QuarantineOSPPolicy/@IsLocalPolicy"/>
			<xsl:text disable-output-escaping="yes">#edit_policy"&gt;</xsl:text>
			<xsl:value-of select="/GroupPolicy/TableInfo/Edit/@Info"/>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
			<td align="right">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?OpAppProtectionPolicy;QuarantineOSPPolicyApplied;</xsl:text>
			<xsl:value-of select="QuarantineOSPPolicy/@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="QuarantineOSPPolicy/@IsLocalPolicy"/>
			<xsl:text disable-output-escaping="yes">#more_options"&gt;</xsl:text>
			<img src="icon_bttnMore.gif" width="16" height="16" border="0"/>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
		</tr>
		</xsl:if>
		</xsl:if>
		</xsl:if>
		<tr>
			<td width="5"></td>
			<td colspan="2" bgcolor="#d6ebff" style="font-weight:bold;"><xsl:value-of select="/GroupPolicy/TableInfo/AdvancedSettings/@Info"/></td>
			<td bgcolor="#d6ebff" align="right" nowrap="nowrap"></td>
			<td align="right" bgcolor="#d6ebff">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">;ExpandAdvancedSetting</xsl:text>			
			<xsl:text disable-output-escaping="yes">;</xsl:text>
			<xsl:value-of select="@ExpandAdvancedSetting"/>
			<xsl:text disable-output-escaping="yes">#loc_expand"&gt;</xsl:text>
			<xsl:choose>
			<xsl:when test="@ExpandAdvancedSetting='true'">
			<img src="icon_bttnCllps.gif" width="16" height="16" border="0"/>
			</xsl:when>
			<xsl:otherwise>
			<img width="16" height="16" src="icon_bttnExpnd.gif" border="0"/>
			</xsl:otherwise>
			</xsl:choose>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
		</tr>
		<xsl:if test="@ExpandAdvancedSetting='true'">
		<tr>
			<td width="5"></td>
			<td width="20"></td>
			<td><xsl:value-of select="/GroupPolicy/TableInfo/CustomizedAgentUserInterface/@Info"/><font color="red">
			<xsl:value-of select="@Mode"/>
			</font></td>
			<td align="right" nowrap="nowrap">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">#edit_mode"&gt;</xsl:text>
			<xsl:value-of select="/GroupPolicy/TableInfo/Edit/@Info"/>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
			<td align="right"></td>
		</tr>
		<tr>
			<td width="5"></td>
			<td width="20"></td>
			<td><xsl:value-of select="/GroupPolicy/TableInfo/CommunicatewithPolicyManager/@Info"/><font color="red">
			<xsl:choose>
			<xsl:when test="@CommunicationSetting='true'"><xsl:value-of select="/GroupPolicy/TableInfo/Group/@Info"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="/GroupPolicy/TableInfo/Local/@Info"/></xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
			<xsl:when test="@mode='PULL'"><xsl:value-of select="/GroupPolicy/TableInfo/Pull/@Info"/></xsl:when>
			<xsl:when test="@mode='PUSH'"><xsl:value-of select="/GroupPolicy/TableInfo/Push/@Info"/></xsl:when>
			<xsl:when test="@mode='NO_COM'"><xsl:value-of select="/GroupPolicy/TableInfo/Standalone/@Info"/></xsl:when>
			</xsl:choose>
			</font></td>
			<td align="right" nowrap="nowrap">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">#communication"&gt;</xsl:text>
			<xsl:value-of select="/GroupPolicy/TableInfo/Edit/@Info"/>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
			<td align="right" >
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">#inheritcom"&gt;</xsl:text>
			<img src="icon_bttnMore.gif" width="16" height="16" border="0"/>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
		</tr>
		<!--  newly added code -->
		<tr>
			<td width="5"></td>
			<td width="20"></td>
			<td><xsl:value-of select="/GroupPolicy/TableInfo/ExternalCommunicationwithPolicyManager/@Info"/><font color="red">
			</font></td>
			<td align="right" nowrap="nowrap">
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">#externalcommunication"&gt;</xsl:text>
			<xsl:value-of select="/GroupPolicy/TableInfo/Edit/@Info"/>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
			<td align="right" >
			<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?</xsl:text>
			<xsl:value-of select="@Id"/>
			<xsl:text disable-output-escaping="yes">#inheritexternalcom"&gt;</xsl:text>
			<img src="icon_bttnMore.gif" width="16" height="16" border="0"/>
			<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
			</td>
		</tr>
		
		</xsl:if>
		</xsl:if>
		</table>
		</td></tr>
		</table>

		</td>
	</tr>
	</xsl:for-each>

		</table>
		</td>

<td width="170" align="right">
	<table cellpadding="1" bgcolor="#3399ff" width="100%">
	<tr><td>
		<table width="100%" valign="top" bgcolor="#ffffff">
		<xsl:if test="@ProductName!='SNAC'">
		<tr>
			<td colspan="2" bgcolor="#3399ff" style="font-size:10px; color:#ffffff"><xsl:value-of select="/GroupPolicy/TableInfo/ProtectionSettings/@Info"/></td>
		</tr>
		<xsl:if test="count(@EnableAppAuthentication)>0">
		<tr>
			<td><img src="icon_bullets1.gif" width="8" height="8" border="0"/><a href="?application authentication#advance_setting"><xsl:value-of select="/GroupPolicy/TableInfo/ApplicationAuthentication/@Info"/></a></td>
			<td>
			<xsl:choose>
			<xsl:when test="@EnableAppAuthentication='true'"><font style="font-family:SansSerif,Arial Narrow,tahoma;color:green;font-weight:bold;"	><xsl:value-of select="/GroupPolicy/TableInfo/ON/@Info"/></font></xsl:when>
			<xsl:otherwise><font style="font-family:SansSerif,Arial Narrow,tahoma;color:gray;font-weight:bold;"><xsl:value-of select="/GroupPolicy/TableInfo/Off/@Info"/></font></xsl:otherwise>
			</xsl:choose>
			</td>
		</tr>
		</xsl:if>
		<xsl:if test="count(@EnableBufferOverrun)>0">
		<tr>
			<td><img src="icon_bullets1.gif" width="8" height="8" border="0"/><a href="?Overflow Protection#advance_setting"><xsl:value-of select="/GroupPolicy/TableInfo/BufferOverflowProtection/@Info"/></a></td>
			<td>
			<xsl:choose>
			<xsl:when test="@EnableBufferOverrun='true'"><font style="font-family:SansSerif,Arial Narrow,tahoma;color:green;font-weight:bold;"><xsl:value-of select="/GroupPolicy/TableInfo/ON/@Info"/></font></xsl:when>
			<xsl:otherwise><font style="font-family:SansSerif,Arial Narrow,tahoma;color:gray;font-weight:bold;"><xsl:value-of select="/GroupPolicy/TableInfo/Off/@Info"/></font></xsl:otherwise>
			</xsl:choose>
			</td>
		</tr>
		</xsl:if>
		<xsl:if test="count(@EnableLockdown)>0">
		<tr>
			<td><img src="icon_bullets1.gif" width="8" height="8" border="0"/><a href="?Lockdown#advance_setting"><xsl:value-of select="/GroupPolicy/TableInfo/SystemLockdown/@Info"/></a></td>
			<td>
			<xsl:choose>
			<xsl:when test="@EnableLockdown='true'"><font style="font-family:SansSerif,Arial Narrow,tahoma;color:green;font-weight:bold;"><xsl:value-of select="/GroupPolicy/TableInfo/ON /@Info"/></font></xsl:when>
			<xsl:otherwise><font style="font-family:SansSerif,Arial Narrow,tahoma;color:gray;font-weight:bold;"><xsl:value-of select="/GroupPolicy/TableInfo/Off/@Info"/></font></xsl:otherwise>
			</xsl:choose>
			</td>
		</tr>
		</xsl:if>
		<tr>
			<td></td>
			<td></td>
		</tr>
		<tr>
			<td><img src="icon_bullets1.gif" width="8" height="8" border="0"/><a href="#howitwork"><xsl:value-of select="/GroupPolicy/TableInfo/HowItWorks/@Info"/></a></td>
			<td></td>
		</tr>
		</xsl:if>
		<tr>
			<td colspan="2" bgcolor="#3399ff" style="font-size:10px; color:#ffffff"><xsl:value-of select="/GroupPolicy/TableInfo/OtherSettings/@Info"/></td>
		</tr>
		<xsl:if test="count(@EnableIDS)>0">
		<tr>
			<td><img src="icon_bullets1.gif" width="8" height="8" border="0"/><a href="?Intrusion Prevention#advance_setting"><xsl:value-of select="/GroupPolicy/TableInfo/IPSLibraries/@Info"/></a></td>
			<td>
			</td>
		</tr>
		</xsl:if>
		<tr>
			<td><img src="icon_bullets1.gif" width="8" height="8" border="0"/><a href="?logs#advance_setting"><xsl:value-of select="/GroupPolicy/TableInfo/LogSettings/@Info"/></a></td>
			<td></td>
		</tr>
		<tr>
			<td><img src="icon_bullets1.gif" width="8" height="8" border="0"/><a href="?Communication#advance_setting"><xsl:value-of select="/GroupPolicy/TableInfo/Communication/@Info"/></a></td>
			<td></td>
		</tr>
		<tr>
			<td><img src="icon_bullets1.gif" width="8" height="8" border="0"/><a href="?ExternalCommunication#advance_setting"><xsl:value-of select="/GroupPolicy/TableInfo/ExternalCommunication/@Info"/></a></td>
			<td></td>
		</tr>
		<tr>
			<td><img src="icon_bullets1.gif" width="8" height="8" border="0"/><a href="#advance_setting"><xsl:value-of select="/GroupPolicy/TableInfo/GeneralSettings/@Info"/></a></td>
			<td></td>
		</tr>
		<tr>
			<td><img src="icon_bullets1.gif" width="8" height="8" border="0"/><a href="#lucontentpolicy"><xsl:value-of select="/GroupPolicy/TableInfo/LuContentPolicy/@Info"/></a></td>
			<td></td>
		</tr>
		<tr>
			<td></td>
			<td></td>
		</tr>
	</table>
</td>
	</tr>
	</table>
	</td>
	</tr>
</table>
</td></tr>
</table>

</td>
</tr>
</table>
</body>
</html>

</xsl:template>


</xsl:stylesheet>
