<!--
Copyright (c) 2024 Broadcom. All rights reserved. The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.

This software and all information contained therein is confidential and proprietary and shall not be 
duplicated, used, disclosed or disseminated in any way except as authorized by the applicable license 
agreement, without the express written permission of Broadcom. All authorized reproductions must be marked 
with this language.

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED BY APPLICABLE LAW OR 
AS AGREED BY BROADCOM IN ITS APPLICABLE LICENSE AGREEMENT, BROADCOM PROVIDES THIS DOCUMENTATION "AS IS" 
WITHOUT WARRANTY OF ANY KIND, INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY, 
FITNESS FOR A PARTICULAR PURPOSE, OR NONINFRINGEMENT. IN NO EVENT WILL BROADCOM BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF THIS DOCUMENTATION, INCLUDING 
WITHOUT LIMITATION, LOST PROFITS, LOST INVESTMENT, BUSINESS INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF 
BROADCOM IS EXPRESSLY ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH LOSS OR DAMAGE.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="2.0">
	<xsl:output method="html" />
	<xsl:param name="fontName" select="'tahoma,arial,helvetica,sans-serif'" />
	<xsl:param name="fontSize" select="'9px'" />
	<xsl:param name="disabledColor" select="'#ffffff'" />
	<xsl:param name="enabledColor" select="'#3399ff'" />
	<xsl:param name="expandRowBackground" select="'#d6ebff'" />
	<xsl:param name="onColor" select="'green'" />
	<xsl:param name="offColor" select="$disabledColor" />
	<xsl:param name="hyperlinkColor" select="'#0076a3'" />
	<xsl:param name="hyperlinkHoverColor" select="'#00aeef'" />
	<xsl:param name="upArrow" select="'select_arrow_up.png'" />
	<xsl:param name="downArrow" select="'select_arrow_down.png'" />
	<xsl:param name="cloud" select="'cloud.png'" />
	<xsl:param name="cloud_inherited" select="'icnCloudInheritance_16.png'" />
	<xsl:param name="thirdparty" select="'icnThirdParty_16.png'" />
	<xsl:param name="thirdparty_inherited" select="'icnThirdParty_Inheritance_16.png'" />
	<!--Template to print the policy name -->
	<xsl:template name="printPolicyName">
		<xsl:param name="strPolicyName" />
		<i><xsl:value-of select="$strPolicyName"/></i>
	</xsl:template>

	<xsl:template name="printPolicyType">
		<xsl:param name="strPolicyType" />
		<b><xsl:value-of select="/GroupPolicy/TableInfo/*[name()=$strPolicyType]/@Info"/></b>
	</xsl:template>

	<!--Template to print the policy type -->
	<xsl:template name="printLocalType">
		<xsl:param name="strLocalType" />
		<xsl:if
			test="/GroupPolicy/@Inherit='false'">
			<xsl:choose>
				<xsl:when test="$strLocalType='true'">
					<xsl:value-of select="/GroupPolicy/TableInfo/LocationSpecific/@Info" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="/GroupPolicy/TableInfo/Shared/@Info" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template name="printOnOff">
		<xsl:param name="turnedOn" />
		<xsl:param name="color">
		<xsl:choose>
			<xsl:when test="$turnedOn='true'">
				<xsl:value-of select='$onColor' />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select='$offColor' />
			</xsl:otherwise>
		</xsl:choose>
		</xsl:param>

		<b><font color="{$color}">
		<xsl:choose>
			<xsl:when test="$turnedOn='true'">
				<xsl:value-of name="onOff" select="/GroupPolicy/TableInfo/ON/@Info" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of name="onOff" select="/GroupPolicy/TableInfo/Off/@Info" />
			</xsl:otherwise>
		</xsl:choose>
		</font></b>
	</xsl:template>

	<!--Template to display "edit" or "view" based on the inheritance of the 
		group -->
	<xsl:template name="editOrView">
		<xsl:choose>
			<xsl:when test="/GroupPolicy/@Inherit='false'">
				<xsl:value-of select="/GroupPolicy/TableInfo/Edit/@Info" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="/GroupPolicy/TableInfo/View/@Info" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--Template to display information of a policy -->
	<xsl:template name="displayPolicy">
		<xsl:param name="policyId" />
		<xsl:param name="policyName" />
		<xsl:param name="locationId" />
		<xsl:param name="policyType" />
		<xsl:param name="policyTargetType" />
		<xsl:param name="isLocal" />
		<xsl:param name="isDisabled" />
		<xsl:param name="localImage" />
		<xsl:param name="sharedImage" />
		<xsl:param name="localDisabledImage" />
		<xsl:param name="sharedDisabledImage" />
		<xsl:param name="baseLink" select="concat('?', 
								normalize-space($policyType), ';',
								normalize-space($policyTargetType), ';',
								$policyId, ';',
								$locationId, ';',
								$isLocal, '#'
								)"/>
		<xsl:param name="color">
			<xsl:choose>
				<xsl:when test="$isDisabled='true'">
					<xsl:value-of select="$disabledColor"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$enabledColor"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:param>

		<td width="20"></td>
		<td style="color:{$color};" nowrap="nowrap" valign="top" width="5">
			<xsl:call-template name="printPolicyType">
					<xsl:with-param name="strPolicyType" select="normalize-space($policyType)" />
				</xsl:call-template>
		</td>
		<td colspan="3">
			<a style="text-decoration:none" noHover='true'>
				<xsl:attribute name="href">
					<xsl:value-of select="concat($baseLink, 'edit_policy')" />
				</xsl:attribute>
				<font color="{$color}">
					<xsl:call-template name="printPolicyName">
						<xsl:with-param name="strPolicyName" select="$policyName" />
					</xsl:call-template>
					&#160;
					<xsl:call-template name="printLocalType">
						<xsl:with-param name="strLocalType" select="$isLocal" />
					</xsl:call-template>
				</font>
			</a>
		</td>
		<td width="5%" nowrap="nowrap" align="right" valign="top" >
			<a style="text-decoration:none">
				<xsl:attribute name="href">
					<xsl:value-of select="concat($baseLink, 'more_options')"/>
				</xsl:attribute>
			<xsl:value-of select="/GroupPolicy/TableInfo/More/@Info" />
			</a>
		</td>
	</xsl:template>

        <!--Template to display information of a policy -->
	    <xsl:template name="displayHidPolicy">
	    <xsl:param name="policyId" />
		<xsl:param name="policyName" />
		<xsl:param name="locationId" />
		<xsl:param name="policyType" />
		<xsl:param name="policyTargetType" />
		<xsl:param name="isLocal" />
		<xsl:param name="isDisabled" />
		<xsl:param name="showHidPolicy" />
		<xsl:param name="localImage" />
		<xsl:param name="CloudTooltip" />
		<xsl:param name="isInherited" />

		<xsl:param name="sharedImage" />
		<xsl:param name="localDisabledImage" />
		<xsl:param name="sharedDisabledImage" />
		<xsl:param name="baseLink" select="concat('?', 
								normalize-space($policyType), ';',
								normalize-space($policyTargetType), ';',
								$policyId, ';',
								$locationId, ';',
								$isLocal, '#'
								)"/>
		<xsl:param name="color">
			<xsl:choose>
				<xsl:when test="$isDisabled='true'">
					<xsl:value-of select="$disabledColor"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$enabledColor"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:param>
		<td width="20" ></td>

		<td style="color:{$color};" nowrap="nowrap" valign="top" width="5">
			<xsl:call-template name="printPolicyType">
				<xsl:with-param name="strPolicyType" select="normalize-space($policyType)" />
			</xsl:call-template>
		</td>
		<td colspan="3">
			<xsl:attribute name="href">
				<xsl:value-of select="concat($baseLink, 'edit_policy')" />
			</xsl:attribute>
			<font color="{$color}">
				<xsl:call-template name="printPolicyName">
					<xsl:with-param name="strPolicyName" select="$policyName" />
				</xsl:call-template>
				&#160;
				<xsl:text disable-output-escaping="yes"></xsl:text>
				<xsl:value-of select="@SharedCloud" />

			</font>
		</td>
		<td width="5%" nowrap="nowrap" align="right" valign="top">
		<xsl:choose>
		<xsl:when test="$isInherited = 'true'">
			<img src="{$cloud_inherited}" width="16" height="16" align="middle"
					border="0"  />
		</xsl:when>
		<xsl:otherwise>
				<img src="{$cloud}" width="16" height="16" align="middle"
					border="0" />
		</xsl:otherwise>
		</xsl:choose>
		</td>
	</xsl:template>


	     <!--Template to display information of a policy -->
	    <xsl:template name="displayTdadPolicy">
	    <xsl:param name="policyId" />
		<xsl:param name="policyName" />
		<xsl:param name="locationId" />
		<xsl:param name="policyType" />
		<xsl:param name="policyTargetType" />
		<xsl:param name="isLocal" />
		<xsl:param name="isDisabled" />
		<xsl:param name="showTdadPolicy" />
		<xsl:param name="localImage" />
		<xsl:param name="CloudTooltip" />
		<xsl:param name="isInherited" />

		<xsl:param name="sharedImage" />
		<xsl:param name="localDisabledImage" />
		<xsl:param name="sharedDisabledImage" />
		<xsl:param name="baseLink" select="concat('?', 
								normalize-space($policyType), ';',
								normalize-space($policyTargetType), ';',
								$policyId, ';',
								$locationId, ';',
								$isLocal, '#'
								)"/>
		<xsl:param name="color">
			<xsl:choose>
				<xsl:when test="$isDisabled='true'">
					<xsl:value-of select="$disabledColor"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$enabledColor"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:param>
		<td width="20" ></td>

		<td style="color:{$color};" nowrap="nowrap" valign="top" width="5">
			<xsl:call-template name="printPolicyType">
				<xsl:with-param name="strPolicyType" select="normalize-space($policyType)" />
			</xsl:call-template>
		</td>
		<td colspan="3">
			<xsl:attribute name="href">
				<xsl:value-of select="concat($baseLink, 'edit_policy')" />
			</xsl:attribute>
			<font color="{$color}">
				<xsl:call-template name="printPolicyName">
					<xsl:with-param name="strPolicyName" select="$policyName" />
				</xsl:call-template>
				&#160;
				<xsl:text disable-output-escaping="yes"></xsl:text>
				<xsl:value-of select="@SharedExternal" />

			</font>
		</td>
		<td width="5%" nowrap="nowrap" align="right" valign="top">
		<xsl:choose>
		<xsl:when test="$isInherited = 'true'">
			<img src="{$thirdparty_inherited}" width="16" height="16" align="middle"
					border="0"  />
		</xsl:when>
		<xsl:otherwise>
				<img src="{$thirdparty}" width="16" height="16" align="middle"
					border="0" />
		</xsl:otherwise>
		</xsl:choose>
		</td>
	</xsl:template>


	<!--Template to display information of a cloud exception policy -->
	    <xsl:template name="displayCloudOverridePolicy">
	    <xsl:param name="policyId" />
		<xsl:param name="policyName" />
		<xsl:param name="locationId" />
		<xsl:param name="policyType" />
		<xsl:param name="policyTargetType" />
		<xsl:param name="isLocal" />
		<xsl:param name="isDisabled" />
		<xsl:param name="showCloudOverridePolicyWhitelist" />
		<xsl:param name="showCloudOverridePolicyBlacklist" />
		<xsl:param name="showMEMPolicy" />
		<xsl:param name="isWhiteList" />
		<xsl:param name="isBlackList" />
		<xsl:param name="localImage" />
		<xsl:param name="isInherited" />
		<xsl:param name="CloudTooltip" />

		<xsl:param name="sharedImage" />
		<xsl:param name="localDisabledImage" />
		<xsl:param name="sharedDisabledImage" />
		<xsl:param name="baseLink" select="concat('?', 
								normalize-space($policyType), ';',
								normalize-space($policyTargetType), ';',
								$policyId, ';',
								$locationId, ';',
								$isLocal, '#'
								)"/>
		<xsl:param name="color">
			<xsl:choose>
				<xsl:when test="$isDisabled='true'">
					<xsl:value-of select="$disabledColor"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$enabledColor"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:param>
		<td width="20" ></td>

		<td style="color:{$color};" nowrap="nowrap" valign="top" width="5">
			<xsl:call-template name="printPolicyType">
				<xsl:with-param name="strPolicyType" select="normalize-space($policyType)" />
			</xsl:call-template>
			<xsl:if test="$isWhiteList='true'">
				<b><xsl:value-of select="@WhiteList" /></b>
			</xsl:if>
			<xsl:if test="$isBlackList='true'">
				<b><xsl:value-of select="@BlackList" /></b>
			</xsl:if>
		</td>
		<td colspan="3">
		<a style="text-decoration:none" noHover='true'>
			<xsl:attribute name="href">
				<xsl:value-of select="concat($baseLink, 'edit_policy')" />
			</xsl:attribute>
			<font color="{$color}">
				<xsl:call-template name="printPolicyName">
					<xsl:with-param name="strPolicyName" select="$policyName" />
				</xsl:call-template>
				&#160;
				<xsl:text disable-output-escaping="yes"></xsl:text>
				<xsl:value-of select="@SharedCloud" />

			</font>
			</a>
		</td>

		<td width="5%" nowrap="nowrap" align="right" valign="top">
		<xsl:choose>
		<xsl:when test="$isInherited = 'true'">
			<img src="{$cloud_inherited}" width="16" height="16" align="middle"
					border="0"  />
		</xsl:when>
		<xsl:otherwise>
				<img src="{$cloud}" width="16" height="16" align="middle"
					border="0" />
		</xsl:otherwise>
		</xsl:choose>
		</td>
	</xsl:template>


	<!--Template to display information of a quarantine policy -->
	<xsl:template name="displayQuarantinePolicy">
		<xsl:param name="policyId" />
		<xsl:param name="policyName" />
		<xsl:param name="locationId" />
		<xsl:param name="policyType" />
		<xsl:param name="policyTargetType" />
		<xsl:param name="isLocal" />
		<xsl:param name="isDisabled" />
		<xsl:param name="isHIDisabled" />
		<xsl:param name="localImage" />
		<xsl:param name="sharedImage" />
		<xsl:param name="localDisabledImage" />
		<xsl:param name="sharedDisabledImage" />
		<xsl:variable name="disabled">
			<xsl:choose>
				<xsl:when test="$isDisabled='true'">
					<xsl:value-of select="'true'" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="$isHIDisabled='true'">
							<xsl:value-of select="'true'" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'false'" />
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:call-template name="displayPolicy">
			<xsl:with-param name="policyId" select="$policyId" />
			<xsl:with-param name="policyName" select="$policyName" />
			<xsl:with-param name="locationId" select="$locationId" />
			<xsl:with-param name="policyType" select="$policyType" />
			<xsl:with-param name="policyTargetType" select="$policyTargetType" />
			<xsl:with-param name="isLocal" select="$isLocal" />
			<xsl:with-param name="isDisabled" select="$disabled" />
			<xsl:with-param name="localImage" select="$localImage" />
			<xsl:with-param name="sharedImage" select="$sharedImage" />
			<xsl:with-param name="localDisabledImage" select="$localDisabledImage" />
			<xsl:with-param name="sharedDisabledImage" select="$sharedDisabledImage" />
		</xsl:call-template>
	</xsl:template>

	<xsl:template match="/GroupPolicy">
		<html>
			<head>
				<style type="text/css">
					BODY {
						background-color: #ffffff;
						color: #000;
						margin:0px 0px 0px 0px;
						font-family:<xsl:value-of select="$fontName" />;
						font-size:<xsl:value-of select="$fontSize" />;
					}

					a {
						text-decoration:none;
						color: <xsl:value-of select="$hyperlinkColor" />;
					}

					.underlineCell {
						border-bottom-style: solid;
						border-bottom-color: <xsl:value-of select="$expandRowBackground" />;
						border-bottom-width: 1px;
					}
				</style>

			</head>
			<body>
				<b><xsl:value-of
						select="/GroupPolicy/TableInfo/GroupPoliciesAndSettings/@Info" /></b>
				<div style="width:5px"/>

				<table width="100%" valign="top" cellspacing="0">
					<tr style="font-weight:bold">
						<!-- Policies heading -->
						<td colspan="4">
							<xsl:value-of select="/GroupPolicy/TableInfo/ProtectionSettings/@Info" />
						</td>
						<!-- Settings header -->
						<td colspan="9">
							<xsl:value-of select="/GroupPolicy/TableInfo/OtherSettings/@Info" />
						</td>
					</tr>
					<tr>
						<td colspan="2" class="underlineCell">
							<a href="?Intrusion Prevention#advance_setting">
								<xsl:value-of select="/GroupPolicy/TableInfo/IPSLibraries/@Info" />
							</a>
						</td>
						<td align="left" class="underlineCell">
							<xsl:call-template name="printOnOff">
								<xsl:with-param name="turnedOn" select="@EnableIDS" />
							</xsl:call-template>
						</td>
						<td/>
						<td colspan="3" class="underlineCell">
							<a href="#advance_setting">
								<xsl:value-of select="/GroupPolicy/TableInfo/GeneralSettings/@Info" />
							</a>
						</td>
						<td colspan="6" class="underlineCell">
							<a href="?Communication#advance_setting">
								<xsl:value-of select="/GroupPolicy/TableInfo/Communication/@Info" />
							</a>
						</td>
					</tr>
					<tr>
						<td colspan="2" class="underlineCell">
							<a href="?Lockdown#advance_setting">
								<xsl:value-of select="/GroupPolicy/TableInfo/SystemLockdown/@Info" />
							</a>
						</td>
						<td align="left"  class="underlineCell">
							<xsl:call-template name="printOnOff">
								<xsl:with-param name="turnedOn" select="@EnableLockdown" />
							</xsl:call-template>
						</td>
						<td/>
						<td colspan="3" class="underlineCell">
							<a href="?logs#advance_setting">
								<xsl:value-of select="/GroupPolicy/TableInfo/LogSettings/@Info" />
							</a>
						</td>
						<td colspan="6" class="underlineCell">
							<a href="?ExternalCommunication#advance_setting">
								<xsl:value-of
									select="/GroupPolicy/TableInfo/ExternalCommunication/@Info" />
							</a>
						</td>
					</tr>
					<tr>
						<td colspan="2" class="underlineCell">
							<a href="?application authentication#advance_setting">
								<xsl:value-of
									select="/GroupPolicy/TableInfo/ApplicationAuthentication/@Info" />
							</a>
						</td>
						<td align="left" class="underlineCell">
							<xsl:call-template name="printOnOff">
								<xsl:with-param name="turnedOn" select="@EnableAppAuthentication" />
							</xsl:call-template>
						</td>
						<td/>
						<td colspan="3" class="underlineCell">
							<a href="#security_setting">
								<xsl:value-of select="/GroupPolicy/TableInfo/PasswordSettings/@Info" />
							</a>
						</td>
						<xsl:if test="count(@EnableLiveupdateContentPolicySettings)&gt;0">

							<td colspan="6" height="100%" class="underlineCell">
								<a href="#lucontentpolicy">
									<xsl:value-of select="/GroupPolicy/TableInfo/LuContentPolicy/@Info" />
								</a>
							</td>
						</xsl:if>
					</tr>
					<tr>
						<!-- An empty row so we create some space between the next table -->
					</tr>
				</table>

				<font
					style="font-weight:bold;">
					<xsl:value-of select="/GroupPolicy/TableInfo/LocationOverview/@Info" />
				</font>
				<div style="width:5px"/>

				<table width="100%">
					<xsl:for-each select="Location">
						<tr>
							<td>
								<!--
								FIXME N8 - I still want to clean this up.  There is no reason to write the html out
								using the xsl text tag.  There is also some refactoring to do.  A lot of this is
								duplicate code.
								-->
								<!-- Settings for location -->
								<table width="100%" valign="top">

									<tr bgcolor="{$expandRowBackground}">
										<td align="center" valign="middle" width="20">
										<xsl:text disable-output-escaping="yes">&lt;a noHover='true' href=&quot;?</xsl:text>
										<xsl:value-of select="@Id" />
										<xsl:text disable-output-escaping="yes">;ExpandLoc</xsl:text>

										<xsl:text disable-output-escaping="yes">;</xsl:text>
										<xsl:value-of select="@ExpandLoc" />
										<xsl:text disable-output-escaping="yes">#loc_expand"&gt;</xsl:text>
										<xsl:choose>
											<xsl:when test="@ExpandLoc='true'">
												<img src="{$upArrow}" width="10" height="10" align="middle"
													border="0" />
											</xsl:when>
											<xsl:otherwise>
												<img width="10" height="10" src="{$downArrow}" align="middle"
													border="0" />
											</xsl:otherwise>
										</xsl:choose>
										<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
										</td>

										<td colspan="3" style="font-weight:bold;">
										<xsl:text disable-output-escaping="yes">&lt;a noHover='true' style=&quot;text-decoration:none&quot; href=&quot;?</xsl:text>
										<xsl:value-of select="@Id" />
										<xsl:text disable-output-escaping="yes">;ExpandLoc</xsl:text>
										<xsl:text disable-output-escaping="yes">;</xsl:text>
										<xsl:value-of select="@ExpandLoc" />
										<xsl:text disable-output-escaping="yes">#loc_expand"&gt;</xsl:text>
										<font>
												<xsl:attribute name="color">
													<xsl:choose>
														<xsl:when test="@Enabled='true'">
															<xsl:value-of select="$enabledColor"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="$disabledColor"/>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:attribute>
											<xsl:value-of select="/GroupPolicy/TableInfo/Location/@Info" />
											<xsl:value-of select="@Name" />
										</font>
										<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
										</td>

										<td colspan="2" align="right">
										<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?</xsl:text>
										<xsl:value-of select="@Id" />
										<xsl:text disable-output-escaping="yes">#edit_location"&gt;</xsl:text>
										<xsl:value-of select="/GroupPolicy/TableInfo/Edit/@Info" />
										<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
										</td>
									</tr>
									<xsl:if test="@ExpandLoc='true'">
										<tr>
											<td align="center"
												valign="middle" width="20">
												<xsl:text disable-output-escaping="yes">&lt;a noHover='true' href=&quot;?</xsl:text>
												<xsl:value-of select="@Id" />
												<xsl:text disable-output-escaping="yes">;ExpandPolicy</xsl:text>

												<xsl:text disable-output-escaping="yes">;</xsl:text>
												<xsl:value-of select="@ExpandPolicy" />
												<xsl:text disable-output-escaping="yes">#loc_expand"&gt;</xsl:text>
												<xsl:choose>
													<xsl:when test="@ExpandPolicy='true'">
														<img src="{$upArrow}" width="10" height="10"
															align="middle" border="0" />
													</xsl:when>
													<xsl:otherwise>
														<img width="10" height="10" src="{$downArrow}"
															align="middle" border="0" />
													</xsl:otherwise>
												</xsl:choose>
												<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
											</td>
											<td colspan="3">
												<xsl:text disable-output-escaping="yes">&lt;a noHover='true' style=&quot;text-decoration:none&quot; href=&quot;?</xsl:text>
												<xsl:value-of select="@Id" />
												<xsl:text disable-output-escaping="yes">;ExpandPolicy</xsl:text>
												<xsl:text disable-output-escaping="yes">;</xsl:text>
												<xsl:value-of select="@ExpandPolicy" />
												<xsl:text disable-output-escaping="yes">#loc_expand"&gt;</xsl:text>
												<font COLOR="#000000">
													<xsl:value-of
														select="/GroupPolicy/TableInfo/LocSpecificPolicies/@Info" />
												</font>
												<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
											</td>

											<td colspan="2" align="right"
												nowrap="nowrap">
												<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?</xsl:text>
												<xsl:value-of select="@Id" />
												<xsl:text disable-output-escaping="yes">;normal#add_more_policy"&gt;</xsl:text>
												<xsl:value-of select="/GroupPolicy/TableInfo/AddPolicy/@Info" />
												<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
											</td>
										</tr>
										<xsl:if test="@ExpandPolicy='true'">
											<xsl:if
												test="(count(AvPolicy)=0) and (count(FirewallPolicy)=0) and (count(HostIntegrityPolicy)=0) and (count(OSProtectionPolicy)=0) and (count(OverridePolicy)=0) and (count(LiveUpdatePolicy)=0) and (count(IdsPolicy)=0) and (count(MemPolicy)=0) and (count(NtrPolicy)=0) and (count(UpgradePolicy)=0) and (count(AdaptivePolicy)=0)">
												<tr>
													<td width="5"></td>
													<td colspan="4">

														<xsl:value-of
															select="/GroupPolicy/TableInfo/NoPolicyAppliedToThisLocation/@Info" />
													</td>
													<!--<td width="7%"></td> -->
													<td width="7%"></td>
												</tr>
											</xsl:if>
											<xsl:if test="count(AdaptivePolicy)>0">
												<tr>
													<xsl:call-template name="displayPolicy">
														<xsl:with-param name="policyId" select="AdaptivePolicy/@Id" />
														<xsl:with-param name="policyName"
																		select="AdaptivePolicy/@Description" />
														<xsl:with-param name="locationId" select="@Id" />
														<xsl:with-param name="policyType">
															AdaptivePolicy
														</xsl:with-param>
														<xsl:with-param name="policyTargetType">
															AdaptivePolicyApplied
														</xsl:with-param>
														<xsl:with-param name="isLocal"
																		select="AdaptivePolicy/@IsLocalPolicy" />
														<xsl:with-param name="isDisabled"
																		select="AdaptivePolicy/@Disabled" />
														<xsl:with-param name="localImage">
															LULocal_16.gif
														</xsl:with-param>
														<xsl:with-param name="sharedImage">
															LUShared_16.gif
														</xsl:with-param>
														<xsl:with-param name="localDisabledImage">
															LULocal_16.gif
														</xsl:with-param>
														<xsl:with-param name="sharedDisabledImage">
															LUShared_16.gif
														</xsl:with-param>
													</xsl:call-template>
												</tr>
											</xsl:if>
											<xsl:if test="count(AvPolicy)>0">
												<tr>
													<xsl:call-template name="displayPolicy">
														<xsl:with-param name="policyId" select="AvPolicy/@Id" />
														<xsl:with-param name="policyName"
															select="AvPolicy/@Description" />
														<xsl:with-param name="locationId" select="@Id" />
														<xsl:with-param name="policyType">
															AvPolicy
														</xsl:with-param>
														<xsl:with-param name="policyTargetType">
															AvPolicyApplied
														</xsl:with-param>
														<xsl:with-param name="isLocal"
															select="AvPolicy/@IsLocalPolicy" />
														<xsl:with-param name="isDisabled" select="AvPolicy/@Disabled" />
														<xsl:with-param name="localImage">
															AntiVirusLocal_16a.gif
														</xsl:with-param>
														<xsl:with-param name="sharedImage">
															AntiVirusShare_16.gif
														</xsl:with-param>
														<xsl:with-param name="localDisabledImage">
															AntiVirusLocal_16a.gif
														</xsl:with-param>
														<xsl:with-param name="sharedDisabledImage">
															AntiVirusShare_16.gif
														</xsl:with-param>
													</xsl:call-template>
												</tr>
											</xsl:if>
											<!-- hide firewall policy for SAVSB -->
											<xsl:if test="count(FirewallPolicy)>0">
												<tr>
													<xsl:call-template name="displayPolicy">
														<xsl:with-param name="policyId" select="FirewallPolicy/@Id" />
														<xsl:with-param name="policyName"
															select="FirewallPolicy/@Description" />
														<xsl:with-param name="locationId" select="@Id" />
														<xsl:with-param name="policyType">
															FwFirewallPolicy
														</xsl:with-param>
														<xsl:with-param name="policyTargetType">
															FirewallPolicyApplied
														</xsl:with-param>
														<xsl:with-param name="isLocal"
															select="FirewallPolicy/@IsLocalPolicy" />
														<xsl:with-param name="isDisabled"
															select="FirewallPolicy/@Disabled" />
														<xsl:with-param name="localImage">
															FirewallLocal_16a.gif
														</xsl:with-param>
														<xsl:with-param name="sharedImage">
															FirewallShare_16a.gif
														</xsl:with-param>
														<xsl:with-param name="localDisabledImage">
															FirewallLocal_16a_g.gif
														</xsl:with-param>
														<xsl:with-param name="sharedDisabledImage">
															FirewallShare_16a_g.gif
														</xsl:with-param>
													</xsl:call-template>
												</tr>
											</xsl:if>
											<!-- hide intrusion prevention policy for SAVSB -->
											<xsl:if test="count(IdsPolicy)>0">
												<tr>
													<xsl:call-template name="displayPolicy">
														<xsl:with-param name="policyId" select="IdsPolicy/@Id" />
														<xsl:with-param name="policyName"
															select="IdsPolicy/@Description" />
														<xsl:with-param name="locationId" select="@Id" />
														<xsl:with-param name="policyType">
															IdsPolicy
														</xsl:with-param>
														<xsl:with-param name="policyTargetType">
															IdsPolicyApplied
														</xsl:with-param>
														<xsl:with-param name="isLocal"
															select="IdsPolicy/@IsLocalPolicy" />
														<xsl:with-param name="isDisabled" select="IdsPolicy/@Disabled" />
														<xsl:with-param name="localImage">
															ips_16.gif
														</xsl:with-param>
														<xsl:with-param name="sharedImage">
															ips_shared_16.gif
														</xsl:with-param>
														<xsl:with-param name="localDisabledImage">
															ips_16_g.gif
														</xsl:with-param>
														<xsl:with-param name="sharedDisabledImage">
															ips_shared_16_g.gif
														</xsl:with-param>
													</xsl:call-template>
												</tr>
											</xsl:if>

											<xsl:if
												test="count(OSProtectionPolicy)>0">
												<tr>
													<xsl:call-template name="displayPolicy">
														<xsl:with-param name="policyId"
															select="OSProtectionPolicy/@Id" />
														<xsl:with-param name="policyName"
															select="OSProtectionPolicy/@Description" />
														<xsl:with-param name="locationId" select="@Id" />
														<xsl:with-param name="policyType">
															OpAppProtectionPolicy
														</xsl:with-param>
														<xsl:with-param name="policyTargetType">
															OpAppProtectionPolicyApplied
														</xsl:with-param>
														<xsl:with-param name="isLocal"
															select="OSProtectionPolicy/@IsLocalPolicy" />
														<xsl:with-param name="isDisabled"
															select="OSProtectionPolicy/@Disabled" />
														<xsl:with-param name="localImage">
															HardwarePolicyLocal_16.gif
														</xsl:with-param>
														<xsl:with-param name="sharedImage">
															HardwarePolicyShare_16.gif
														</xsl:with-param>
														<xsl:with-param name="localDisabledImage">
															HardwarePolicyLocal_16_g.gif
														</xsl:with-param>
														<xsl:with-param name="sharedDisabledImage">
															HardwarePolicyShare_16_g.gif
														</xsl:with-param>
													</xsl:call-template>
												</tr>

											</xsl:if>

											<xsl:if test="count(HostIntegrityPolicy)>0">
												<tr>
													<xsl:call-template name="displayPolicy">
														<xsl:with-param name="policyId"
															select="HostIntegrityPolicy/@Id" />
														<xsl:with-param name="policyName"
															select="HostIntegrityPolicy/@Description" />
														<xsl:with-param name="locationId" select="@Id" />
														<xsl:with-param name="policyType">
															HiHostIntegrityPolicy
														</xsl:with-param>
														<xsl:with-param name="policyTargetType">
															HostIntegrityApplied
														</xsl:with-param>
														<xsl:with-param name="isLocal"
															select="HostIntegrityPolicy/@IsLocalPolicy" />
														<xsl:with-param name="isDisabled"
															select="HostIntegrityPolicy/@Disabled" />
														<xsl:with-param name="localImage">
															HostLocal_16.gif
														</xsl:with-param>
														<xsl:with-param name="sharedImage">
															HostShare_16.gif
														</xsl:with-param>
														<xsl:with-param name="localDisabledImage">
															HostLocal_16_g.gif
														</xsl:with-param>
														<xsl:with-param name="sharedDisabledImage">
															HostShare_16_g.gif
														</xsl:with-param>
													</xsl:call-template>
												</tr>
											</xsl:if>

											<xsl:if test="count(LiveUpdatePolicy)>0">
												<tr>
													<xsl:call-template name="displayPolicy">
														<xsl:with-param name="policyId" select="LiveUpdatePolicy/@Id" />
														<xsl:with-param name="policyName"
															select="LiveUpdatePolicy/@Description" />
														<xsl:with-param name="locationId" select="@Id" />
														<xsl:with-param name="policyType">
															LuPolicy
														</xsl:with-param>
														<xsl:with-param name="policyTargetType">
															LuPolicyApplied
														</xsl:with-param>
														<xsl:with-param name="isLocal"
															select="LiveUpdatePolicy/@IsLocalPolicy" />
														<xsl:with-param name="isDisabled"
															select="LiveUpdatePolicy/@Disabled" />
														<xsl:with-param name="localImage">
															LULocal_16.gif
														</xsl:with-param>
														<xsl:with-param name="sharedImage">
															LUShared_16.gif
														</xsl:with-param>
														<xsl:with-param name="localDisabledImage">
															LULocal_16.gif
														</xsl:with-param>
														<xsl:with-param name="sharedDisabledImage">
															LUShared_16.gif
														</xsl:with-param>
													</xsl:call-template>
												</tr>
											</xsl:if>
											<xsl:if test="count(UpgradePolicy)>0">
												<tr>
													<xsl:call-template name="displayPolicy">
														<xsl:with-param name="policyId" select="UpgradePolicy/@Id" />
														<xsl:with-param name="policyName"
															select="UpgradePolicy/@Description" />
														<xsl:with-param name="locationId" select="@Id" />
														<xsl:with-param name="policyType">
															UpgradePolicy
														</xsl:with-param>
														<xsl:with-param name="policyTargetType">
															UpgradePolicyApplied
														</xsl:with-param>
														<xsl:with-param name="isLocal"
															select="UpgradePolicy/@IsLocalPolicy" />
														<xsl:with-param name="isDisabled"
															select="UpgradePolicy/@Disabled" />
														<xsl:with-param name="localImage">
															LULocal_16.gif
														</xsl:with-param>
														<xsl:with-param name="sharedImage">
															LUShared_16.gif
														</xsl:with-param>
														<xsl:with-param name="localDisabledImage">
															LULocal_16.gif
														</xsl:with-param>
														<xsl:with-param name="sharedDisabledImage">
															LUShared_16.gif
														</xsl:with-param>
													</xsl:call-template>
												</tr>
											</xsl:if>
											<xsl:choose>
													<xsl:when test="@ShowMEMPolicy='true'">
														<tr>
															<xsl:call-template name="displayCloudOverridePolicy">
																<xsl:with-param name="policyId" select="CloudPolicyMEM/@Id" />
																<xsl:with-param name="policyName"
																	select="CloudPolicyMEM/@Description" />
																<xsl:with-param name="locationId" select="@Id" />
																<xsl:with-param name="policyType">
																	MemPolicy
																</xsl:with-param>
																<xsl:with-param name="policyTargetType">
																	MemPolicyApplied
																</xsl:with-param>
																<xsl:with-param name="CloudTooltip">
																    CloudTooltip
															    </xsl:with-param>
																<xsl:with-param name="isLocal"
																	select="CloudPolicyMEM/@IsLocalPolicy" />
																<xsl:with-param name="isInherited"
																	select="CloudPolicyMEM/@isInherited" />
																<xsl:with-param name="isDisabled"
																	select="CloudPolicyMEM/@Disabled" />
															</xsl:call-template>
														</tr>
													</xsl:when>
													<xsl:otherwise>
														<xsl:if test="count(MemPolicy)>0">
															<tr>
															<xsl:call-template name="displayPolicy">
																<xsl:with-param name="policyId" select="MemPolicy/@Id" />
																<xsl:with-param name="policyName"
																	select="MemPolicy/@Description" />
																<xsl:with-param name="locationId" select="@Id" />
																<xsl:with-param name="policyType">
																	MemPolicy
																</xsl:with-param>
																<xsl:with-param name="policyTargetType">
																	MemPolicyApplied
																</xsl:with-param>
																<xsl:with-param name="isLocal"
																	select="MemPolicy/@IsLocalPolicy" />
																<xsl:with-param name="isDisabled"
																	select="MemPolicy/@Disabled" />
																<xsl:with-param name="localImage">
																	LULocal_16.gif
																</xsl:with-param>
																<xsl:with-param name="sharedImage">
																	LUShared_16.gif
																</xsl:with-param>
																<xsl:with-param name="localDisabledImage">
																	LULocal_16.gif
																</xsl:with-param>
																<xsl:with-param name="sharedDisabledImage">
																	LUShared_16.gif
																</xsl:with-param>
															</xsl:call-template>
														</tr>
													</xsl:if>
												</xsl:otherwise>
											</xsl:choose>
											<xsl:if test="count(NtrPolicy)>0">
												<tr>
													<xsl:call-template name="displayPolicy">
														<xsl:with-param name="policyId" select="NtrPolicy/@Id" />
														<xsl:with-param name="policyName"
															select="NtrPolicy/@Description" />
														<xsl:with-param name="locationId" select="@Id" />
														<xsl:with-param name="policyType">
															NtrPolicy
														</xsl:with-param>
														<xsl:with-param name="policyTargetType">
															NtrPolicyApplied
														</xsl:with-param>
														<xsl:with-param name="isLocal"
															select="NtrPolicy/@IsLocalPolicy" />
														<xsl:with-param name="isDisabled"
															select="NtrPolicy/@Disabled" />
														<xsl:with-param name="localImage">
															LULocal_16.gif
														</xsl:with-param>
														<xsl:with-param name="sharedImage">
															LUShared_16.gif
														</xsl:with-param>
														<xsl:with-param name="localDisabledImage">
															LULocal_16.gif
														</xsl:with-param>
														<xsl:with-param name="sharedDisabledImage">
															LUShared_16.gif
														</xsl:with-param>
													</xsl:call-template>
												</tr>
											</xsl:if>
											<xsl:if test="count(OverridePolicy)>0">
												<tr>
													<xsl:call-template name="displayPolicy">
														<xsl:with-param name="policyId" select="OverridePolicy/@Id" />
														<xsl:with-param name="policyName"
															select="OverridePolicy/@Description" />
														<xsl:with-param name="locationId" select="@Id" />
														<xsl:with-param name="policyType">
															PolicyOverride
														</xsl:with-param>
														<xsl:with-param name="policyTargetType">
															PolicyOverrideApplied
														</xsl:with-param>
														<xsl:with-param name="isLocal"
															select="OverridePolicy/@IsLocalPolicy" />
														<xsl:with-param name="isDisabled"
															select="OverridePolicy/@Disabled" />
														<xsl:with-param name="localImage">
															PolicyOverrideLocal_16a.gif
														</xsl:with-param>
														<xsl:with-param name="sharedImage">
															PolicyOverrideShare_16a.gif
														</xsl:with-param>
														<xsl:with-param name="localDisabledImage">
															PolicyOverrideLocal_16a_g.gif
														</xsl:with-param>
														<xsl:with-param name="sharedDisabledImage">
															PolicyOverrideShare_16a_g.gif
														</xsl:with-param>
													</xsl:call-template>
												</tr>
											</xsl:if>
											<xsl:if test="@ShowHidPolicy='true'">

                                            	<tr>
													<xsl:call-template name="displayHidPolicy">
														<xsl:with-param name="policyId" select="HidPolicy/@Id" />
														<xsl:with-param name="policyName"
															select="HidPolicy/@Description" />
														<xsl:with-param name="locationId" select="@Id" />
														<xsl:with-param name="policyType">
															HidPolicy
														</xsl:with-param>
														<xsl:with-param name="policyTargetType">
															HidPolicyApplied
														</xsl:with-param>
														<xsl:with-param name="CloudTooltip">
														    CloudTooltip
													    </xsl:with-param>
														<xsl:with-param name="isLocal"
															select="HidPolicy/@IsLocalPolicy" />
														<xsl:with-param name="isDisabled"
															select="HidPolicy/@Disabled" />
														<xsl:with-param name="isInherited"
																	select="HidPolicy/@isInherited" />
													</xsl:call-template>
												</tr>
											</xsl:if>
												<xsl:if test="@ShowTdadPolicy='true'">

                                            	<tr>
													<xsl:call-template name="displayTdadPolicy">
														<xsl:with-param name="policyId" select="TdadPolicy/@Id" />
														<xsl:with-param name="policyName"
															select="TdadPolicy/@Description" />
														<xsl:with-param name="locationId" select="@Id" />
														<xsl:with-param name="policyType">
															TdadPolicy
														</xsl:with-param>
														<xsl:with-param name="policyTargetType">
															ExternalTdadPolicyApplied
														</xsl:with-param>
														<xsl:with-param name="CloudTooltip">
														    CloudTooltip
													    </xsl:with-param>
														<xsl:with-param name="isLocal"
															select="TdadPolicy/@IsLocalPolicy" />
														<xsl:with-param name="isDisabled"
															select="TdadPolicy/@Disabled" />
														<xsl:with-param name="isInherited"
																	select="TdadPolicy/@isInherited" />
													</xsl:call-template>
												</tr>
											</xsl:if>
											<xsl:if test="@showCloudOverridePolicyWhitelist='true'">
												<tr>
													<xsl:call-template name="displayCloudOverridePolicy">
														<xsl:with-param name="policyId" select="CloudOverridePolicyWhiteList/@Id" />
														<xsl:with-param name="policyName"
															select="CloudOverridePolicyWhiteList/@Description" />
														<xsl:with-param name="locationId" select="@Id" />
														<xsl:with-param name="policyType">
															PolicyOverride
														</xsl:with-param>
														<xsl:with-param name="policyTargetType">
															CloudWhiteListPolicyOverrideApplied
														</xsl:with-param>
														<xsl:with-param name="CloudTooltip">
														    CloudTooltip
													    </xsl:with-param>
														<xsl:with-param name="isLocal"
															select="CloudOverridePolicyWhiteList/@IsLocalPolicy" />
														<xsl:with-param name="isDisabled"
															select="CloudOverridePolicyWhiteList/@Disabled" />
														<xsl:with-param name="isWhiteList"
															select="CloudOverridePolicyWhiteList/@isWhiteListPolicy" />
														<xsl:with-param name="isInherited"
																	select="CloudOverridePolicyWhiteList/@isInherited" />
													</xsl:call-template>
												</tr>
											 </xsl:if>
											<xsl:if test="@showCloudOverridePolicyBlacklist='true'">
												<tr>
													<xsl:call-template name="displayCloudOverridePolicy">
														<xsl:with-param name="policyId" select="CloudOverridePolicyBlackList/@Id" />
														<xsl:with-param name="policyName"
															select="CloudOverridePolicyBlackList/@Description" />
														<xsl:with-param name="locationId" select="@Id" />
														<xsl:with-param name="policyType">
															PolicyOverride
														</xsl:with-param>
														<xsl:with-param name="policyTargetType">
															CloudBlackListPolicyOverrideApplied
														</xsl:with-param>
														<xsl:with-param name="CloudTooltip">
														    CloudTooltip
													    </xsl:with-param>
														<xsl:with-param name="isLocal"
															select="CloudOverridePolicyBlackList/@IsLocalPolicy" />
														<xsl:with-param name="isDisabled"
															select="CloudOverridePolicyBlackList/@Disabled" />
														<xsl:with-param name="isBlackList"
															select="CloudOverridePolicyBlackList/@isBlackListPolicy" />
														<xsl:with-param name="isInherited"
																	select="CloudOverridePolicyBlackList/@isInherited" />
													</xsl:call-template>
												</tr>
											</xsl:if>

										</xsl:if>


										<xsl:if test="@HasQuarantine='true'">
											<tr>
												<td align="center"
													width="20" valign="middle">
													<xsl:text disable-output-escaping="yes">&lt;a noHover='true'  href=&quot;?</xsl:text>
													<xsl:value-of select="@Id" />
													<xsl:text disable-output-escaping="yes">;ExpandQuaratinePolicy;</xsl:text>
													<xsl:value-of select="@ExpandQuaratinePolicy" />
													<xsl:text disable-output-escaping="yes">#loc_expand"&gt;</xsl:text>
													<xsl:choose>
														<xsl:when test="@ExpandQuaratinePolicy='true'">
															<img width="10" height="10" src="{$upArrow}"
																align="middle" border="0" />
														</xsl:when>
														<xsl:otherwise>
															<img width="10" height="10" src="{$downArrow}" align="middle"
																border="0" />
														</xsl:otherwise>
													</xsl:choose>
													<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
												</td>

												<td colspan="3">
													<xsl:text disable-output-escaping="yes">&lt;a noHover='true' style=&quot;text-decoration:none&quot; href=&quot;?</xsl:text>
													<xsl:value-of select="@Id" />
													<xsl:text disable-output-escaping="yes">;ExpandQuaratinePolicy;</xsl:text>
													<xsl:value-of select="@ExpandQuaratinePolicy" />
													<xsl:text disable-output-escaping="yes">#loc_expand"&gt;</xsl:text>
													<font COLOR="#000000">
														<xsl:value-of
															select="/GroupPolicy/TableInfo/QuarantinePoliciesWhenHostIntegrityFails/@Info" />
													</font>
													<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
												</td>
												<td colspan="2" align="right"
													nowrap="nowrap">
													<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?</xsl:text>
													<xsl:value-of select="@Id" />
													<xsl:text disable-output-escaping="yes">;quaratine#add_more_policy"&gt;</xsl:text>
													<xsl:value-of select="/GroupPolicy/TableInfo/AddPolicy/@Info" />
													<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
												</td>
											</tr>
											<xsl:if test="@ExpandQuaratinePolicy='true'">
												<xsl:if
													test="(count(QuarantineAvPolicy)=0) and (count(QuarantineFirewallPolicy)=0) and (count(QuarantineOSPPolicy)=0) and (count(QuarantineLuPolicy)=0) and (count(QuarantineCePolicy)=0) and (count(QuarantineIdsPolicy)=0) and (count(QuarantineMemPolicy)=0) and (count(QuarantineNtrPolicy)=0) and (count(QuarantineUpgradePolicy)=0) and (count(QuarantineAdaptivePolicy)=0)">
													<tr>
														<td width="5"></td>
														<td colspan="5">

															<xsl:value-of
																select="/GroupPolicy/TableInfo/NoPolicyAppliedToThisLocation/@Info" />
														</td>
													</tr>
												</xsl:if>
												<xsl:if test="count(QuarantineAdaptivePolicy)>0">
													<tr>
														<xsl:call-template name="displayQuarantinePolicy">
															<xsl:with-param name="policyId"
																			select="QuarantineAdaptivePolicy/@Id" />
															<xsl:with-param name="policyName"
																			select="QuarantineAdaptivePolicy/@Description" />
															<xsl:with-param name="locationId" select="@Id" />
															<xsl:with-param name="policyType">
																AdaptivePolicy
															</xsl:with-param>
															<xsl:with-param name="policyTargetType">
																QuarantineAdaptivePolicyApplied
															</xsl:with-param>
															<xsl:with-param name="isLocal"
																			select="QuarantineAdaptivePolicy/@IsLocalPolicy" />
															<xsl:with-param name="isDisabled"
																			select="QuarantineAdaptivePolicy/@Disabled" />
															<xsl:with-param name="isHIDisabled"
																			select="HostIntegrityPolicy/@Disabled" />
															<xsl:with-param name="localImage">
																ips_16.gif
															</xsl:with-param>
															<xsl:with-param name="sharedImage">
																ips_shared_16.gif
															</xsl:with-param>
															<xsl:with-param name="localDisabledImage">
																ips_16_g.gif
															</xsl:with-param>
															<xsl:with-param name="sharedDisabledImage">
																ips_shared_16_g.gif
															</xsl:with-param>
														</xsl:call-template>
													</tr>
												</xsl:if>
												<xsl:if test="count(QuarantineAvPolicy)>0">
													<tr>
														<xsl:call-template name="displayQuarantinePolicy">
															<xsl:with-param name="policyId"
																select="QuarantineAvPolicy/@Id" />
															<xsl:with-param name="policyName"
																select="QuarantineAvPolicy/@Description" />
															<xsl:with-param name="locationId" select="@Id" />
															<xsl:with-param name="policyType">
																AvPolicy
															</xsl:with-param>
															<xsl:with-param name="policyTargetType">
																QuarantineAvPolicyApplied
															</xsl:with-param>
															<xsl:with-param name="isLocal"
																select="QuarantineAvPolicy/@IsLocalPolicy" />
															<xsl:with-param name="isDisabled"
																select="QuarantineAvPolicy/@Disabled" />
															<xsl:with-param name="isHIDisabled"
																select="HostIntegrityPolicy/@Disabled" />
															<xsl:with-param name="localImage">
																AntiVirusLocal_16a.gif
															</xsl:with-param>
															<xsl:with-param name="sharedImage">
																AntiVirusShare_16.gif
															</xsl:with-param>
															<xsl:with-param name="localDisabledImage">
																AntiVirusLocal_16a.gif
															</xsl:with-param>
															<xsl:with-param name="sharedDisabledImage">
																AntiVirusShare_16.gif
															</xsl:with-param>
														</xsl:call-template>
													</tr>
												</xsl:if>
												<xsl:if test="count(QuarantineFirewallPolicy)>0">
													<tr>
														<xsl:call-template name="displayQuarantinePolicy">
															<xsl:with-param name="policyId"
																select="QuarantineFirewallPolicy/@Id" />
															<xsl:with-param name="policyName"
																select="QuarantineFirewallPolicy/@Description" />
															<xsl:with-param name="locationId" select="@Id" />
															<xsl:with-param name="policyType">
																FwFirewallPolicy
															</xsl:with-param>
															<xsl:with-param name="policyTargetType">
																QuarantineFWPolicyApplied
															</xsl:with-param>
															<xsl:with-param name="isLocal"
																select="QuarantineFirewallPolicy/@IsLocalPolicy" />
															<xsl:with-param name="isDisabled"
																select="QuarantineFirewallPolicy/@Disabled" />
															<xsl:with-param name="isHIDisabled"
																select="HostIntegrityPolicy/@Disabled" />
															<xsl:with-param name="localImage">
																FirewallLocal_16a.gif
															</xsl:with-param>
															<xsl:with-param name="sharedImage">
																FirewallShare_16a.gif
															</xsl:with-param>
															<xsl:with-param name="localDisabledImage">
																FirewallLocal_16a_g.gif
															</xsl:with-param>
															<xsl:with-param name="sharedDisabledImage">
																FirewallShare_16a_g.gif
															</xsl:with-param>
														</xsl:call-template>
													</tr>
												</xsl:if>
												<xsl:if test="count(QuarantineOSPPolicy)>0">
													<tr>
														<xsl:call-template name="displayQuarantinePolicy">
															<xsl:with-param name="policyId"
																select="QuarantineOSPPolicy/@Id" />
															<xsl:with-param name="policyName"
																select="QuarantineOSPPolicy/@Description" />
															<xsl:with-param name="locationId" select="@Id" />
															<xsl:with-param name="policyType">
																OpAppProtectionPolicy
															</xsl:with-param>
															<xsl:with-param name="policyTargetType">
																QuarantineOSPPolicyApplied
															</xsl:with-param>
															<xsl:with-param name="isLocal"
																select="QuarantineOSPPolicy/@IsLocalPolicy" />
															<xsl:with-param name="isDisabled"
																select="QuarantineOSPPolicy/@Disabled" />
															<xsl:with-param name="isHIDisabled"
																select="HostIntegrityPolicy/@Disabled" />
															<xsl:with-param name="localImage">
																HardwarePolicyLocal_16.gif
															</xsl:with-param>
															<xsl:with-param name="sharedImage">
																HardwarePolicyShare_16.gif
															</xsl:with-param>
															<xsl:with-param name="localDisabledImage">
																HardwarePolicyLocal_16_g.gif
															</xsl:with-param>
															<xsl:with-param name="sharedDisabledImage">
																HardwarePolicyShare_16_g.gif
															</xsl:with-param>
														</xsl:call-template>
													</tr>
												</xsl:if>
												<xsl:if test="count(QuarantineCePolicy)>0">
													<tr>
														<xsl:call-template name="displayQuarantinePolicy">
															<xsl:with-param name="policyId"
																select="QuarantineCePolicy/@Id" />
															<xsl:with-param name="policyName"
																select="QuarantineCePolicy/@Description" />
															<xsl:with-param name="locationId" select="@Id" />
															<xsl:with-param name="policyType">
																PolicyOverride
															</xsl:with-param>
															<xsl:with-param name="policyTargetType">
																QuarantineCePolicyApplied
															</xsl:with-param>
															<xsl:with-param name="isLocal"
																select="QuarantineCePolicy/@IsLocalPolicy" />
															<xsl:with-param name="isDisabled"
																select="QuarantineCePolicy/@Disabled" />
															<xsl:with-param name="isHIDisabled"
																select="HostIntegrityPolicy/@Disabled" />
															<xsl:with-param name="localImage">
																PolicyOverrideLocal_16a.gif
															</xsl:with-param>
															<xsl:with-param name="sharedImage">
																PolicyOverrideShare_16a.gif
															</xsl:with-param>
															<xsl:with-param name="localDisabledImage">
																PolicyOverrideLocal_16a_g.gif
															</xsl:with-param>
															<xsl:with-param name="sharedDisabledImage">
																PolicyOverrideShare_16a_g.gif
															</xsl:with-param>
														</xsl:call-template>
													</tr>
												</xsl:if>
												<xsl:if test="count(QuarantineLuPolicy)>0">
													<tr>
														<xsl:call-template name="displayQuarantinePolicy">
															<xsl:with-param name="policyId"
																select="QuarantineLuPolicy/@Id" />
															<xsl:with-param name="policyName"
																select="QuarantineLuPolicy/@Description" />
															<xsl:with-param name="locationId" select="@Id" />
															<xsl:with-param name="policyType">
																LuPolicy
															</xsl:with-param>
															<xsl:with-param name="policyTargetType">
																QuarantineLuPolicyApplied
															</xsl:with-param>
															<xsl:with-param name="isLocal"
																select="QuarantineLuPolicy/@IsLocalPolicy" />
															<xsl:with-param name="isDisabled"
																select="QuarantineLuPolicy/@Disabled" />
															<xsl:with-param name="isHIDisabled"
																select="HostIntegrityPolicy/@Disabled" />
															<xsl:with-param name="localImage">
																LULocal_16.gif
															</xsl:with-param>
															<xsl:with-param name="sharedImage">
																LUShared_16.gif
															</xsl:with-param>
															<xsl:with-param name="localDisabledImage">
																LULocal_16.gif
															</xsl:with-param>
															<xsl:with-param name="sharedDisabledImage">
																LUShared_16.gif
															</xsl:with-param>
														</xsl:call-template>
													</tr>
												</xsl:if>
												<xsl:if test="count(QuarantineIdsPolicy)>0">
													<tr>
														<xsl:call-template name="displayQuarantinePolicy">
															<xsl:with-param name="policyId"
																select="QuarantineIdsPolicy/@Id" />
															<xsl:with-param name="policyName"
																select="QuarantineIdsPolicy/@Description" />
															<xsl:with-param name="locationId" select="@Id" />
															<xsl:with-param name="policyType">
																IdsPolicy
															</xsl:with-param>
															<xsl:with-param name="policyTargetType">
																QuarantineIdsPolicyApplied
															</xsl:with-param>
															<xsl:with-param name="isLocal"
																select="QuarantineIdsPolicy/@IsLocalPolicy" />
															<xsl:with-param name="isDisabled"
																select="QuarantineIdsPolicy/@Disabled" />
															<xsl:with-param name="isHIDisabled"
																select="HostIntegrityPolicy/@Disabled" />
															<xsl:with-param name="localImage">
																ips_16.gif
															</xsl:with-param>
															<xsl:with-param name="sharedImage">
																ips_shared_16.gif
															</xsl:with-param>
															<xsl:with-param name="localDisabledImage">
																ips_16_g.gif
															</xsl:with-param>
															<xsl:with-param name="sharedDisabledImage">
																ips_shared_16_g.gif
															</xsl:with-param>
														</xsl:call-template>
													</tr>
												</xsl:if>
												<xsl:if test="count(QuarantineUpgradePolicy)>0">
													<tr>
														<xsl:call-template name="displayQuarantinePolicy">
															<xsl:with-param name="policyId"
																select="QuarantineUpgradePolicy/@Id" />
															<xsl:with-param name="policyName"
																select="QuarantineUpgradePolicy/@Description" />
															<xsl:with-param name="locationId" select="@Id" />
															<xsl:with-param name="policyType">
																UpgradePolicy
															</xsl:with-param>
															<xsl:with-param name="policyTargetType">
																QuarantineUpgradePolicyApplied
															</xsl:with-param>
															<xsl:with-param name="isLocal"
																select="QuarantineUpgradePolicy/@IsLocalPolicy" />
															<xsl:with-param name="isDisabled"
																select="QuarantineUpgradePolicy/@Disabled" />
															<xsl:with-param name="isHIDisabled"
																select="HostIntegrityPolicy/@Disabled" />
															<xsl:with-param name="localImage">
																ips_16.gif
															</xsl:with-param>
															<xsl:with-param name="sharedImage">
																ips_shared_16.gif
															</xsl:with-param>
															<xsl:with-param name="localDisabledImage">
																ips_16_g.gif
															</xsl:with-param>
															<xsl:with-param name="sharedDisabledImage">
																ips_shared_16_g.gif
															</xsl:with-param>
														</xsl:call-template>
													</tr>
												</xsl:if>
												<xsl:if test="count(QuarantineMemPolicy)>0">
													<tr>
														<xsl:call-template name="displayQuarantinePolicy">
															<xsl:with-param name="policyId"
																select="QuarantineMemPolicy/@Id" />
															<xsl:with-param name="policyName"
																select="QuarantineMemPolicy/@Description" />
															<xsl:with-param name="locationId" select="@Id" />
															<xsl:with-param name="policyType">
																MemPolicy
															</xsl:with-param>
															<xsl:with-param name="policyTargetType">
																QuarantineMemPolicyApplied
															</xsl:with-param>
															<xsl:with-param name="isLocal"
																select="QuarantineMemPolicy/@IsLocalPolicy" />
															<xsl:with-param name="isDisabled"
																select="QuarantineMemPolicy/@Disabled" />
															<xsl:with-param name="isHIDisabled"
																select="HostIntegrityPolicy/@Disabled" />
															<xsl:with-param name="localImage">
																ips_16.gif
															</xsl:with-param>
															<xsl:with-param name="sharedImage">
																ips_shared_16.gif
															</xsl:with-param>
															<xsl:with-param name="localDisabledImage">
																ips_16_g.gif
															</xsl:with-param>
															<xsl:with-param name="sharedDisabledImage">
																ips_shared_16_g.gif
															</xsl:with-param>
														</xsl:call-template>
													</tr>
												</xsl:if>
												<xsl:if test="count(QuarantineNtrPolicy)>0">
													<tr>
														<xsl:call-template name="displayQuarantinePolicy">
															<xsl:with-param name="policyId"
																select="QuarantineNtrPolicy/@Id" />
															<xsl:with-param name="policyName"
																select="QuarantineNtrPolicy/@Description" />
															<xsl:with-param name="locationId" select="@Id" />
															<xsl:with-param name="policyType">
																NtrPolicy
															</xsl:with-param>
															<xsl:with-param name="policyTargetType">
																QuarantineNtrPolicyApplied
															</xsl:with-param>
															<xsl:with-param name="isLocal"
																select="QuarantineNtrPolicy/@IsLocalPolicy" />
															<xsl:with-param name="isDisabled"
																select="QuarantineNtrPolicy/@Disabled" />
															<xsl:with-param name="isHIDisabled"
																select="HostIntegrityPolicy/@Disabled" />
															<xsl:with-param name="localImage">
																ips_16.gif
															</xsl:with-param>
															<xsl:with-param name="sharedImage">
																ips_shared_16.gif
															</xsl:with-param>
															<xsl:with-param name="localDisabledImage">
																ips_16_g.gif
															</xsl:with-param>
															<xsl:with-param name="sharedDisabledImage">
																ips_shared_16_g.gif
															</xsl:with-param>
														</xsl:call-template>
													</tr>
												</xsl:if>
											</xsl:if>
										</xsl:if>
										<tr>
											<td width="20" align="center"
												valign="middle">
												<xsl:text disable-output-escaping="yes">&lt;a noHover='true'  href=&quot;?</xsl:text>
												<xsl:value-of select="@Id" />
												<xsl:text disable-output-escaping="yes">;ExpandAdvancedSetting</xsl:text>
												<xsl:text disable-output-escaping="yes">;</xsl:text>
												<xsl:value-of select="@ExpandAdvancedSetting" />
												<xsl:text disable-output-escaping="yes">#loc_expand"&gt;</xsl:text>
												<xsl:choose>
													<xsl:when test="@ExpandAdvancedSetting='true'">
														<img src="{$upArrow}" width="10" height="10"
															align="middle" border="0" />
													</xsl:when>
													<xsl:otherwise>
														<img width="10" height="10" src="{$downArrow}" align="middle"
															border="0" />
													</xsl:otherwise>
												</xsl:choose>
												<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
											</td>
											<td colspan="2">
												<xsl:text disable-output-escaping="yes">&lt;a noHover='true' style=&quot;text-decoration:none&quot; href=&quot;?</xsl:text>
												<xsl:value-of select="@Id" />
												<xsl:text disable-output-escaping="yes">;ExpandAdvancedSetting</xsl:text>
												<xsl:text disable-output-escaping="yes">;</xsl:text>
												<xsl:value-of select="@ExpandAdvancedSetting" />
												<xsl:text disable-output-escaping="yes">#loc_expand"&gt;</xsl:text>
												<font COLOR="#000000">
													<xsl:value-of
														select="/GroupPolicy/TableInfo/AdvancedSettings/@Info" />
												</font>
												<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
											</td>
											<td width="7%"></td>
											<td width="1%" align="right"
												nowrap="nowrap"></td>
											<td width="7%"></td>
										</tr>
										<!-- Start of Location Specific Setting -->
										<xsl:if test="@ExpandAdvancedSetting='true'">
											<!-- Client UI Control Setting -->
											<tr>
												<td width="5"></td>
												<td colspan="4" valign="bottom">

													<xsl:value-of
														select="/GroupPolicy/TableInfo/CustomizedAgentUserInterface/@Info" />
													<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?</xsl:text>
													<xsl:value-of select="@Id" />
													<xsl:text disable-output-escaping="yes">#edit_mode"&gt;</xsl:text>
													<xsl:value-of select="@Mode" />
													<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
												</td>
												<td align="right" valign="bottom"
													border="0">
														<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?</xsl:text>
														<xsl:value-of select="@Id" />
														<xsl:text disable-output-escaping="yes">#control_setting"&gt;</xsl:text>
														<xsl:value-of select="/GroupPolicy/TableInfo/More/@Info" />
														<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
												</td>
											</tr>
											<!-- Communication Settings -->
											<tr>
												<td width="5"></td>

												<td colspan="4" valign="bottom">

													<xsl:value-of
														select="/GroupPolicy/TableInfo/CommunicatewithPolicyManager/@Info" />
													<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
													<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?</xsl:text>
													<xsl:value-of select="@Id" />
													<xsl:text disable-output-escaping="yes">#communication"&gt;</xsl:text>
													<xsl:choose>
														<xsl:when test="@CommunicationSetting='true'">
															<xsl:value-of select="/GroupPolicy/TableInfo/Group/@Info" />
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="/GroupPolicy/TableInfo/Local/@Info" />
														</xsl:otherwise>
													</xsl:choose>
													<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
													<xsl:choose>
														<xsl:when test="@mode='PULL'">
															<xsl:value-of select="/GroupPolicy/TableInfo/Pull/@Info" />
														</xsl:when>
														<xsl:when test="@mode='PUSH'">
															<xsl:value-of select="/GroupPolicy/TableInfo/Push/@Info" />
														</xsl:when>
														<xsl:when test="@mode='NO_COM'">
															<xsl:value-of select="/GroupPolicy/TableInfo/Standalone/@Info" />
														</xsl:when>
													</xsl:choose>
													<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
												</td>
												<td align="right" valign="bottom"
													border="0">
														<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?</xsl:text>
														<xsl:value-of select="@Id" />
														<xsl:text disable-output-escaping="yes">#inheritcom"&gt;</xsl:text>
														<xsl:value-of select="/GroupPolicy/TableInfo/More/@Info" />
														<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
												</td>
											</tr>
											<!-- External Communication Setting -->
											<tr>
												<td width="5"></td>

												<td colspan="4" valign="bottom">

													<xsl:value-of
														select="/GroupPolicy/TableInfo/ExternalCommunicationwithPolicyManager/@Info" />
													<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
													<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?</xsl:text>
													<xsl:value-of select="@Id" />
													<xsl:text disable-output-escaping="yes">#external_communication"&gt;</xsl:text>
													<xsl:choose>
														<xsl:when test="@ExternalCommunicationSetting='true'">
															<xsl:value-of select="/GroupPolicy/TableInfo/Group/@Info" />
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="/GroupPolicy/TableInfo/Local/@Info" />
														</xsl:otherwise>
													</xsl:choose>
													<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
													<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
												</td>
												<td align="right" valign="bottom"
													border="0">
														<xsl:text disable-output-escaping="yes">&lt;a href=&quot;?</xsl:text>
														<xsl:value-of select="@Id" />
														<xsl:text disable-output-escaping="yes">#inheritexternalcom"&gt;</xsl:text>
														<xsl:value-of select="/GroupPolicy/TableInfo/More/@Info" />
														<xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
												</td>
											</tr>
										</xsl:if>
										<!-- End of Location Specific Setting -->
									</xsl:if>

									<!-- </table> </td> </tr> -->
								</table>

							</td>
						</tr>
					</xsl:for-each>
				</table>
			</body>
		</html>

	</xsl:template>


</xsl:stylesheet>
