/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv;

import com.opencsv.ICSVParser;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class RFC4180Parser
implements ICSVParser {
    private static final Pattern SPECIAL_REGEX_CHARS = Pattern.compile("[{}()\\[\\].+*?^$\\\\|]");
    private final char separator;
    private final String separatorAsString;
    private final char quotechar;
    private final CSVReaderNullFieldIndicator nullFieldIndicator;
    private String pending;

    public RFC4180Parser() {
        this('\"', ',', CSVReaderNullFieldIndicator.NEITHER);
    }

    RFC4180Parser(char quoteChar, char separator, CSVReaderNullFieldIndicator nullFieldIndicator) {
        this.quotechar = quoteChar;
        this.separator = separator;
        this.separatorAsString = SPECIAL_REGEX_CHARS.matcher(Character.toString(separator)).replaceAll("\\\\$0");
        this.nullFieldIndicator = nullFieldIndicator;
    }

    @Override
    public char getSeparator() {
        return this.separator;
    }

    @Override
    public char getQuotechar() {
        return this.quotechar;
    }

    @Override
    public boolean isPending() {
        return this.pending != null;
    }

    @Override
    public String[] parseLineMulti(String nextLine) throws IOException {
        return this.parseLine(nextLine, true);
    }

    @Override
    public String[] parseLine(String nextLine) throws IOException {
        return this.parseLine(nextLine, false);
    }

    @Override
    public String parseToLine(String[] values) {
        StringBuilder builder = new StringBuilder(1024);
        for (int i = 0; i < values.length; ++i) {
            builder.append(this.convertToCsvValue(values[i]));
            if (i >= values.length - 1) continue;
            builder.append(this.getSeparator());
        }
        return builder.toString();
    }

    private String convertToCsvValue(String value) {
        String convertedString;
        String testValue = value == null && !this.nullFieldIndicator.equals((Object)CSVReaderNullFieldIndicator.NEITHER) ? "" : value;
        StringBuilder builder = new StringBuilder(testValue == null ? 16 : testValue.length() * 2);
        boolean containsQuoteChar = testValue != null && testValue.contains(Character.toString(this.getQuotechar()));
        boolean surroundWithQuotes = this.isSurroundWithQuotes(value, containsQuoteChar);
        String string = convertedString = !containsQuoteChar ? testValue : testValue.replaceAll(Character.toString(this.getQuotechar()), Character.toString(this.getQuotechar()) + Character.toString(this.getQuotechar()));
        if (surroundWithQuotes) {
            builder.append(this.getQuotechar());
        }
        builder.append(convertedString);
        if (surroundWithQuotes) {
            builder.append(this.getQuotechar());
        }
        return builder.toString();
    }

    private boolean isSurroundWithQuotes(String value, boolean containsQuoteChar) {
        if (value == null) {
            return this.nullFieldIndicator.equals((Object)CSVReaderNullFieldIndicator.EMPTY_QUOTES);
        }
        return containsQuoteChar || value.contains(Character.toString(this.getSeparator())) || value.contains("\n");
    }

    protected String[] parseLine(String nextLine, boolean multi) throws IOException {
        String[] elements;
        if (!multi && this.pending != null) {
            this.pending = null;
        }
        if (nextLine == null) {
            if (this.pending != null) {
                String s = this.pending;
                this.pending = null;
                return new String[]{s};
            }
            return null;
        }
        String lineToProcess = multi && this.pending != null ? this.pending + nextLine : nextLine;
        this.pending = null;
        if (!StringUtils.contains((CharSequence)lineToProcess, (int)this.quotechar)) {
            elements = this.handleEmptySeparators(this.tokenizeStringIntoArray(lineToProcess));
        } else {
            elements = this.handleEmptySeparators(this.splitWhileNotInQuotes(lineToProcess, multi));
            for (int i = 0; i < elements.length; ++i) {
                if (!StringUtils.contains((CharSequence)elements[i], (int)this.quotechar)) continue;
                elements[i] = this.handleQuotes(elements[i]);
            }
        }
        return elements;
    }

    private String[] tokenizeStringIntoArray(String nextLine) {
        return nextLine.split(this.separatorAsString, -1);
    }

    private String[] handleEmptySeparators(String[] strings) {
        if (this.nullFieldIndicator == CSVReaderNullFieldIndicator.EMPTY_SEPARATORS || this.nullFieldIndicator == CSVReaderNullFieldIndicator.BOTH) {
            for (int i = 0; i < strings.length; ++i) {
                if (!strings[i].isEmpty()) continue;
                strings[i] = null;
            }
        }
        return strings;
    }

    private String[] splitWhileNotInQuotes(String nextLine, boolean multi) {
        int currentPosition = 0;
        ArrayList<String> elements = new ArrayList<String>();
        while (currentPosition < nextLine.length()) {
            int nextSeparator = nextLine.indexOf(this.separator, currentPosition);
            int nextQuote = nextLine.indexOf(this.quotechar, currentPosition);
            if (nextSeparator == -1) {
                elements.add(nextLine.substring(currentPosition));
                currentPosition = nextLine.length();
                continue;
            }
            if (nextQuote == -1 || nextQuote > nextSeparator || nextQuote != currentPosition) {
                elements.add(nextLine.substring(currentPosition, nextSeparator));
                currentPosition = nextSeparator + 1;
                continue;
            }
            int fieldEnd = this.findEndOfFieldFromPosition(nextLine, currentPosition);
            elements.add(fieldEnd >= nextLine.length() ? nextLine.substring(currentPosition) : nextLine.substring(currentPosition, fieldEnd));
            currentPosition = fieldEnd + 1;
        }
        if (multi && this.lastElementStartedWithQuoteButDidNotEndInOne(elements)) {
            this.pending = (String)elements.get(elements.size() - 1) + "\n";
            elements.remove(elements.size() - 1);
        } else if (nextLine.lastIndexOf(this.separator) == nextLine.length() - 1) {
            elements.add("");
        }
        return elements.toArray(new String[elements.size()]);
    }

    private boolean lastElementStartedWithQuoteButDidNotEndInOne(List<String> elements) {
        String lastElement = elements.get(elements.size() - 1);
        return lastElement.startsWith(Character.toString(this.quotechar)) && !lastElement.endsWith(Character.toString(this.quotechar));
    }

    private int findEndOfFieldFromPosition(String nextLine, int currentPosition) {
        int nextQuote = nextLine.indexOf(this.quotechar, currentPosition + 1);
        boolean inQuote = false;
        while (this.haveNotFoundLastQuote(nextLine, nextQuote)) {
            if (!inQuote && nextLine.charAt(nextQuote + 1) == this.separator) {
                return nextQuote + 1;
            }
            do {
                nextQuote = nextLine.indexOf(this.quotechar, nextQuote + 1);
                boolean bl = inQuote = !inQuote;
            } while (this.haveNotFoundLastQuote(nextLine, nextQuote) && nextLine.charAt(nextQuote + 1) == this.quotechar);
        }
        return nextLine.length();
    }

    private boolean haveNotFoundLastQuote(String nextLine, int nextQuote) {
        return nextQuote != -1 && nextQuote < nextLine.length() - 1;
    }

    private String handleQuotes(String element) {
        String ret = element;
        String quoteCharString = Character.toString(this.getQuotechar());
        if (StringUtils.startsWith((CharSequence)ret, (CharSequence)quoteCharString) && StringUtils.endsWith((CharSequence)(ret = StringUtils.removeStart((String)ret, (String)quoteCharString)), (CharSequence)quoteCharString)) {
            ret = StringUtils.removeEnd((String)ret, (String)quoteCharString);
        }
        if ((ret = StringUtils.replace((String)ret, (String)(quoteCharString + quoteCharString), (String)quoteCharString)).isEmpty() && (this.nullFieldIndicator == CSVReaderNullFieldIndicator.BOTH || this.nullFieldIndicator == CSVReaderNullFieldIndicator.EMPTY_QUOTES)) {
            ret = null;
        }
        return ret;
    }

    @Override
    public CSVReaderNullFieldIndicator nullFieldIndicator() {
        return this.nullFieldIndicator;
    }

    @Override
    public String getPendingText() {
        return StringUtils.defaultString((String)this.pending);
    }
}

