/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.util.BigIntegers;

abstract class Primes {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    Primes() {
    }

    public static boolean hasAnySmallFactors(BigInteger candidate) {
        Primes.checkCandidate(candidate, "candidate");
        return Primes.implHasAnySmallFactors(candidate);
    }

    public static boolean isMRProbablePrime(BigInteger candidate, SecureRandom random, int iterations) {
        Primes.checkCandidate(candidate, "candidate");
        if (random == null) {
            throw new IllegalArgumentException("'random' cannot be null");
        }
        if (iterations < 1) {
            throw new IllegalArgumentException("'iterations' must be > 0");
        }
        if (candidate.bitLength() == 2) {
            return true;
        }
        if (!candidate.testBit(0)) {
            return false;
        }
        BigInteger wSubOne = candidate.subtract(ONE);
        BigInteger wSubTwo = candidate.subtract(TWO);
        int a = wSubOne.getLowestSetBit();
        BigInteger m = wSubOne.shiftRight(a);
        for (int i = 0; i < iterations; ++i) {
            BigInteger b = BigIntegers.createRandomInRange((BigInteger)TWO, (BigInteger)wSubTwo, (SecureRandom)random);
            if (Primes.implMRProbablePrimeToBase(candidate, wSubOne, m, a, b)) continue;
            return false;
        }
        return true;
    }

    private static void checkCandidate(BigInteger n, String name) {
        if (n == null || n.signum() < 1 || n.bitLength() < 2) {
            throw new IllegalArgumentException("'" + name + "' must be non-null and >= 2");
        }
    }

    private static boolean implHasAnySmallFactors(BigInteger x) {
        int m = 223092870;
        int r = x.mod(BigInteger.valueOf(m)).intValue();
        if (r % 2 == 0 || r % 3 == 0 || r % 5 == 0 || r % 7 == 0 || r % 11 == 0 || r % 13 == 0 || r % 17 == 0 || r % 19 == 0 || r % 23 == 0) {
            return true;
        }
        m = 58642669;
        r = x.mod(BigInteger.valueOf(m)).intValue();
        if (r % 29 == 0 || r % 31 == 0 || r % 37 == 0 || r % 41 == 0 || r % 43 == 0) {
            return true;
        }
        m = 600662303;
        r = x.mod(BigInteger.valueOf(m)).intValue();
        if (r % 47 == 0 || r % 53 == 0 || r % 59 == 0 || r % 61 == 0 || r % 67 == 0) {
            return true;
        }
        m = 33984931;
        r = x.mod(BigInteger.valueOf(m)).intValue();
        if (r % 71 == 0 || r % 73 == 0 || r % 79 == 0 || r % 83 == 0) {
            return true;
        }
        m = 89809099;
        r = x.mod(BigInteger.valueOf(m)).intValue();
        if (r % 89 == 0 || r % 97 == 0 || r % 101 == 0 || r % 103 == 0) {
            return true;
        }
        m = 167375713;
        r = x.mod(BigInteger.valueOf(m)).intValue();
        if (r % 107 == 0 || r % 109 == 0 || r % 113 == 0 || r % 127 == 0) {
            return true;
        }
        m = 371700317;
        r = x.mod(BigInteger.valueOf(m)).intValue();
        if (r % 131 == 0 || r % 137 == 0 || r % 139 == 0 || r % 149 == 0) {
            return true;
        }
        m = 645328247;
        r = x.mod(BigInteger.valueOf(m)).intValue();
        if (r % 151 == 0 || r % 157 == 0 || r % 163 == 0 || r % 167 == 0) {
            return true;
        }
        m = 1070560157;
        r = x.mod(BigInteger.valueOf(m)).intValue();
        if (r % 173 == 0 || r % 179 == 0 || r % 181 == 0 || r % 191 == 0) {
            return true;
        }
        m = 1596463769;
        r = x.mod(BigInteger.valueOf(m)).intValue();
        return r % 193 == 0 || r % 197 == 0 || r % 199 == 0 || r % 211 == 0;
    }

    private static boolean implMRProbablePrimeToBase(BigInteger w, BigInteger wSubOne, BigInteger m, int a, BigInteger b) {
        BigInteger z = b.modPow(m, w);
        if (z.equals(ONE) || z.equals(wSubOne)) {
            return true;
        }
        boolean result = false;
        for (int j = 1; j < a; ++j) {
            if ((z = z.modPow(TWO, w)).equals(wSubOne)) {
                result = true;
                break;
            }
            if (!z.equals(ONE)) continue;
            return false;
        }
        return result;
    }
}

