/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.Set;
import org.bouncycastle.jsse.provider.CipherSuiteInfo;
import org.bouncycastle.jsse.provider.JcaAlgorithmDecomposer;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.tls.CipherSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvAlgorithmDecomposer
extends JcaAlgorithmDecomposer {
    static final ProvAlgorithmDecomposer INSTANCE_TLS = new ProvAlgorithmDecomposer(true);
    static final ProvAlgorithmDecomposer INSTANCE_X509 = new ProvAlgorithmDecomposer(false);
    private final boolean enableTLSAlgorithms;

    private ProvAlgorithmDecomposer(boolean enableTLSAlgorithms) {
        this.enableTLSAlgorithms = enableTLSAlgorithms;
    }

    @Override
    public Set<String> decompose(String algorithm) {
        CipherSuiteInfo cipherSuiteInfo;
        if (algorithm.startsWith("TLS_") && null != (cipherSuiteInfo = ProvSSLContextSpi.getCipherSuiteInfo(algorithm)) && !CipherSuite.isSCSV(cipherSuiteInfo.getCipherSuite())) {
            return this.enableTLSAlgorithms ? cipherSuiteInfo.getDecompositionTLS() : cipherSuiteInfo.getDecompositionX509();
        }
        return super.decompose(algorithm);
    }
}

