/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.validator.network;

import com.sygate.scm.util.validator.network.BadNetmaskException;
import com.sygate.scm.util.validator.network.Int32;
import com.sygate.scm.util.validator.network.InvalidOctetException;

public class Netmask
extends Int32 {
    public Netmask(String ip4) throws InvalidOctetException, BadNetmaskException {
        super(ip4);
        this.validate();
    }

    public Netmask(int ip4) throws BadNetmaskException {
        super(ip4);
        this.validate();
    }

    private void validate() throws BadNetmaskException {
        short[] octets = this.getOctets();
        if (octets.length < 4) {
            throw new BadNetmaskException("Netmask does not has 4 octets!");
        }
        if (octets[0] == 0) {
            throw new BadNetmaskException("First block can not be 0!");
        }
        if (octets[3] == 254 || octets[3] == 255) {
            throw new BadNetmaskException("Fourth block can not be 254 or 255!");
        }
        for (int i = 0; i < 3; ++i) {
            if (octets[i] == 0 || octets[i] == 128 || octets[i] == 192 || octets[i] == 224 || octets[i] == 240 || octets[i] == 252 || octets[i] == 254 || octets[i] == 255) continue;
            throw new BadNetmaskException("Invalid value in octet [" + i + "] value " + octets[i]);
        }
        boolean unsetBitFound = false;
        for (int i = 0; i < 32; ++i) {
            if (this.getBit(i)) {
                if (!unsetBitFound) continue;
                throw new BadNetmaskException("Netmask " + this.toString() + " is not continuous: " + this.toBitString());
            }
            unsetBitFound = true;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Netmask)) {
            return false;
        }
        Netmask o = (Netmask)obj;
        return this.intValue() == o.intValue();
    }
}

