/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.validator.network;

import com.sygate.scm.util.validator.network.BadMulticastAddressException;
import com.sygate.scm.util.validator.network.Int32;
import com.sygate.scm.util.validator.network.InvalidOctetException;

public class MulticastIp4Address
extends Int32 {
    public MulticastIp4Address(String address) throws InvalidOctetException, BadMulticastAddressException {
        super(address);
        this.validate();
    }

    public MulticastIp4Address(int ip4) throws BadMulticastAddressException {
        super(ip4);
        this.validate();
    }

    private void validate() throws BadMulticastAddressException {
        short[] octets = this.getOctets();
        if (octets.length < 4) {
            throw new BadMulticastAddressException("Address does not has 4 octets!");
        }
        if (octets[0] < 224 || octets[0] > 239) {
            throw new BadMulticastAddressException("Invalid network for multicast address: " + octets[0]);
        }
        for (int i = 1; i < 4; ++i) {
            if (octets[i] >= 0 && octets[i] <= 255) continue;
            throw new BadMulticastAddressException("Invalid range for multicast address, octet [" + i + "] value " + octets[i]);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MulticastIp4Address)) {
            return false;
        }
        MulticastIp4Address o = (MulticastIp4Address)obj;
        return this.intValue() == o.intValue();
    }
}

