/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.validator.network;

import com.sygate.scm.util.validator.network.BadNetworkAddressException;
import com.sygate.scm.util.validator.network.MulticastIp4Address;
import com.sygate.scm.util.validator.network.Netmask;

public class MulticastIP4NetworkAddress {
    private MulticastIp4Address address;
    private Netmask netmask;

    public MulticastIP4NetworkAddress(MulticastIp4Address network, Netmask mask) throws BadNetworkAddressException {
        if (network == null) {
            throw new BadNetworkAddressException("Network is null");
        }
        if (mask == null) {
            throw new BadNetworkAddressException("Netmask is null");
        }
        this.address = network;
        this.netmask = mask;
        this.validate();
    }

    public MulticastIp4Address getAddress() {
        return this.address;
    }

    public Netmask getNetmask() {
        return this.netmask;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MulticastIP4NetworkAddress) {
            MulticastIP4NetworkAddress o = (MulticastIP4NetworkAddress)obj;
            return this.getNetmask().equals(o.getNetmask()) && this.getAddress().equals(o.getAddress());
        }
        return false;
    }

    public int hashCode() {
        return this.address.hashCode() & this.netmask.hashCode();
    }

    private void validate() throws BadNetworkAddressException {
        short[] ipOctets = this.address.getOctets();
        short[] maskOctets = this.netmask.getOctets();
        if (maskOctets[2] != 255) {
            throw new BadNetworkAddressException("The third subnet mask octet can not be anything but 255.");
        }
        if (ipOctets[3] != 0) {
            throw new BadNetworkAddressException("The fourth network octet can not be anything but 0");
        }
        for (int i = 0; i < maskOctets.length; ++i) {
            if (ipOctets[i] <= 0 || maskOctets[i] == 255) continue;
            throw new BadNetworkAddressException("Invalid multicast network for " + this.toString());
        }
    }

    public String toString() {
        return this.address.toString() + "/" + this.netmask.toString();
    }
}

