/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.validator.network;

import com.sygate.scm.util.validator.network.InvalidOctetException;

abstract class Int32 {
    private int number = 0;

    public Int32(String ip) throws InvalidOctetException {
        String[] parts = ip.split("\\.");
        for (int i = 0; i < parts.length; ++i) {
            int parsedInt = Integer.parseInt(parts[i]);
            if (parsedInt > 255 || parsedInt < 0) {
                throw new InvalidOctetException("An octet must be a number between 0 and 255.");
            }
            this.number |= parsedInt << (3 - i) * 8;
        }
    }

    public Int32(int ip) {
        this.number = ip;
    }

    public short[] getOctets() {
        short[] octets = new short[4];
        for (int i = 0; i < octets.length; ++i) {
            octets[i] = this.getOctet(i);
        }
        return octets;
    }

    public int intValue() {
        return this.number;
    }

    public String toBitString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < 32; ++i) {
            buffer.append(this.getBit(i) ? "1" : "0");
        }
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            buffer.append(this.getOctet(i));
            if (i == 3) continue;
            buffer.append(".");
        }
        return buffer.toString();
    }

    public short getOctet(int octetNumber) {
        int octet = this.number << octetNumber * 8 >>> 24;
        return (short)octet;
    }

    public boolean getBit(int bitNumber) {
        boolean bit = this.number << bitNumber >>> 31 == 1;
        return bit;
    }

    public boolean allBitsSet() {
        for (int i = 0; i < 32; ++i) {
            if (this.getBit(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.number;
    }
}

