/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.validator.network;

import com.sygate.scm.util.validator.network.UnsupportedEthernetProtocolException;

public class EthernetProtocol {
    public static final int MINIMAL_SUPPORTED_PROTOCOL_NUMBER = 512;
    public static final int MAXIMAL_SUPPORTED_PROTOCOL_NUMBER = 65280;
    public static final int PROTOCOL_INT_802_DOT_3 = -2145124353;
    public static final String PROTOCOL_STRING_802_DOT_3 = "802.3";
    private int protocol;
    private boolean is802Dot3 = false;

    public EthernetProtocol(String protocol) throws UnsupportedEthernetProtocolException {
        this(protocol, false);
    }

    public EthernetProtocol(String protocol, boolean is802d3) throws UnsupportedEthernetProtocolException {
        if (is802d3) {
            this.protocol = -2145124353;
            this.is802Dot3 = true;
        } else {
            try {
                this.protocol = Integer.parseInt(protocol, 16);
            }
            catch (Exception e) {
                throw new UnsupportedEthernetProtocolException(e.getMessage(), protocol);
            }
            this.validate();
        }
    }

    private void validate() throws UnsupportedEthernetProtocolException {
        if (this.protocol < 512 || this.protocol > 65280) {
            throw new UnsupportedEthernetProtocolException("Protocol " + this.protocol + " is not in supported range.", Integer.toHexString(this.protocol));
        }
    }

    public int getProtocol() {
        return this.protocol;
    }

    public String toString() {
        return this.is802Dot3 ? PROTOCOL_STRING_802_DOT_3 : Integer.toHexString(this.protocol);
    }
}

