/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.validator.enforcer.gateway;

import com.sygate.scm.util.validator.enforcer.gateway.InvalidAllowOtherProtocolsFilterException;
import com.sygate.scm.util.validator.enforcer.gateway.InvalidStatementParameterException;
import com.sygate.scm.util.validator.enforcer.gateway.UknownStatementException;
import com.sygate.scm.util.validator.network.EthernetProtocol;
import com.sygate.scm.util.validator.network.IpValidationException;
import com.sygate.scm.util.validator.network.MulticastIP4NetworkAddress;
import com.sygate.scm.util.validator.network.MulticastIp4Address;
import com.sygate.scm.util.validator.network.Netmask;
import com.sygate.scm.util.validator.network.UnsupportedEthernetProtocolException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FilterStatement {
    public static final String MISSING_PARAMETER = "EnforcerAdvancedPanel.msg.InvalidStatementParameter.missingParameter";
    public static final String MULTICAST_RANGE_LOWER_BORDER_MISSING = "EnforcerAdvancedPanel.msg.InvalidStatementParameter.multicastAddressRange.lowerBorderMissing";
    public static final String MULTICAST_RANGE_UPPER_BORDER_MISSING = "EnforcerAdvancedPanel.msg.InvalidStatementParameter.multicastAddressRange.upperBorderMissing";
    public static final String MULTICAST_RANGE_BORDER_INCORRECT = "EnforcerAdvancedPanel.msg.InvalidStatementParameter.multicastAddressRange.incorrectBorders";
    public static final String MULTICAST_RANGE_MISSING = "EnforcerAdvancedPanel.msg.InvalidStatementParameter.multicastAddressRange.rangeMissing";
    public static final String MULTICAST_RANGE_NUMBER_OF_PARTS = "EnforcerAdvancedPanel.msg.InvalidStatementParameter.multicastAddressRange.numberOfParts";
    public static final String PROTOCOL_RANGE_LOWER_BORDER_MISSING = "EnforcerAdvancedPanel.msg.InvalidStatementParameter.protocolRange.lowerBorderMissing";
    public static final String PROTOCOL_RANGE_UPPER_BORDER_MISSING = "EnforcerAdvancedPanel.msg.InvalidStatementParameter.protocolRange.upperBorderMissing";
    public static final String PROTOCOL_RANGE_BORDER_INCORRECT = "EnforcerAdvancedPanel.msg.InvalidStatementParameter.protocolRange.incorrectBorders";
    public static final String PROTOCOL_RANGE_MISSING = "EnforcerAdvancedPanel.msg.InvalidStatementParameter.protocolRange.rangeMissing";
    public static final String PROTOCOL_RANGE_NUMBER_OF_PARTS = "EnforcerAdvancedPanel.msg.InvalidStatementParameter.protocolRange.numberOfParts";
    public static final String ALLOW = "allow";
    public static final String BLOCK = "block";
    private String type;
    private List<EthernetProtocol> protocols = new ArrayList<EthernetProtocol>();
    private List<ProtocolRange> protocolRanges = new ArrayList<ProtocolRange>();
    private List<MulticastIp4Address> multicasts = new ArrayList<MulticastIp4Address>();
    private List<MulticastAddressRange> addressRanges = new ArrayList<MulticastAddressRange>();
    private List<MulticastIP4NetworkAddress> networks = new ArrayList<MulticastIP4NetworkAddress>();

    public FilterStatement(String statement) throws InvalidAllowOtherProtocolsFilterException, UnsupportedEthernetProtocolException, IpValidationException {
        if (statement == null) {
            throw new UknownStatementException("Statement is null!", "");
        }
        String[] parts = (statement = statement.trim().toLowerCase()).split(" ");
        if (parts.length < 2) {
            throw new InvalidStatementParameterException(MISSING_PARAMETER);
        }
        if (ALLOW.equals(parts[0])) {
            this.type = ALLOW;
        } else if (BLOCK.equals(parts[0])) {
            this.type = BLOCK;
        } else {
            throw new UknownStatementException(parts[0], parts[0]);
        }
        this.populate(statement, parts);
    }

    private void populate(String statement, String[] parts) throws InvalidAllowOtherProtocolsFilterException, UnsupportedEthernetProtocolException, IpValidationException {
        StringBuffer buffer = new StringBuffer();
        for (int i = 1; i < parts.length; ++i) {
            buffer.append(parts[i]);
        }
        String[] parameters = buffer.toString().split("\\,");
        for (int i = 0; i < parameters.length; ++i) {
            String parameter = parameters[i].trim();
            if (parameter.indexOf("-") < 0) {
                if (parameter.indexOf(".") < 0) {
                    this.protocols.add(new EthernetProtocol(parameter));
                    continue;
                }
                String[] rangeparts = parameter.split("\\/");
                if (rangeparts.length != 2) {
                    if ("802.3".equals(parameter.trim())) {
                        this.protocols.add(new EthernetProtocol(parameter, true));
                        continue;
                    }
                    this.multicasts.add(new MulticastIp4Address(parameter));
                    continue;
                }
                this.networks.add(new MulticastIP4NetworkAddress(new MulticastIp4Address(rangeparts[0]), new Netmask(rangeparts[1])));
                continue;
            }
            if (parameter.indexOf(".") < 0) {
                this.protocolRanges.add(new ProtocolRange(parameter));
                continue;
            }
            this.addressRanges.add(new MulticastAddressRange(parameter));
        }
    }

    public static FilterStatement validate(String statement) throws InvalidAllowOtherProtocolsFilterException, UnsupportedEthernetProtocolException, IpValidationException {
        return new FilterStatement(statement);
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.type).append(" ");
        buffer.append(this.toStringWithoutType());
        return buffer.toString();
    }

    public String toStringWithoutType() {
        Object element;
        StringBuffer buffer = new StringBuffer();
        boolean flag = this.protocols.size() > 0;
        Iterator<Object> iter = this.protocols.iterator();
        while (iter.hasNext()) {
            element = iter.next();
            buffer.append(((EthernetProtocol)element).toString());
            if (!iter.hasNext()) continue;
            buffer.append(", ");
        }
        if (flag && this.protocolRanges.size() > 0) {
            buffer.append(", ");
        }
        flag = flag || this.protocolRanges.size() > 0;
        iter = this.protocolRanges.iterator();
        while (iter.hasNext()) {
            element = (ProtocolRange)iter.next();
            buffer.append(((ProtocolRange)element).toString());
            if (!iter.hasNext()) continue;
            buffer.append(", ");
        }
        if (flag && this.multicasts.size() > 0) {
            buffer.append(", ");
        }
        flag = flag || this.multicasts.size() > 0;
        iter = this.multicasts.iterator();
        while (iter.hasNext()) {
            element = (MulticastIp4Address)iter.next();
            buffer.append(((MulticastIp4Address)element).toString());
            if (!iter.hasNext()) continue;
            buffer.append(", ");
        }
        if (flag && this.addressRanges.size() > 0) {
            buffer.append(", ");
        }
        flag = flag || this.addressRanges.size() > 0;
        iter = this.addressRanges.iterator();
        while (iter.hasNext()) {
            element = (MulticastAddressRange)iter.next();
            buffer.append(((MulticastAddressRange)element).toString());
            if (!iter.hasNext()) continue;
            buffer.append(", ");
        }
        if (flag && this.networks.size() > 0) {
            buffer.append(", ");
        }
        iter = this.networks.iterator();
        while (iter.hasNext()) {
            element = (MulticastIP4NetworkAddress)iter.next();
            buffer.append(((MulticastIP4NetworkAddress)element).toString());
            if (!iter.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    static class MulticastAddressRange {
        private MulticastIp4Address lower;
        private MulticastIp4Address upper;

        public MulticastAddressRange(String range) throws InvalidStatementParameterException, IpValidationException {
            if (range == null) {
                throw new InvalidStatementParameterException(FilterStatement.MULTICAST_RANGE_MISSING);
            }
            String[] rangeParts = range.split("\\-");
            if (rangeParts.length != 2) {
                throw new InvalidStatementParameterException(FilterStatement.MULTICAST_RANGE_NUMBER_OF_PARTS);
            }
            this.lower = new MulticastIp4Address(rangeParts[0]);
            this.upper = new MulticastIp4Address(rangeParts[1]);
            if (this.lower.intValue() > this.upper.intValue()) {
                throw new InvalidStatementParameterException(FilterStatement.MULTICAST_RANGE_BORDER_INCORRECT);
            }
        }

        public MulticastAddressRange(MulticastIp4Address lower, MulticastIp4Address upper) throws InvalidStatementParameterException {
            if (lower == null) {
                throw new InvalidStatementParameterException(FilterStatement.MULTICAST_RANGE_LOWER_BORDER_MISSING);
            }
            if (upper == null) {
                throw new InvalidStatementParameterException(FilterStatement.MULTICAST_RANGE_UPPER_BORDER_MISSING);
            }
            if (lower.intValue() > upper.intValue()) {
                throw new InvalidStatementParameterException(FilterStatement.MULTICAST_RANGE_BORDER_INCORRECT);
            }
            this.lower = lower;
            this.upper = upper;
        }

        public MulticastIp4Address getLower() {
            return this.lower;
        }

        public MulticastIp4Address getUpper() {
            return this.upper;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.lower.toString());
            buffer.append("-");
            buffer.append(this.upper.toString());
            return buffer.toString();
        }
    }

    static class ProtocolRange {
        private EthernetProtocol lower;
        private EthernetProtocol upper;

        public ProtocolRange(String range) throws InvalidStatementParameterException, UnsupportedEthernetProtocolException {
            if (range == null) {
                throw new InvalidStatementParameterException(FilterStatement.PROTOCOL_RANGE_MISSING);
            }
            String[] rangeParts = range.split("\\-");
            if (rangeParts.length != 2) {
                throw new InvalidStatementParameterException(FilterStatement.PROTOCOL_RANGE_NUMBER_OF_PARTS);
            }
            this.lower = new EthernetProtocol(rangeParts[0]);
            this.upper = new EthernetProtocol(rangeParts[1]);
            if (this.lower.getProtocol() > this.upper.getProtocol()) {
                throw new InvalidStatementParameterException(FilterStatement.PROTOCOL_RANGE_BORDER_INCORRECT);
            }
        }

        public ProtocolRange(EthernetProtocol lower, EthernetProtocol upper) throws InvalidStatementParameterException {
            if (lower == null) {
                throw new InvalidStatementParameterException(FilterStatement.PROTOCOL_RANGE_LOWER_BORDER_MISSING);
            }
            if (upper == null) {
                throw new InvalidStatementParameterException(FilterStatement.PROTOCOL_RANGE_UPPER_BORDER_MISSING);
            }
            if (lower.getProtocol() > upper.getProtocol()) {
                throw new InvalidStatementParameterException(FilterStatement.PROTOCOL_RANGE_BORDER_INCORRECT);
            }
            this.lower = lower;
            this.upper = upper;
        }

        public EthernetProtocol getLower() {
            return this.lower;
        }

        public EthernetProtocol getUpper() {
            return this.upper;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(Integer.toHexString(this.lower.getProtocol()));
            buffer.append("-");
            buffer.append(Integer.toHexString(this.upper.getProtocol()));
            return buffer.toString();
        }
    }
}

