/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.validator.enforcer.gateway;

import com.sygate.scm.util.validator.enforcer.gateway.FilterStatement;
import com.sygate.scm.util.validator.enforcer.gateway.InvalidAllowOtherProtocolsFilterException;
import com.sygate.scm.util.validator.enforcer.gateway.MaximalFilterSizeExcitedException;
import com.sygate.scm.util.validator.network.IpValidationException;
import com.sygate.scm.util.validator.network.UnsupportedEthernetProtocolException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AllowOtherProtocolsFilter {
    public static final int MAXIMAL_LENGTH = 511;
    private List<FilterStatement> statements = new ArrayList<FilterStatement>();

    public AllowOtherProtocolsFilter(String filter) throws InvalidAllowOtherProtocolsFilterException, IpValidationException, UnsupportedEthernetProtocolException {
        if (filter == null) {
            return;
        }
        if (!"".equals(filter.trim())) {
            this.parse(filter);
        }
        String consolidateFiltar = this.toString();
        if (consolidateFiltar.trim().length() > 511) {
            throw new MaximalFilterSizeExcitedException("Filter size is " + consolidateFiltar.trim().length() + ", which is more than maximum of 511 characters.");
        }
    }

    private void parse(String filter) throws InvalidAllowOtherProtocolsFilterException, IpValidationException, UnsupportedEthernetProtocolException {
        String[] statementStrings = filter.split("\\;");
        for (int i = 0; i < statementStrings.length; ++i) {
            this.statements.add(new FilterStatement(statementStrings[i]));
        }
    }

    public List<FilterStatement> getStatements() {
        ArrayList<FilterStatement> clones = new ArrayList<FilterStatement>();
        clones.addAll(this.statements);
        return clones;
    }

    public boolean removeStatement(int order) {
        FilterStatement obj = this.statements.remove(order);
        return obj != null;
    }

    public boolean removeStatement(FilterStatement statement) {
        if (statement == null) {
            return false;
        }
        return this.statements.remove(statement);
    }

    public void addStatement(String statement) throws InvalidAllowOtherProtocolsFilterException, IpValidationException, UnsupportedEthernetProtocolException {
        if (this.statements.contains(FilterStatement.validate(statement))) {
            return;
        }
        this.statements.add(new FilterStatement(statement));
    }

    public void addStatement(FilterStatement statement) throws InvalidAllowOtherProtocolsFilterException {
        if (this.statements.contains(statement)) {
            return;
        }
        this.statements.add(statement);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        List<FilterStatement> allows = this.getStatementsByType("allow");
        List<FilterStatement> blocks = this.getStatementsByType("block");
        if (allows.size() > 0) {
            buffer.append("allow").append(" ");
            buffer.append(this.buildStatement(allows));
        }
        if (blocks.size() > 0) {
            if (allows.size() > 0) {
                buffer.append("; ");
            }
            buffer.append("block").append(" ");
            buffer.append(this.buildStatement(blocks));
        }
        return buffer.toString();
    }

    private String buildStatement(List<FilterStatement> statements) {
        StringBuffer buffer = new StringBuffer();
        Iterator<FilterStatement> iter = statements.iterator();
        while (iter.hasNext()) {
            FilterStatement element = iter.next();
            buffer.append(element.toStringWithoutType());
            if (!iter.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    private List<FilterStatement> getStatementsByType(String type) {
        ArrayList<FilterStatement> statementsByType = new ArrayList<FilterStatement>();
        for (FilterStatement element : this.statements) {
            if (!type.equals(element.getType())) continue;
            statementsByType.add(element);
        }
        return statementsByType;
    }
}

