/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.validator;

import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.validator.BaseValidator;
import com.sygate.scm.util.validator.ValidatorResult;
import java.util.regex.Pattern;

public class EmailAddressValidator
extends BaseValidator {
    private static final String LOCAL_PART = "^[a-zA-Z0-9!#$%&'*+/=?^_`{|}~-]+(\\.[a-zA-Z0-9!#$%&'*+/=?^_`{|}~-]+)*$";
    private static final String DOMAIN_NAME = "^([^.!#$%&',:;+/\\\\*\\[\\]\\(\\)<=>?@^`{|}~]+)(\\.[^.!#$%&',:;+/\\\\*\\[\\]\\(\\)<=>?@^`{|}~]+)+$";
    private final String emailAddress;

    EmailAddressValidator(String emailAddress) {
        EmailAddressValidator.checkNull(emailAddress);
        this.emailAddress = emailAddress;
    }

    public static EmailAddressValidator newInstance(String emailAddress) {
        return new EmailAddressValidator(emailAddress);
    }

    public static boolean isValid(String emailAddress) {
        return !EmailAddressValidator.newInstance(emailAddress).validate().hasError();
    }

    @Override
    public ValidatorResult validate() {
        ValidatorResult result = new ValidatorResult();
        String[] parts = this.emailAddress.split("@");
        if (StringUtilities.countMatches(this.emailAddress, "@") != 1 || parts.length != 2) {
            result.add((Object)this.emailAddress, this);
        } else if (!EmailAddressValidator.validateLocalPart(parts[0]) || !EmailAddressValidator.validateDomainName(parts[1])) {
            result.add((Object)this.emailAddress, this);
        }
        return result;
    }

    public static boolean validateDomainName(String domainName) {
        if (StringUtilities.isEmpty(domainName)) {
            return false;
        }
        return Pattern.matches(DOMAIN_NAME, domainName);
    }

    public static boolean validateLocalPart(String localPart) {
        if (StringUtilities.isEmpty(localPart)) {
            return false;
        }
        return Pattern.matches(LOCAL_PART, localPart);
    }
}

