/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.validator;

import com.sygate.scm.util.validator.BaseValidator;
import com.sygate.scm.util.validator.ValidatorResult;
import java.util.regex.Pattern;

public class AccurateIpv4Validator
extends BaseValidator {
    private static final String ACCURATE_IP_PATTERN = "(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)";
    protected String ipAddress;

    AccurateIpv4Validator(String ipAddress) {
        AccurateIpv4Validator.checkNull(ipAddress);
        this.ipAddress = ipAddress;
    }

    public static AccurateIpv4Validator newInstance(String ipAddress) {
        return new AccurateIpv4Validator(ipAddress);
    }

    @Override
    public ValidatorResult validate() {
        ValidatorResult result = new ValidatorResult();
        if (!Pattern.matches(ACCURATE_IP_PATTERN, this.getTargetIpAddress())) {
            result.add((Object)this.getIpAddress(), this);
        }
        return result;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getTargetIpAddress() {
        return this.ipAddress;
    }
}

