/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.template;

import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.template.Template;
import com.sygate.scm.util.template.TemplateImpl;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.SAXException;

public class TemplateManager {
    private static Hashtable<String, String> tagDictionary;
    private static TransformerFactory fac;

    public static Template getTemplate(InputStream xmlIS) throws ParserConfigurationException, SAXException, IOException {
        return new TemplateImpl(xmlIS);
    }

    public static Template getTemplate(File xmlFile) throws ParserConfigurationException, SAXException, IOException {
        TemplateImpl templateImpl;
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(xmlFile));
            templateImpl = new TemplateImpl(is);
        }
        catch (Throwable throwable) {
            IOUtilities.closeInputStream(is);
            throw throwable;
        }
        IOUtilities.closeInputStream(is);
        return templateImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Template getTemplate(InputStream xmlIS, InputStream xsltIS, boolean isSBE) throws Exception {
        Template template;
        if (!isSBE) {
            return TemplateManager.getTemplate(xmlIS);
        }
        if (xmlIS == null || xsltIS == null) {
            throw new IllegalArgumentException("XML/XSLT File for transformation is null");
        }
        BufferedInputStream resultIS = null;
        ByteArrayOutputStream transResultOS = null;
        try {
            StreamSource eeXMLSource = new StreamSource(xmlIS);
            StreamSource xsltISSource = new StreamSource(xsltIS);
            transResultOS = new ByteArrayOutputStream();
            Transformer trans = fac.newTransformer(xsltISSource);
            trans.transform(eeXMLSource, new StreamResult(transResultOS));
            resultIS = new BufferedInputStream(new ByteArrayInputStream(transResultOS.toByteArray()));
            template = TemplateManager.getTemplate(resultIS);
        }
        catch (Throwable throwable) {
            IOUtilities.closeInputStream(resultIS);
            IOUtilities.closeOutputStream(transResultOS);
            throw throwable;
        }
        IOUtilities.closeInputStream(resultIS);
        IOUtilities.closeOutputStream(transResultOS);
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Template getTemplateAndCloseStream(InputStream tmplIS, InputStream xsltIS, boolean isSBE) throws Exception {
        try {
            if (xsltIS == null) {
                Template template = TemplateManager.getTemplate(tmplIS);
                return template;
            }
            Template template = TemplateManager.getTemplate(tmplIS, xsltIS, isSBE);
            return template;
        }
        finally {
            IOUtilities.closeInputStream(tmplIS);
            if (xsltIS != null) {
                IOUtilities.closeInputStream(xsltIS);
            }
        }
    }

    public static Template getSemLocalSettingsTemplate(boolean isSBE) throws Exception {
        InputStream slsIS = TemplateManager.class.getResourceAsStream("semlocalsettings_template.xml");
        return TemplateManager.getTemplateAndCloseStream(slsIS, null, isSBE);
    }

    public static Template getSemConfigRootTemplate(boolean isSBE) throws Exception {
        InputStream scrIS = TemplateManager.class.getResourceAsStream("semconfigroot_template.xml");
        return TemplateManager.getTemplateAndCloseStream(scrIS, null, isSBE);
    }

    public static Template getSemDomainTemplate(boolean isSBE) throws Exception {
        InputStream sdIS = TemplateManager.class.getResourceAsStream("semdomain_template.xml");
        InputStream sdxsltIS = TemplateManager.class.getResourceAsStream("semdomain_template.xsl");
        return TemplateManager.getTemplateAndCloseStream(sdIS, sdxsltIS, isSBE);
    }

    public static Template getSemClientGroupTreeTemplate(boolean isSBE) throws Exception {
        InputStream scgtIS = TemplateManager.class.getResourceAsStream("semclientgrouptree_template.xml");
        InputStream scgtxsltIS = TemplateManager.class.getResourceAsStream("semclientgrouptree_template.xsl");
        return TemplateManager.getTemplateAndCloseStream(scgtIS, scgtxsltIS, isSBE);
    }

    public static InputStream getCleanLuSesmContentCatalogXsl() {
        return TemplateManager.class.getResourceAsStream("CleanLuSesmContentCatalog.xsl");
    }

    public static Template getSysAdministratorArrayTemplate(boolean isSBE) throws Exception {
        InputStream doIS = TemplateManager.class.getResourceAsStream("SysAdministratorArray_template.xml");
        return TemplateManager.getTemplateAndCloseStream(doIS, null, isSBE);
    }

    public static Template getDomainObjectsTemplate(boolean isSBE) throws Exception {
        InputStream doIS = TemplateManager.class.getResourceAsStream("domain_objects_template.xml");
        return TemplateManager.getTemplateAndCloseStream(doIS, null, isSBE);
    }

    public static Template getSemGroupPolicyTemplate(boolean isSBE) throws Exception {
        InputStream sgpIS = TemplateManager.class.getResourceAsStream("policy_template.xml");
        InputStream sgpxsltIS = TemplateManager.class.getResourceAsStream("policy_template.xsl");
        return TemplateManager.getTemplateAndCloseStream(sgpIS, sgpxsltIS, isSBE);
    }

    public static Template getSemGroupPolicyTemplate(boolean isSBE, boolean isEnterprise) throws Exception {
        InputStream sgpIS = TemplateManager.class.getResourceAsStream("policy_template.xml");
        InputStream sgpxsltIS = TemplateManager.class.getResourceAsStream("policy_template.xsl");
        Template policyTemplate = TemplateManager.getTemplateAndCloseStream(sgpIS, sgpxsltIS, isSBE);
        if (isEnterprise) {
            String policyTemplateXML = policyTemplate.getXML();
            ByteArrayInputStream policyTemplateXmlIs = new ByteArrayInputStream(policyTemplateXML.getBytes("UTF-8"));
            InputStream sgpEnterpriseXslt = TemplateManager.class.getResourceAsStream("policy_template_enterprise.xsl");
            policyTemplate = TemplateManager.getTemplateAndCloseStream(policyTemplateXmlIs, sgpEnterpriseXslt, isEnterprise);
        }
        return policyTemplate;
    }

    public static Template getFwNetworkServiceGroupsTemplate(boolean isSbe) throws Exception {
        InputStream fnsgIs = TemplateManager.class.getResourceAsStream("fwnetworkservicegroups_template.xml");
        return TemplateManager.getTemplateAndCloseStream(fnsgIs, null, isSbe);
    }

    public static Template getDefaultSharedPolicyTemplate(boolean isSbe) throws Exception {
        InputStream dspIs = TemplateManager.class.getResourceAsStream("default_shared_policies_template.xml");
        InputStream xsltIs = TemplateManager.class.getResourceAsStream("default_shared_policies_template.xsl");
        return TemplateManager.getTemplateAndCloseStream(dspIs, xsltIs, isSbe);
    }

    public static Template getCloudConsoleConfigTemplate() throws Exception {
        InputStream dspIS = TemplateManager.class.getResourceAsStream("VisibilityMockup.xml");
        return TemplateManager.getTemplateAndCloseStream(dspIS, null, false);
    }

    public static void clear() {
        tagDictionary.clear();
    }

    public static void put(String tagName, String value) {
        tagDictionary.put(tagName, value);
    }

    public static String get(String tagName) {
        return tagDictionary.get(tagName);
    }

    static {
        System.setProperty("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
        tagDictionary = new Hashtable();
        fac = TransformerFactory.newInstance();
    }
}

