/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.template;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.SchemaContainer;
import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.XmlUtils;
import com.sygate.scm.util.template.Template;
import com.sygate.scm.util.template.TemplateManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TemplateImpl
implements Template {
    private static String xmlFileName = "com.sygate.scm.util.template.template";
    private Document document;
    private boolean hasWashed = false;

    public TemplateImpl(InputStream xmlIS) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = XmlUtils.getSecureDocumentBuilder();
        this.document = builder.parse(xmlIS);
    }

    @Override
    public void setTag(String tagName, String value) {
        TemplateManager.put("$$" + tagName + "$$", value);
    }

    @Override
    public String getXML() {
        this.wash();
        return XMLHelper.getXmlDataFromDocument(this.document);
    }

    private void wash() {
        if (!this.hasWashed) {
            this.loadI18nTags();
            Element root = this.document.getDocumentElement();
            this.washAllGUID(root);
            this.hasWashed = true;
        }
    }

    private void washAllGUID(Node e) {
        String attrValue;
        String newValue;
        if (e.getNodeType() == 1) {
            NamedNodeMap nodeMap = e.getAttributes();
            for (int i = 0; i < nodeMap.getLength(); ++i) {
                Node attr = nodeMap.item(i);
                String attrValue2 = attr.getNodeValue();
                String newValue2 = this.replace(attrValue2);
                if (newValue2 == null) continue;
                attr.setNodeValue(newValue2);
            }
            NodeList nl = e.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                this.washAllGUID(node);
            }
        } else if ((e.getNodeType() == 3 || e.getNodeType() == 4) && (newValue = this.replace(attrValue = e.getNodeValue().trim())) != null) {
            e.setNodeValue(newValue);
        }
    }

    private String replace(String value) {
        Object newValue = null;
        if ("$$AUTOID$$".equalsIgnoreCase(value)) {
            newValue = new GUIDGenerator().getGUIDString();
        } else if ("$$AUTOTIME$$".equalsIgnoreCase(value)) {
            newValue = "" + TimeUtil.getServerTime();
        } else if (value.startsWith("$$ID")) {
            newValue = TemplateManager.get(value);
            if (newValue == null) {
                newValue = new GUIDGenerator().getGUIDString();
                TemplateManager.put(value, (String)newValue);
            }
        } else {
            newValue = TemplateManager.get(value);
        }
        return newValue;
    }

    private void loadI18nTags() {
        ResourceBundle bundle = MessageResources.getResourceBundle(xmlFileName);
        if (bundle == null) {
            return;
        }
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            TemplateManager.put(key, bundle.getString(key));
        }
    }

    @Override
    public SchemaContainer getSchemaContainer() throws SAXException, IOException, ValidationException {
        return (SchemaContainer)AbstractSchema.readXML(this.getXML());
    }
}

