/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.systemlockdown.fileparser;

import com.sygate.scm.util.systemlockdown.FingerprintListHashType;
import com.sygate.scm.util.systemlockdown.FingerprintListHashValue;
import com.sygate.scm.util.systemlockdown.FingerprintListHashValues;
import com.sygate.scm.util.systemlockdown.exception.FingerprintListException;
import com.sygate.scm.util.systemlockdown.fileparser.FingerprintListFileParser;
import java.io.IOException;
import java.nio.file.Path;
import java.util.logging.Level;

public class PlainTextMd5FileParser
extends FingerprintListFileParser {
    public PlainTextMd5FileParser(Path filePath) {
        super(filePath);
    }

    @Override
    public boolean isValidFileFormat() {
        logger.log(Level.INFO, "PlainTextMd5FileParser >>isValidFileFormat, file: {0}...", this.filePath);
        String firstLine = PlainTextMd5FileParser.readFirstLine(this.filePath);
        firstLine = this.readFirstColumnFromLine(firstLine);
        boolean result = FingerprintListHashType.HASH_TYPE_MD5.isValidHashValue(firstLine);
        logger.log(Level.INFO, "PlainTextMd5FileParser >>isValidFileFormat, result: {0}", result);
        return result;
    }

    @Override
    protected void parseHashValuesFromLine(FingerprintListHashValues hashValues, String line) throws IOException, FingerprintListException {
        hashValues.addHashValue(new FingerprintListHashValue(this.readFirstColumnFromLine(line), null));
    }
}

