/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.systemlockdown.fileparser;

import com.opencsv.CSVParser;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.systemlockdown.FingerprintListHashType;
import com.sygate.scm.util.systemlockdown.FingerprintListHashValue;
import com.sygate.scm.util.systemlockdown.FingerprintListHashValues;
import com.sygate.scm.util.systemlockdown.exception.FingerprintListException;
import com.sygate.scm.util.systemlockdown.exception.FingerprintListInvalidFileException;
import com.sygate.scm.util.systemlockdown.exception.FingerprintListInvalidHashException;
import com.sygate.scm.util.systemlockdown.fileparser.FingerprintListFileParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.apache.commons.codec.Charsets;

public class PlainTextCsvFileParser
extends FingerprintListFileParser {
    public PlainTextCsvFileParser(Path filePath) {
        super(filePath);
    }

    @Override
    public boolean isValidFileFormat() {
        logger.log(Level.INFO, "PlainTextCsvFileParser >>isValidFileFormat, file: {0}...", this.filePath);
        try {
            String[] headerColumns;
            String firstLine = PlainTextCsvFileParser.readFirstLine(this.filePath);
            if (StringUtilities.isEmpty(firstLine) || firstLine.charAt(0) == '\"') {
                logger.log(Level.INFO, "PlainTextCsvFileParser >>isValidFileFormat, First line is empty or quoted!");
                return false;
            }
            CSVParser csvParser = new CSVParser(',', '\"', CSV_DELIM_GRAVE);
            for (String columnName : headerColumns = csvParser.parseLine(firstLine)) {
                if (!FingerprintListHashType.getAllHashTypeNames().contains(columnName.toUpperCase())) continue;
                logger.log(Level.INFO, "PlainTextCsvFileParser >>isValidFileFormat, is a valid file format!");
                return true;
            }
        }
        catch (IOException e) {
            logger.log(Level.INFO, "PlainTextCsvFileParser >>isValidFileFormat, Exception!", e);
        }
        logger.log(Level.INFO, "PlainTextCsvFileParser >>isValidFileFormat, not a valid file format!");
        return false;
    }

    @Override
    public FingerprintListHashValues readFingerprintListFromFile() throws FingerprintListException {
        FingerprintListHashValues fingerprintListHashValues;
        block9: {
            if (!this.isValidFileFormat()) {
                throw new FingerprintListInvalidFileException();
            }
            InputStream inputStream = Files.newInputStream(this.filePath, new OpenOption[0]);
            try {
                fingerprintListHashValues = PlainTextCsvFileParser.readHashValuesFromStream(inputStream);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FingerprintListInvalidHashException | IOException exc) {
                    throw new FingerprintListInvalidFileException(exc.getMessage(), exc);
                }
            }
            inputStream.close();
        }
        return fingerprintListHashValues;
    }

    public static FingerprintListHashValues readHashValuesFromStream(InputStream inputStream) throws FingerprintListException {
        FingerprintListHashValues hashValues = new FingerprintListHashValues();
        try {
            String line;
            AtomicReference exception = new AtomicReference();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, Charsets.UTF_8));
            String headerLine = reader.readLine();
            if (headerLine == null || headerLine.isEmpty()) {
                throw new FingerprintListException("The InputStream data is empty, Cannot read header from it!");
            }
            CSVParser csvParser = new CSVParser(',', '\"', CSV_DELIM_GRAVE);
            String[] headerColumns = csvParser.parseLine(headerLine);
            EnumMap<FingerprintListHashType, Integer> hashTypeIndexMap = new EnumMap<FingerprintListHashType, Integer>(FingerprintListHashType.class);
            FingerprintListHashType.getAllHashTypes().forEach(hashType -> hashTypeIndexMap.put((FingerprintListHashType)((Object)hashType), PlainTextCsvFileParser.getColumnIndex(headerColumns, hashType)));
            hashTypeIndexMap.forEach((hashType, index) -> logger.log(Level.INFO, "readChecksumFile >> HashType: {0}, Column Index: {1}", new Object[]{hashType.getHashTypeName(), index}));
            while ((line = reader.readLine()) != null) {
                String[] values = csvParser.parseLine(line);
                EnumMap<FingerprintListHashType, String> hashTypeValues = new EnumMap<FingerprintListHashType, String>(FingerprintListHashType.class);
                hashTypeIndexMap.forEach((hashType, index) -> {
                    try {
                        hashTypeValues.put((FingerprintListHashType)((Object)hashType), PlainTextCsvFileParser.readHashValue(values, index));
                    }
                    catch (FingerprintListInvalidFileException exc) {
                        exception.set(exc);
                    }
                });
                hashValues.addHashValue(new FingerprintListHashValue(hashTypeValues));
            }
            if (exception.get() != null) {
                throw (FingerprintListException)exception.get();
            }
        }
        catch (IOException exc) {
            throw new FingerprintListInvalidFileException(exc.getMessage(), exc);
        }
        return hashValues;
    }

    private static int getColumnIndex(String[] headerColumns, FingerprintListHashType hashType) {
        for (int index = 0; index < headerColumns.length; ++index) {
            if (!hashType.getHashTypeName().equalsIgnoreCase(headerColumns[index])) continue;
            return index;
        }
        return -1;
    }

    private static String readHashValue(String[] values, int index) throws FingerprintListInvalidFileException {
        if (index < 0) {
            return null;
        }
        if (index >= values.length) {
            throw new FingerprintListInvalidFileException();
        }
        return values[index];
    }
}

