/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.systemlockdown.fileparser;

import com.sygate.scm.util.systemlockdown.FingerprintListHashValues;
import com.sygate.scm.util.systemlockdown.exception.FingerprintListException;
import com.sygate.scm.util.systemlockdown.exception.FingerprintListInvalidFileException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FingerprintListFileParser {
    public static final Logger logger = Logger.getLogger(FingerprintListFileParser.class.getName());
    public static final char CSV_SEPARATOR = ',';
    public static final char CSV_QUOTE_CHARACTER = '\"';
    public static final char CSV_DELIM_GRAVE = "`".charAt(0);
    public static final String PLAIN_TEXT_SEPARATOR = " ,\t\n\r\f";
    protected Path filePath;

    public FingerprintListFileParser(Path filePath) {
        this.filePath = filePath;
    }

    public FingerprintListHashValues readFingerprintListFromFile() throws FingerprintListException {
        FingerprintListHashValues hashValues = new FingerprintListHashValues();
        if (!this.isValidFileFormat()) {
            throw new FingerprintListInvalidFileException();
        }
        try (BufferedReader in = new BufferedReader(new InputStreamReader(Files.newInputStream(this.filePath, new OpenOption[0])));){
            String line;
            while ((line = in.readLine()) != null) {
                this.parseHashValuesFromLine(hashValues, line);
            }
        }
        catch (IOException exc) {
            throw new FingerprintListInvalidFileException(exc.getMessage(), exc);
        }
        return hashValues;
    }

    public boolean isValidFileFormat() {
        logger.log(Level.SEVERE, "Need to be implemented in child class!");
        return true;
    }

    protected void parseHashValuesFromLine(FingerprintListHashValues hashValues, String line) throws IOException, FingerprintListException {
        throw new FingerprintListException("Need to be implemented in child class!");
    }

    protected String readFirstColumnFromLine(String line) {
        String hashValue = line;
        StringTokenizer tokens = new StringTokenizer(line, PLAIN_TEXT_SEPARATOR);
        if (tokens.hasMoreTokens()) {
            hashValue = tokens.nextToken();
        }
        return hashValue;
    }

    protected static String readFirstLine(Path filePath) {
        logger.log(Level.INFO, "SystemLockdownFileParser >>readFirstLine, file: {0}...", filePath);
        String firstLine = null;
        try (BufferedReader in = new BufferedReader(new InputStreamReader(Files.newInputStream(filePath, new OpenOption[0])));){
            firstLine = in.readLine();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "SystemLockdownFileParser >>readFirstLine, >> Exception!", e);
        }
        return firstLine;
    }
}

