/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.systemlockdown.fileparser;

import com.opencsv.CSVParser;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.systemlockdown.FingerprintListHashType;
import com.sygate.scm.util.systemlockdown.FingerprintListHashValue;
import com.sygate.scm.util.systemlockdown.FingerprintListHashValues;
import com.sygate.scm.util.systemlockdown.exception.FingerprintListException;
import com.sygate.scm.util.systemlockdown.fileparser.FingerprintListFileParser;
import java.io.IOException;
import java.nio.file.Path;
import java.util.logging.Level;

public class ChecksumExeCsvFileParser
extends FingerprintListFileParser {
    private static final Integer INDEX_MD5 = 0;
    private static final Integer INDEX_SHA256 = 1;

    public ChecksumExeCsvFileParser(Path filePath) {
        super(filePath);
    }

    @Override
    public boolean isValidFileFormat() {
        logger.log(Level.INFO, "ChecksumExeCsvFileParser >>isValidFileFormat, file: {0}...", this.filePath);
        try {
            String firstLine = ChecksumExeCsvFileParser.readFirstLine(this.filePath);
            if (StringUtilities.isEmpty(firstLine)) {
                logger.log(Level.INFO, "ChecksumExeCsvFileParser >>isValidFileFormat, first line is empty!");
                return false;
            }
            CSVParser csvParser = new CSVParser(',', '\"', CSV_DELIM_GRAVE);
            String[] values = csvParser.parseLine(firstLine);
            if (values != null && values.length >= 2) {
                String sha256Column = values[INDEX_SHA256];
                String md5Column = values[INDEX_MD5];
                if (FingerprintListHashType.HASH_TYPE_MD5.isValidHashValue(md5Column) && FingerprintListHashType.HASH_TYPE_SHA256.isValidHashValue(sha256Column)) {
                    logger.log(Level.INFO, "ChecksumExeCsvFileParser >>isValidFileFormat, is a valid CSV file!");
                    return true;
                }
            }
        }
        catch (IOException exc) {
            logger.log(Level.SEVERE, "ChecksumExeCsvFileParser >>isValidFileFormat, result: {0}", exc.getMessage());
        }
        logger.log(Level.INFO, "ChecksumExeCsvFileParser >>isValidFileFormat, is not a valid ChecksumExe CSV file!");
        return false;
    }

    @Override
    protected void parseHashValuesFromLine(FingerprintListHashValues hashValues, String line) throws IOException, FingerprintListException {
        CSVParser csvParser = new CSVParser(',', '\"', CSV_DELIM_GRAVE);
        String[] values = csvParser.parseLine(line);
        if (values != null && values.length >= 2) {
            String sha256Value = values[INDEX_SHA256];
            String md5Value = values[INDEX_MD5];
            hashValues.addHashValue(new FingerprintListHashValue(md5Value, sha256Value));
        }
    }
}

