/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.systemlockdown;

import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.systemlockdown.FingerprintListClientBinaryFile;
import com.sygate.scm.util.systemlockdown.FingerprintListHashType;
import com.sygate.scm.util.systemlockdown.FingerprintListHashValue;
import com.sygate.scm.util.systemlockdown.FingerprintListHashValues;
import com.sygate.scm.util.systemlockdown.exception.FingerprintListException;
import com.sygate.scm.util.systemlockdown.exception.FingerprintListInvalidBinaryFileException;
import com.sygate.scm.util.systemlockdown.exception.FingerprintListInvalidFileException;
import com.sygate.scm.util.systemlockdown.fileparser.ChecksumExeCsvFileParser;
import com.sygate.scm.util.systemlockdown.fileparser.FingerprintListFileParser;
import com.sygate.scm.util.systemlockdown.fileparser.PlainTextCsvFileParser;
import com.sygate.scm.util.systemlockdown.fileparser.PlainTextMd5FileParser;
import com.sygate.scm.util.systemlockdown.fileparser.PlainTextSha256FileParser;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class FingerprintListHelper {
    public static final String NEW_LINE = "\r\n";
    private static final Logger logger = Logger.getLogger(FingerprintListHelper.class.getName());
    private static final String WHITELIST_FILE_NAME = "protection%s.dat";

    private FingerprintListHelper() {
    }

    public static FingerprintListHashValues readFingerprintListFromFile(Path filePath) throws FingerprintListException {
        return FingerprintListHelper.getFileParser(filePath).readFingerprintListFromFile();
    }

    public static FingerprintListHashValues readFingerprintListFromStream(byte[] data) throws FingerprintListException {
        FingerprintListHashValues fingerprintListHashValues;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        try {
            fingerprintListHashValues = PlainTextCsvFileParser.readHashValuesFromStream(inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exc) {
                throw new FingerprintListException(exc.getMessage(), exc);
            }
        }
        ((InputStream)inputStream).close();
        return fingerprintListHashValues;
    }

    public static FingerprintListHashValues readFingerprintListFromStream(InputStream inputStream) throws FingerprintListException {
        return PlainTextCsvFileParser.readHashValuesFromStream(inputStream);
    }

    public static void mergeFingerprintList(FingerprintListHashValues targetHashValues, List<FingerprintListHashValues> listHashValues) throws FingerprintListException {
        AtomicReference exception = new AtomicReference();
        listHashValues.forEach(hashValues -> hashValues.getAllHashValues().forEach(hashValue -> {
            try {
                targetHashValues.addHashValue((FingerprintListHashValue)hashValue);
            }
            catch (FingerprintListException exc) {
                exception.set(exc);
            }
        }));
        if (exception.get() != null) {
            throw (FingerprintListException)exception.get();
        }
    }

    public static void mergeFingerprintList(FingerprintListHashValues targetHashValues, Path fileNameToMerge) throws FingerprintListException {
        ArrayList<FingerprintListHashValues> listHashValues = new ArrayList<FingerprintListHashValues>();
        listHashValues.add(FingerprintListHelper.readFingerprintListFromFile(fileNameToMerge));
        FingerprintListHelper.mergeFingerprintList(targetHashValues, listHashValues);
    }

    public static void removeFingerprintList(FingerprintListHashValues targetHashValues, List<FingerprintListHashValues> hashValuesToRemove) {
        hashValuesToRemove.forEach(hashValues -> hashValues.getAllHashValues().forEach(targetHashValues::removeHashValue));
    }

    public static void removeFingerprintList(FingerprintListHashValues targetHashValues, Path fileNameRemove) throws FingerprintListException {
        ArrayList<FingerprintListHashValues> listHashValues = new ArrayList<FingerprintListHashValues>();
        listHashValues.add(FingerprintListHelper.readFingerprintListFromFile(fileNameRemove));
        FingerprintListHelper.removeFingerprintList(targetHashValues, listHashValues);
    }

    public static SortedSet<String> readFingerprintListFromClientBinaryFile(Path filePath, FingerprintListHashType hashType) throws FingerprintListException {
        try {
            return FingerprintListHelper.readFingerprintListFromClientBinaryFile(Files.readAllBytes(filePath), hashType);
        }
        catch (IOException exc) {
            throw new FingerprintListInvalidBinaryFileException(exc.getMessage(), exc);
        }
    }

    public static SortedSet<String> readFingerprintListFromClientBinaryFile(byte[] data, FingerprintListHashType hashType) throws FingerprintListException {
        TreeSet<String> hashValueList = new TreeSet<String>();
        int len = data.length;
        int checksumLength = hashType.getLength() / 2;
        if (len % checksumLength != 0) {
            logger.log(Level.SEVERE, "SystemLockdownHelper>> readFingerprintListFromClientBinaryFile: Error-> data format error!");
            throw new FingerprintListInvalidBinaryFileException();
        }
        byte[] checksum = new byte[checksumLength];
        for (int i = 0; i < len; i += checksumLength) {
            String str;
            System.arraycopy(data, i, checksum, 0, checksumLength);
            if (i == 0) {
                str = Utility.toHexString(checksum);
                logger.log(Level.INFO, "SystemLockdownHelper>> readFingerprintListFromClientBinaryFile: ignore the first line in binary: {0}", str);
                continue;
            }
            str = Utility.toHexString(checksum);
            str = str.toUpperCase();
            hashValueList.add(str);
        }
        logger.log(Level.INFO, "SystemLockdownHelper>> readFingerprintListFromClientBinaryFile: list size=: {0}", hashValueList.size());
        return hashValueList;
    }

    public static List<FingerprintListClientBinaryFile> writeFingerprintListToClientBinaryFile(String fingerprintListName, Path parentFolder, FingerprintListHashValues hashValues) throws FingerprintListException {
        logger.log(Level.INFO, "FingerprintListHelper >> writeFingerprintListToClientBinaryFile, fingerprintListName: {0}, parentFolder: {1}...", new Object[]{fingerprintListName, parentFolder});
        AtomicReference exception = new AtomicReference();
        HashMap fileNameHashValuesMap = new HashMap();
        for (FingerprintListHashType hashType : FingerprintListHashType.getAllHashTypes()) {
            fileNameHashValuesMap.put(new FingerprintListClientBinaryFile(fingerprintListName, true, hashType), new TreeSet());
            fileNameHashValuesMap.put(new FingerprintListClientBinaryFile(fingerprintListName, false, hashType), new TreeSet());
        }
        hashValues.getAllHashValues().forEach(hashValue -> FingerprintListHashType.getAllHashTypes().stream().filter(hashType -> !StringUtilities.isEmpty(hashValue.getHashValue((FingerprintListHashType)((Object)((Object)hashType))))).forEach(hashType -> ((SortedSet)fileNameHashValuesMap.get(new FingerprintListClientBinaryFile(fingerprintListName, hashValue.isMapped(), (FingerprintListHashType)((Object)((Object)hashType))))).add(hashValue.getHashValue((FingerprintListHashType)((Object)((Object)hashType))))));
        fileNameHashValuesMap.keySet().forEach(file -> {
            try {
                file.setClientBinaryFile(new File(parentFolder.toString(), String.format(WHITELIST_FILE_NAME, GUIDGenerator.getInstance().getGUIDString())));
                file.setHashCount(((SortedSet)fileNameHashValuesMap.get(file)).size());
                logger.log(Level.INFO, "FingerprintListHelper >> writeFingerprintListToClientBinaryFile, File Info: {0}", file);
                FingerprintListHelper.writeFingerprintListToClientBinaryFile(file.getClientBinaryFile().toPath(), (SortedSet)fileNameHashValuesMap.get(file));
            }
            catch (IOException e) {
                exception.set(new FingerprintListException(e.getMessage()));
            }
        });
        if (exception.get() != null) {
            throw (FingerprintListException)exception.get();
        }
        List<FingerprintListClientBinaryFile> allBinaryFiles = fileNameHashValuesMap.keySet().stream().filter(file -> Files.exists(file.getClientBinaryFile().toPath(), new LinkOption[0])).collect(Collectors.toList());
        FingerprintListHelper.updateFingerprintListClientBinaryFileChecksum(allBinaryFiles);
        return allBinaryFiles;
    }

    public static void updateFingerprintListClientBinaryFileChecksum(List<FingerprintListClientBinaryFile> files) throws FingerprintListException {
        AtomicReference exception = new AtomicReference();
        files.forEach(file -> {
            String folder = file.getClientBinaryFile().getParent();
            String checksum = null;
            try {
                checksum = Utility.getCheckSum(file.getClientBinaryFile());
            }
            catch (IOException | NoSuchAlgorithmException | NoSuchProviderException exc) {
                exception.set(new FingerprintListException(exc.getMessage(), exc));
            }
            String newFileName = String.format(WHITELIST_FILE_NAME, checksum);
            File newFile = new File(folder, newFileName);
            boolean ret = Utility.delete(newFile);
            logger.log(Level.INFO, "FingerprintListHelper >> updateFingerprintListClientBinaryFileChecksum, Existing File {0} was deleted: {1}", new Object[]{newFile.getAbsolutePath(), ret});
            ret = file.getClientBinaryFile().renameTo(newFile);
            file.setClientBinaryFile(newFile);
            logger.log(Level.INFO, "FingerprintListHelper >> updateFingerprintListClientBinaryFileChecksum, File Info: {0}, Renamed: {1}", new Object[]{file, ret});
        });
        if (exception.get() != null) {
            throw (FingerprintListException)exception.get();
        }
    }

    public static void writeFingerprintListToDbBinaryFile(FingerprintListHashValues hashValues, Path filePath) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(filePath, new OpenOption[0]));){
            String header = hashValues.getDbCsvHeader() + NEW_LINE;
            out.write(header.getBytes(StandardCharsets.UTF_8));
            for (FingerprintListHashValue hashValue : hashValues.getAllHashValues()) {
                out.write((hashValue.toString() + NEW_LINE).getBytes(StandardCharsets.UTF_8));
            }
            out.flush();
        }
    }

    public static void writeFingerprintListToClientBinaryFile(Path filePath, SortedSet<String> hashValues) throws IOException {
        int count = hashValues.size();
        if (hashValues.isEmpty()) {
            logger.log(Level.INFO, "SystemLockdownHelper>> writeFingerprintListToClientBinaryFile: no hash values!");
            return;
        }
        int hashLength = hashValues.first().length();
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(filePath, new OpenOption[0]));){
            Object countStr = Integer.toHexString(count);
            logger.log(Level.INFO, "SystemLockdownHelper>> writeFingerprintListToClientBinaryFile: (before) count_str={0}", countStr);
            if (((String)countStr).length() % 2 != 0) {
                countStr = "0" + (String)countStr;
            }
            while (((String)countStr).length() < hashLength) {
                countStr = "0" + (String)countStr;
            }
            logger.log(Level.INFO, "SystemLockdownHelper>> writeFingerprintListToClientBinaryFile: (after) count_str={0}", countStr);
            byte[] countData = Utility.toByteArray((String)countStr);
            int len = countData.length / 2;
            byte temp = 0;
            for (int ii = 0; ii < len; ++ii) {
                temp = countData[ii];
                countData[ii] = countData[countData.length - ii - 1];
                countData[countData.length - ii - 1] = temp;
            }
            StringBuilder testBuilder = new StringBuilder();
            for (byte element : countData) {
                testBuilder.append(',');
                testBuilder.append(Integer.toHexString(element));
            }
            logger.log(Level.INFO, "SystemLockdownHelper>> writeFingerprintListToClientBinaryFile: (after) count_data (0->last)={0}", testBuilder);
            out.write(countData, 0, countData.length);
            int hashCount = 0;
            Iterator it = hashValues.iterator();
            while (it.hasNext()) {
                ++hashCount;
                String str = (String)it.next();
                byte[] data = Utility.toByteArray(str);
                out.write(data, 0, data.length);
            }
            out.flush();
            logger.log(Level.INFO, "SystemLockdownHelper>> writeFingerprintListToClientBinaryFile: Hash count {0} were written to file {1}!", new Object[]{hashCount, filePath});
        }
    }

    private static FingerprintListFileParser getFileParser(Path filePath) throws FingerprintListInvalidFileException {
        if (new ChecksumExeCsvFileParser(filePath).isValidFileFormat()) {
            return new ChecksumExeCsvFileParser(filePath);
        }
        if (new PlainTextCsvFileParser(filePath).isValidFileFormat()) {
            return new PlainTextCsvFileParser(filePath);
        }
        if (new PlainTextSha256FileParser(filePath).isValidFileFormat()) {
            return new PlainTextSha256FileParser(filePath);
        }
        if (new PlainTextMd5FileParser(filePath).isValidFileFormat()) {
            return new PlainTextMd5FileParser(filePath);
        }
        throw new FingerprintListInvalidFileException();
    }
}

