/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.systemlockdown;

import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.systemlockdown.FingerprintListHashType;
import com.sygate.scm.util.systemlockdown.FingerprintListHashValue;
import com.sygate.scm.util.systemlockdown.exception.FingerprintListException;
import com.sygate.scm.util.systemlockdown.exception.FingerprintListHashConflictException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class FingerprintListHashValues {
    private static final Logger logger = Logger.getLogger(FingerprintListHashValues.class.getName());
    private final EnumMap<FingerprintListHashType, Map<String, FingerprintListHashValue>> hashTypeValues = new EnumMap(FingerprintListHashType.class);
    private SortedSet<FingerprintListHashValue> allHashValuesCache = new TreeSet<FingerprintListHashValue>();
    private int mappedCount = 0;

    public FingerprintListHashValues() {
        FingerprintListHashType.getAllHashTypes().forEach(hashType -> this.hashTypeValues.put((FingerprintListHashType)((Object)hashType), new HashMap()));
    }

    public boolean isEmpty() {
        return !this.hashTypeValues.keySet().stream().anyMatch(hashType -> this.hashTypeValues.get(hashType).size() > 0);
    }

    public SortedSet<FingerprintListHashValue> getAllHashValues() {
        if (this.allHashValuesCache.isEmpty()) {
            this.hashTypeValues.values().forEach(hashValues -> this.allHashValuesCache.addAll(hashValues.values()));
        }
        return this.allHashValuesCache;
    }

    public SortedSet<FingerprintListHashValue> getHashValues(FingerprintListHashType hashType) {
        return new TreeSet<FingerprintListHashValue>(this.hashTypeValues.get((Object)hashType).values());
    }

    public SortedSet<FingerprintListHashValue> getMappedHashValues() {
        return this.getAllHashValues().stream().filter(FingerprintListHashValue::isMapped).collect(Collectors.toCollection(TreeSet::new));
    }

    public void addHashValue(FingerprintListHashValue hashValue) throws FingerprintListException {
        AtomicReference exception = new AtomicReference();
        boolean oriMapped = this.isHashValueMapped(hashValue);
        hashValue.getHashTypeValues().forEach((hashType, value) -> {
            if (!StringUtilities.isEmpty(value)) {
                if (this.hashTypeValues.get(hashType).get(value) == null) {
                    this.hashTypeValues.get(hashType).put((String)value, hashValue);
                } else {
                    try {
                        this.updateHashValue(this.hashTypeValues.get(hashType).get(value), hashValue);
                    }
                    catch (FingerprintListException exc) {
                        exception.set(exc);
                    }
                }
            }
        });
        if (exception.get() != null) {
            throw (FingerprintListException)exception.get();
        }
        if (!oriMapped && this.isHashValueMapped(hashValue)) {
            ++this.mappedCount;
        }
        this.allHashValuesCache.clear();
    }

    public void removeHashValue(FingerprintListHashValue hashValue) {
        hashValue.getHashTypeValues().forEach((hashType, value) -> {
            if (value != null && this.hashTypeValues.get(hashType).get(value) != null) {
                if (this.hashTypeValues.get(hashType).get(value).isMapped()) {
                    --this.mappedCount;
                }
                this.hashTypeValues.get(hashType).get(value).getHashTypeValues().forEach((type, hash) -> this.hashTypeValues.get(type).remove(hash));
            }
        });
        this.allHashValuesCache.clear();
    }

    public int getHashCount() {
        AtomicInteger totalCount = new AtomicInteger(this.mappedCount);
        this.hashTypeValues.keySet().forEach(hashType -> totalCount.addAndGet(this.hashTypeValues.get(hashType).size() - this.mappedCount));
        return totalCount.get();
    }

    public int getLegacyHashCount() {
        AtomicLong newestHashCount = new AtomicLong(0L);
        FingerprintListHashType.getAllHashTypes().stream().filter(type -> type.isNewestHashType()).forEach(type -> newestHashCount.set(this.getHashCount((FingerprintListHashType)((Object)type))));
        return this.getHashCount() - newestHashCount.intValue();
    }

    public long getHashCount(FingerprintListHashType hashType) {
        return this.hashTypeValues.get((Object)hashType).size();
    }

    public int getMappedHashCount() {
        return this.mappedCount;
    }

    public String getDbCsvHeader() {
        StringBuilder str = new StringBuilder();
        this.hashTypeValues.keySet().forEach(hashType -> str.append(hashType.getHashTypeName()).append(','));
        return str.substring(0, str.lastIndexOf(","));
    }

    private boolean isHashValueMapped(FingerprintListHashValue hashValue) {
        return hashValue.getHashTypeValues().keySet().stream().filter(hashType -> !StringUtilities.isEmpty(hashValue.getHashValue((FingerprintListHashType)((Object)hashType)))).anyMatch(hashType -> {
            FingerprintListHashValue value = this.hashTypeValues.get(hashType).get(hashValue.getHashValue((FingerprintListHashType)((Object)hashType)));
            return value != null && value.isMapped();
        });
    }

    private void updateHashValue(FingerprintListHashValue targetValue, FingerprintListHashValue newValue) throws FingerprintListException {
        AtomicReference exception = new AtomicReference();
        newValue.getHashTypeValues().forEach((hashType, value) -> {
            if (!StringUtilities.isEmpty(value)) {
                if (StringUtilities.isEmpty(targetValue.getHashValue((FingerprintListHashType)((Object)hashType)))) {
                    targetValue.setHashValue((FingerprintListHashType)((Object)hashType), (String)value);
                    this.hashTypeValues.get(hashType).put((String)value, targetValue);
                } else if (!targetValue.getHashValue((FingerprintListHashType)((Object)hashType)).equalsIgnoreCase(newValue.getHashValue((FingerprintListHashType)((Object)hashType)))) {
                    logger.log(Level.SEVERE, "Hash value conflict was detected for hash type: {0}, original hash value: {1}, new hash value: {2}", new String[]{hashType.getHashTypeName(), targetValue.getHashValue((FingerprintListHashType)((Object)hashType)), newValue.getHashValue((FingerprintListHashType)((Object)hashType))});
                    exception.set(new FingerprintListHashConflictException());
                }
            }
        });
        if (exception.get() != null) {
            throw (FingerprintListException)exception.get();
        }
        targetValue.checkHashValues();
    }
}

