/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.systemlockdown;

import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.systemlockdown.FingerprintListHashType;
import com.sygate.scm.util.systemlockdown.exception.FingerprintListInvalidHashException;
import java.util.EnumMap;
import java.util.Map;

public class FingerprintListHashValue
implements Comparable<FingerprintListHashValue> {
    private boolean isMapped = false;
    private final EnumMap<FingerprintListHashType, String> hashTypeValues = new EnumMap(FingerprintListHashType.class);

    public boolean isMapped() {
        return this.isMapped;
    }

    public void setMapped(boolean mapped) {
        this.isMapped = mapped;
    }

    public FingerprintListHashValue(Map<FingerprintListHashType, String> values) throws FingerprintListInvalidHashException {
        FingerprintListHashType.getAllHashTypes().forEach(type -> this.setHashValue((FingerprintListHashType)((Object)type), null));
        values.forEach(this::setHashValue);
        this.checkHashValues();
    }

    public FingerprintListHashValue(String md5Value, String sha256Value) throws FingerprintListInvalidHashException {
        FingerprintListHashType.getAllHashTypes().forEach(type -> this.setHashValue((FingerprintListHashType)((Object)type), null));
        this.hashTypeValues.put(FingerprintListHashType.HASH_TYPE_MD5, md5Value == null ? null : md5Value.toUpperCase());
        this.hashTypeValues.put(FingerprintListHashType.HASH_TYPE_SHA256, sha256Value == null ? null : sha256Value.toUpperCase());
        this.checkHashValues();
    }

    public Map<FingerprintListHashType, String> getHashTypeValues() {
        return this.hashTypeValues;
    }

    public String getHashValue(FingerprintListHashType hashType) {
        return this.hashTypeValues.get((Object)hashType);
    }

    public void setHashValue(FingerprintListHashType hashType, String hashValue) {
        this.hashTypeValues.put(hashType, hashValue);
    }

    public final void checkHashValues() throws FingerprintListInvalidHashException {
        if (this.hashTypeValues.keySet().stream().anyMatch(hashType -> !StringUtilities.isEmpty(this.hashTypeValues.get(hashType)) && !hashType.isValidHashValue(this.hashTypeValues.get(hashType)))) {
            throw new FingerprintListInvalidHashException();
        }
        long hashValueCount = this.hashTypeValues.keySet().stream().filter(hashType -> !StringUtilities.isEmpty(this.hashTypeValues.get(hashType))).count();
        if (hashValueCount <= 0L) {
            throw new FingerprintListInvalidHashException();
        }
        this.setMapped(hashValueCount == (long)FingerprintListHashType.getAllHashTypeCount());
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        this.hashTypeValues.keySet().forEach(hashType -> str.append(this.getHashValue((FingerprintListHashType)((Object)hashType)) == null ? "" : this.getHashValue((FingerprintListHashType)((Object)hashType))).append(','));
        String strFinal = str.toString();
        return strFinal.substring(0, strFinal.lastIndexOf(44));
    }

    @Override
    public int compareTo(FingerprintListHashValue obj) {
        return this.toString().compareTo(obj.toString());
    }

    public boolean equals(Object anObject) {
        if (null == anObject) {
            return false;
        }
        if (this == anObject) {
            return true;
        }
        if (anObject.getClass() == this.getClass()) {
            return anObject.toString().equalsIgnoreCase(this.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

