/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.systemlockdown;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public enum FingerprintListHashType {
    HASH_TYPE_MD5("MD5", 32, false),
    HASH_TYPE_SHA256("SHA256", 64, true);

    private static final int ALL_HASH_TYPE_COUNT = 2;
    private final String hashTypeName;
    private final int length;
    private final boolean isNewestHashType;

    private FingerprintListHashType(String hashTypeName, int length, boolean isNewestHashType) {
        this.hashTypeName = hashTypeName;
        this.length = length;
        this.isNewestHashType = isNewestHashType;
    }

    public String getHashTypeName() {
        return this.hashTypeName;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isNewestHashType() {
        return this.isNewestHashType;
    }

    public static Set<String> getAllHashTypeNames() {
        HashSet<String> setAllHashes = new HashSet<String>();
        setAllHashes.add(HASH_TYPE_MD5.getHashTypeName());
        setAllHashes.add(HASH_TYPE_SHA256.getHashTypeName());
        return setAllHashes;
    }

    public static Set<FingerprintListHashType> getAllHashTypes() {
        return EnumSet.of(HASH_TYPE_MD5, HASH_TYPE_SHA256);
    }

    public static int getAllHashTypeCount() {
        return 2;
    }

    public boolean isValidHashValue(String hashValue) {
        return hashValue != null && hashValue.matches("[a-fA-F0-9]{" + this.length + "}");
    }
}

