/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.systemlockdown;

import com.sygate.scm.common.configobject.schema.ComputerImage;
import com.sygate.scm.util.systemlockdown.FingerprintListClientBinaryFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FingerprintListCompilerCache {
    private static final Logger logger = Logger.getLogger(FingerprintListCompilerCache.class.getName());
    private static FingerprintListCompilerCache instance = new FingerprintListCompilerCache();
    private Map<String, FingerprintListCache> fingerprintListCacheMap = new HashMap<String, FingerprintListCache>();

    private FingerprintListCompilerCache() {
    }

    public static FingerprintListCompilerCache getInstance() {
        return instance;
    }

    public boolean isFingerprintListChanged(ComputerImage image) {
        boolean changed = this.fingerprintListCacheMap.get(image.getName()) == null ? true : this.fingerprintListCacheMap.get(image.getName()).getTimestamp() != image.getT();
        logger.log(Level.INFO, "isFingerprintListChanged >> FingerprintListName: {0}, Result: {1}", new Object[]{image.getName(), changed});
        return changed;
    }

    public void updateFingerprintListCache(ComputerImage image, List<FingerprintListClientBinaryFile> files) {
        this.fingerprintListCacheMap.put(image.getName(), new FingerprintListCache(image.getT(), files));
        logger.log(Level.INFO, "updateFingerprintListCache >> FingerprintList: {0}, TimeStamp: {1}, BinaryFileCount: {2}", new Object[]{image.getName(), image.getT(), files.size()});
        files.forEach(file -> logger.log(Level.INFO, "updateFingerprintListCache >> binary file Info: {0}", file));
    }

    public void clearFingerprintListCache(ComputerImage image) {
        this.fingerprintListCacheMap.remove(image.getName());
        logger.log(Level.INFO, "clearFingerprintListCache >> FingerprintList: {0}", image.getName());
    }

    public List<FingerprintListClientBinaryFile> getClientBinaryFiles(ComputerImage image) {
        ArrayList<FingerprintListClientBinaryFile> files = new ArrayList<FingerprintListClientBinaryFile>();
        if (this.fingerprintListCacheMap.get(image.getName()) != null && this.fingerprintListCacheMap.get(image.getName()).getFiles() != null) {
            files.addAll(this.fingerprintListCacheMap.get(image.getName()).getFiles());
        }
        return files;
    }

    private static class FingerprintListCache {
        List<FingerprintListClientBinaryFile> files;
        long timestamp;

        public FingerprintListCache(long timestamp, List<FingerprintListClientBinaryFile> files) {
            this.timestamp = timestamp;
            this.files = files;
        }

        public List<FingerprintListClientBinaryFile> getFiles() {
            return this.files;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

