/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.query;

import com.sygate.scm.common.configobject.rpc.SqlParameter;
import com.sygate.scm.util.BadFormatException;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.query.DropdownItem;
import java.util.List;

public class AgentOperatingSystemTypeItem
extends DropdownItem {
    private static final String COL = "SEM_COMPUTER.OPERATION_SYSTEM";
    private static final String COL1 = "COMPUTER.OPERATION_SYSTEM";
    private String operation_system_value;

    public static AgentOperatingSystemTypeItem getAgentOperatingSystemTypeItem(String operation_system_value) {
        return new AgentOperatingSystemTypeItem(operation_system_value, operation_system_value);
    }

    public AgentOperatingSystemTypeItem(String name, String operation_system_value) {
        super(name, operation_system_value);
        this.operation_system_value = operation_system_value;
    }

    public String getOsString() {
        return this.operation_system_value;
    }

    public String prepareSqlQueryCriteria(String operator, List<SqlParameter> parameters, int queryType) throws BadFormatException {
        Object value;
        if (operator == null || !operator.equals("=") && !operator.equals("!=") && !operator.equals("LIKE")) {
            throw new BadFormatException("Operating System column does not support the operator:" + operator);
        }
        StringBuffer query = new StringBuffer(64);
        operator = operator.trim();
        SqlParameter para = null;
        Object col = queryType == 800 || queryType == 900 || queryType == 1000 ? COL : COL1;
        if (operator.equals("LIKE")) {
            value = "%" + this.operation_system_value + "%";
        } else {
            value = this.operation_system_value;
            col = "rtrim(ltrim(" + (String)col + "))";
        }
        para = Utility.createSqlParameter(COL, 24, operator, (String)value);
        query.append((String)col).append(" ").append(operator).append(" ?");
        parameters.add(para);
        return query.toString();
    }

    public String getQueryName() {
        return COL;
    }
}

