/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.platform;

import com.sygate.scm.util.RunCommandHandler;
import com.sygate.scm.util.StringUtilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

class WindowsRegistry {
    private static final Logger logger = Logger.getLogger(WindowsRegistry.class.getName());

    private WindowsRegistry() {
    }

    static WindowsRegistry getInstance() {
        return new WindowsRegistry();
    }

    public String getContentForSZ(String keyName, String valueName) throws IOException {
        return this.getContent(keyName, valueName, ValueType.REG_SZ);
    }

    public int getContentForDWORD(String keyName, String valueName) throws Exception {
        String result = this.getContent(keyName, valueName, ValueType.REG_DWORD);
        if (StringUtilities.isEmpty(result)) {
            throw new Exception("Empty content or no key exists for : " + keyName);
        }
        return WindowsRegistry.parseHexString(result);
    }

    private static int parseHexString(String hexString) {
        String strValue = hexString;
        if (strValue.startsWith("0x") || strValue.startsWith("0X")) {
            strValue = strValue.substring(2);
        }
        return Integer.parseInt(strValue, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContent(String keyName, String valueName, ValueType type) throws IOException {
        ArrayList<Object> command = new ArrayList<Object>();
        command.add("reg");
        command.add("query");
        command.add("\"" + keyName + "\"");
        command.add("/v");
        command.add(valueName);
        String[] cmd = command.toArray(new String[0]);
        String result = "";
        Process p = null;
        try {
            logger.log(Level.FINEST, "Query Registry command: " + command);
            p = RunCommandHandler.getInstance().getProcess(cmd);
            try (BufferedReader output = new BufferedReader(new InputStreamReader(p.getInputStream(), Charset.defaultCharset()));){
                String line;
                while ((line = output.readLine()) != null) {
                    logger.log(Level.FINEST, "Query Registry output: " + line);
                    if (!line.contains(type.getValue())) continue;
                    result = StringUtilities.substringAfter(line, type.getValue());
                }
            }
            String string = result.trim();
            RunCommandHandler.getInstance().closeProcess(p);
            return string;
        }
        catch (Throwable throwable) {
            RunCommandHandler.getInstance().closeProcess(p);
            throw throwable;
        }
    }

    public static enum ValueType {
        REG_SZ("REG_SZ"),
        REG_DWORD("REG_DWORD");

        private final String value;

        private ValueType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

