/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.mail;

import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.SimpleProgressDlg;
import com.sygate.scm.common.valueobject.EmailServerSettingsVO;
import com.sygate.scm.common.valueobject.LoginUserVO;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.ServerVersion;
import com.sygate.scm.util.SwingWorker;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.mail.Email;
import com.sygate.scm.util.mail.EmailException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class TestEmailSender {
    private final Email sender;
    private final String threadName;
    private final JFrame parentFrame;
    private static final MessageResourcesFile MSG_RES = new MessageResourcesFile("com.sygate.scm.util.util");
    private boolean isEmailOk = false;
    private boolean displayStatusMessages = true;

    public TestEmailSender(EmailServerSettingsVO settings, LoginUserVO admin, JFrame parentFrame, String threadName, String serverName, String serverIP) {
        settings.setOptionalServerDomain(admin.getEmailServerDomain());
        ArrayList<String> to = new ArrayList<String>();
        to.add(admin.getEmailAddress());
        String url = TestEmailSender.getSupportUrl();
        Object[] obj = new Object[]{ServerVersion.CURRENT_CED_VERSION, Utility.getLanguage()};
        String localizedSepEEtourUrl = MessageFormat.format(MSG_RES.getString("TestEmailSender.testmailContent.productTourUrl"), obj);
        System.out.println("Localized SEP Tour EE url = " + localizedSepEEtourUrl);
        String content = MessageFormat.format(MSG_RES.getString("TestEmailSender.testmailContent"), serverName, serverIP, localizedSepEEtourUrl, url);
        this.sender = Email.createMultiPartEmail(settings, to, null, null, null, MSG_RES.getString("TestEmailSender.testmailSubject"), content, "text/html");
        this.parentFrame = parentFrame;
        this.threadName = threadName;
    }

    static String getSupportUrl(Locale locale) {
        StringBuffer url = new StringBuffer();
        url.append(MSG_RES.getString("TestEmailSender.testmailContent.mySymantecUrlWebsite"));
        String webpage = MSG_RES.getString("TestEmailSender.testmailContent.mySymantecUrlWebpage");
        url.append("/");
        url.append(locale.getLanguage());
        url.append("_");
        url.append(locale.getCountry());
        url.append("/");
        url.append(webpage);
        return url.toString();
    }

    public static String getSupportUrl() {
        return TestEmailSender.getSupportUrl(Locale.getDefault());
    }

    public void setDisplayStatusMessages(boolean displayStatus) {
        this.displayStatusMessages = displayStatus;
    }

    public boolean sendTestEmail() {
        this.isEmailOk = false;
        SwingWorker worker = new SwingWorker(this.threadName){
            final SimpleProgressDlg dlg;
            {
                this.dlg = new SimpleProgressDlg(TestEmailSender.this.parentFrame, null, MSG_RES.getString("TestEmailSender.SendingEmail"), true, 1, false);
            }

            @Override
            public void start() {
                super.start();
                this.dlg.start();
            }

            @Override
            public Object construct() {
                System.out.println("Sending test email ...");
                try {
                    TestEmailSender.this.sender.send();
                    TestEmailSender.this.isEmailOk = true;
                }
                catch (EmailException ex) {
                    TestEmailSender.this.isEmailOk = false;
                }
                catch (Throwable ex) {
                    TestEmailSender.this.isEmailOk = false;
                    LoggerUtilities.logException(ex);
                }
                return null;
            }

            @Override
            public void finished() {
                this.dlg.stop();
            }
        };
        worker.start();
        if (this.isEmailOk) {
            System.out.println("Test email send successfully to " + this.sender.getAllReceivers());
            if (this.displayStatusMessages) {
                JOptionPane.showMessageDialog(this.parentFrame, MSG_RES.getString("TestEmailSender.testEmailPassed"), MSG_RES.getString("TestEmailSender.title.emailPassed"), 1);
            }
        } else {
            System.out.println("Failed to send test email with the given mail server configuration and system administrator email address");
            if (this.displayStatusMessages) {
                String sMessageEmailFailed = MSG_RES.getString("TestEmailSender.testEmailFailed");
                sMessageEmailFailed = MessageFormat.format(sMessageEmailFailed, this.sender.getAllReceivers());
                JOptionPane.showMessageDialog(this.parentFrame, sMessageEmailFailed, MSG_RES.getString("TestEmailSender.title.Warning"), 2);
            }
        }
        return this.isEmailOk;
    }
}

