/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.mail;

import com.sygate.scm.common.valueobject.EmailServerSettingsVO;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.mail.Email;
import com.sygate.scm.util.mail.EmailException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class MultiPartEmail
extends Email {
    protected MimeMultipart container;
    protected MimeBodyPart primaryBodyPart;

    protected MultiPartEmail(EmailServerSettingsVO serverSettings, List<String> toList, List<String> ccList, List<String> bccList, List<String> replyList, String subject, String content, String contentType) {
        super(serverSettings, toList, ccList, bccList, replyList, subject, content, contentType, "UTF-8");
        this.init();
    }

    protected MultiPartEmail(EmailServerSettingsVO serverSettings, MimeMessage message, String charset) {
        super(serverSettings, message, charset);
    }

    public Email addPart(String partContent, String partContentType) throws EmailException {
        MimeBodyPart bodyPart = new MimeBodyPart();
        try {
            bodyPart.setContent((Object)partContent, partContentType);
            this.getContainer().addBodyPart((BodyPart)bodyPart);
        }
        catch (MessagingException me) {
            throw new EmailException(me);
        }
        return this;
    }

    public Email addPart(MimeMultipart multipart) throws EmailException {
        try {
            return this.addPart(multipart, this.getContainer().getCount());
        }
        catch (MessagingException me) {
            throw new EmailException(me);
        }
    }

    public Email addPart(MimeMultipart multipart, int index) throws EmailException {
        MimeBodyPart bodyPart = new MimeBodyPart();
        try {
            bodyPart.setContent((Multipart)multipart);
            this.getContainer().addBodyPart((BodyPart)bodyPart, index);
        }
        catch (MessagingException me) {
            throw new EmailException(me);
        }
        return this;
    }

    protected void init() {
        this.container = new MimeMultipart();
        this.setContent(this.container);
    }

    public MultiPartEmail attach(URL url, String name, String description) throws EmailException {
        return this.attach(url, name, description, AttachmentType.ATTACHMENT);
    }

    public MultiPartEmail attach(URL url, String name, String description, AttachmentType attachmentType) throws EmailException {
        if (url == null) {
            throw new EmailException("Invalid URL set: null");
        }
        InputStream is = null;
        try {
            is = url.openStream();
        }
        catch (IOException e) {
            throw new EmailException("Invalid URL set:" + url, e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new EmailException("Invalid URL set:" + url, e);
                }
            }
        }
        return this.attach((DataSource)new URLDataSource(url), name, description, attachmentType);
    }

    public MultiPartEmail attach(DataSource ds, String name, String description) throws EmailException {
        return this.attach(ds, name, description, AttachmentType.ATTACHMENT);
    }

    public MultiPartEmail attach(DataSource ds, String name, String description, AttachmentType attachmentType) throws EmailException {
        try {
            if (ds == null || ds.getInputStream() == null) {
                throw new EmailException("Invalid Datasource");
            }
        }
        catch (IOException e) {
            throw new EmailException("Invalid Datasource", e);
        }
        MimeBodyPart bodyPart = new MimeBodyPart();
        try {
            bodyPart.setDisposition(attachmentType.getValue());
            bodyPart.setDescription(description);
            bodyPart.setDataHandler(new DataHandler(ds));
            String attachmentName = ds.getName();
            if (attachmentName == null || !attachmentName.endsWith(".mht")) {
                bodyPart.setHeader("Content-ID", ds.getName());
            }
            String fileName = StringUtilities.isEmpty(name) ? ds.getName() : name;
            fileName = MimeUtility.encodeText((String)fileName, (String)"UTF-8", (String)"B");
            bodyPart.setFileName(fileName);
            this.getContainer().addBodyPart((BodyPart)bodyPart);
        }
        catch (MessagingException me) {
            throw new EmailException(me);
        }
        catch (UnsupportedEncodingException e) {
            throw new EmailException(e);
        }
        return this;
    }

    protected MimeBodyPart getPrimaryBodyPart() throws MessagingException {
        if (this.primaryBodyPart == null) {
            this.primaryBodyPart = new MimeBodyPart();
            this.getContainer().addBodyPart((BodyPart)this.primaryBodyPart, 0);
        }
        return this.primaryBodyPart;
    }

    protected MimeMultipart getContainer() {
        return this.container;
    }

    protected void setContent(MimeMultipart mimeMultipart) {
        this.container = mimeMultipart;
    }

    @Override
    protected void setContent() throws MessagingException {
        MimeBodyPart primary = this.getPrimaryBodyPart();
        if (StringUtilities.isEmpty(this.contentType)) {
            primary.setText(this.getContentString(), this.getCharset());
            this.message.setContent((Multipart)this.container);
        } else {
            primary.setContent((Object)this.getContentString(), this.getContentTypeString());
            this.message.setContent((Object)this.container, this.getContentTypeString());
        }
    }

    public void setSubType(String subType) throws EmailException {
        try {
            this.getContainer().setSubType(subType);
        }
        catch (MessagingException me) {
            throw new EmailException(me);
        }
    }

    public static enum AttachmentType {
        ATTACHMENT("attachment"),
        INLINE("inline");

        private String value;

        private AttachmentType(String value) {
            this.value = value;
        }

        protected String getValue() {
            return this.value;
        }
    }
}

