/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.mail;

import com.sygate.scm.util.StringUtilities;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.List;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

class EmailFromAddress
implements Serializable {
    private static final long serialVersionUID = -3455129872016796547L;
    public static final String DEFAULT_FROM_USER = "SEPM_Server";
    public static final String AT = "@";
    public static final String DEFAULT_SERVER_DOMAIN = "localhost.com";
    public static final String DEFAULT_FROM_ADDRESS = "SEPM_Server@localhost.com";
    private static final String EMPTY_STRING = "";
    private String specifiedAddress;
    private List<String> toList;

    EmailFromAddress(String specifiedAddress, List<String> toList) {
        this.specifiedAddress = specifiedAddress;
        this.toList = toList;
    }

    void setSpecifiedAddress(String specifiedAddress) {
        this.specifiedAddress = specifiedAddress;
    }

    String getAddressString() {
        return this.getAddressString(null);
    }

    String getAddressString(List<String> suggestedEmailAddresses) {
        InternetAddress address = this.getAddress(suggestedEmailAddresses);
        return address == null ? DEFAULT_FROM_ADDRESS : address.toString();
    }

    InternetAddress getAddress() {
        return this.getAddress(null);
    }

    InternetAddress getAddress(List<String> suggestedEmailAddresses) {
        InternetAddress from = null;
        if (!StringUtilities.isEmpty(this.specifiedAddress) && this.specifiedAddress.indexOf(AT) > -1) {
            try {
                from = new InternetAddress(this.specifiedAddress);
            }
            catch (AddressException addressException) {
                // empty catch block
            }
        }
        if (from == null) {
            String domainName = null;
            domainName = this.getSuggestedAddressDomain(this.toList);
            if (domainName == null) {
                domainName = this.getSuggestedAddressDomain(suggestedEmailAddresses);
            }
            if (domainName == null) {
                domainName = EmailFromAddress.getLocalhostDomain();
            }
            try {
                from = new InternetAddress("SEPM_Server@" + domainName);
            }
            catch (AddressException addressException) {
                // empty catch block
            }
            if (from == null) {
                try {
                    from = new InternetAddress(DEFAULT_FROM_ADDRESS);
                }
                catch (AddressException addressException) {
                    // empty catch block
                }
            }
        }
        return from;
    }

    private String getSuggestedAddressDomain(List<String> suggestedEmailAddresses) {
        if (suggestedEmailAddresses != null) {
            for (String address : suggestedEmailAddresses) {
                String domainName = EmailFromAddress.extractDomainName(address);
                if (StringUtilities.isEmpty(domainName)) continue;
                return domainName;
            }
        }
        return null;
    }

    static String extractDomainName(String address) {
        int startIndex;
        if (!StringUtilities.isEmpty(address) && (startIndex = address.indexOf(AT) + 1) > 0) {
            return address.substring(startIndex);
        }
        return EMPTY_STRING;
    }

    static String getLocalhostDomain() {
        Object domainName = null;
        try {
            domainName = InetAddress.getLocalHost().getHostName() + ".com";
        }
        catch (Throwable t) {
            domainName = DEFAULT_SERVER_DOMAIN;
        }
        return domainName;
    }
}

