/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.mail;

import com.sygate.scm.common.valueobject.EmailServerSettingsVO;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.mail.EmailException;
import com.sygate.scm.util.mail.EmailFromAddress;
import com.sygate.scm.util.mail.EmailSentResult;
import com.sygate.scm.util.mail.MXRecordLookup;
import com.sygate.scm.util.mail.MultiPartEmail;
import com.sygate.scm.util.mail.SMTPAuthenticator;
import com.sygate.scm.util.mail.SimpleEmail;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public abstract class Email {
    public static final String SENDER_EMAIL = "sender.email";
    public static final String SENDER_NAME = "sender.name";
    public static final String RECEIVER_EMAIL = "receiver.email";
    public static final String RECEIVER_NAME = "receiver.name";
    public static final String EMAIL_SUBJECT = "email.subject";
    public static final String EMAIL_BODY = "email.body";
    public static final String CONTENT_TYPE = "content.type";
    public static final String MAIL_HOST = "mail.smtp.host";
    public static final String MAIL_PORT = "mail.smtp.port";
    public static final String MAIL_FROM = "mail.from";
    public static final String MAIL_SMTP_FROM = "mail.smtp.from";
    public static final String MAIL_SMTP_AUTH = "mail.smtp.auth";
    public static final String MAIL_SMTP_USER = "mail.smtp.user";
    public static final String MAIL_SMTP_PASSWORD = "mail.smtp.password";
    public static final String MAIL_TRANSPORT_PROTOCOL = "mail.transport.protocol";
    public static final String MAIL_SMTP_CONNECTIONTIMEOUT = "mail.smtp.connectiontimeout";
    public static final String MAIL_SMTP_TIMEOUT = "mail.smtp.timeout";
    public static final String MAIL_SMTP_SENDPARTIAL = "mail.smtp.sendpartial";
    public static final String SMTP = "smtp";
    public static final String EMAIL_SEPARATOR_0 = ",";
    public static final String EMAIL_SEPARATOR_1 = ";";
    public static final int DEFAULT_TIME_OUT = 60000;
    public static final String MAIL_SMTP_LOCALHOST = "mail.smtp.localhost";
    public static final String MAIL_SMTP_SSL_ENABLE = "mail.smtp.ssl.enable";
    public static final String MAIL_SMTP_STARTTLS_ENABLE = "mail.smtp.starttls.enable";
    public static final String MAIL_SMTP_STARTTLS_REQUIRED = "mail.smtp.starttls.required";
    public static final String MAIL_SMTP_SSL_CHECK_SERVER_IDENTITY = "mail.smtp.ssl.checkserveridentity";
    public static final String MAIL_SMTP_SSL_TRUST = "mail.smtp.ssl.trust";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_HTML = "text/html";
    public static final String UTF8 = "UTF-8";
    private static final String EMPTY_STRING = "";
    protected EmailServerSettingsVO serverSettings;
    protected EmailFromAddress fromAddress;
    protected List<String> toList = new ArrayList<String>();
    protected List<String> ccList = new ArrayList<String>();
    protected List<String> bccList = new ArrayList<String>();
    protected List<String> replyList = new ArrayList<String>();
    protected MimeMessage message;
    protected String subject;
    protected Object content;
    protected String contentType;
    protected String charset;
    protected Authenticator authenticator;
    protected EmailSentResult sentResult = new EmailSentResult();
    protected boolean debug = false;
    protected static final Logger logger = Logger.getLogger(Email.class.getName());

    protected Email(EmailServerSettingsVO serverSettings, List<String> toList, List<String> ccList, List<String> bccList, List<String> replyList, String subject, String content, String contentType, String charset) {
        this.serverSettings = new EmailServerSettingsVO(serverSettings);
        this.fromAddress = new EmailFromAddress(this.serverSettings.getEmailSender(), toList);
        this.init(this.toList, toList);
        this.init(this.ccList, ccList);
        this.init(this.bccList, bccList);
        this.init(this.replyList, replyList);
        this.subject = subject;
        this.content = content;
        this.contentType = contentType;
        this.charset = charset;
    }

    protected Email(EmailServerSettingsVO serverSettings, MimeMessage message, String charset) {
        this.serverSettings = new EmailServerSettingsVO(serverSettings);
        this.fromAddress = new EmailFromAddress(this.serverSettings.getEmailSender(), this.toList);
        try {
            this.toList = this.generateAddressList(message.getRecipients(Message.RecipientType.TO));
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        this.message = message;
    }

    protected Email(EmailServerSettingsVO serverSettings) {
        this.serverSettings = serverSettings;
        this.fromAddress = new EmailFromAddress(serverSettings.getEmailSender(), List.of());
    }

    public static Email createSimpleEmail(EmailServerSettingsVO serverSettings, List<String> toList, List<String> ccList, List<String> bccList, List<String> replyList, String subject, String content) {
        return new SimpleEmail(serverSettings, toList, ccList, bccList, replyList, subject, content);
    }

    public static Email createEmail(EmailServerSettingsVO serverSettings, MimeMessage message) {
        try {
            if (message.getContent() instanceof MimeMultipart) {
                return new MultiPartEmail(serverSettings, message, UTF8);
            }
            return new SimpleEmail(serverSettings, message, UTF8);
        }
        catch (IOException e) {
            LoggerUtilities.logException(e);
        }
        catch (MessagingException e) {
            LoggerUtilities.logException(e);
        }
        return new MultiPartEmail(serverSettings, message, UTF8);
    }

    public static MultiPartEmail createMultiPartEmail(EmailServerSettingsVO serverSettings, List<String> toList, List<String> ccList, List<String> bccList, List<String> replyList, String subject, String content, String contentType) {
        return new MultiPartEmail(serverSettings, toList, ccList, bccList, replyList, subject, content, contentType);
    }

    private void init(List<String> targetList, List<String> sourceList) {
        if (sourceList != null) {
            for (String entry : sourceList) {
                if (entry == null) continue;
                targetList.add(entry);
            }
        }
    }

    public static String getOptionalServerDomain(String emailAddress) {
        return EmailFromAddress.extractDomainName(emailAddress);
    }

    public boolean canSendMail() {
        logger.log(Level.FINE, "msg [" + this.message + "]");
        return this.message != null;
    }

    public void testConnection() throws MessagingException {
        try {
            Session session = this.createMailSession(this.serverSettings.getEmailServerAddress(), false);
            try (Transport transport = session.getTransport();){
                transport.connect(this.serverSettings.getEmailServerAddress(), this.serverSettings.getEmailServerPort().intValue(), this.serverSettings.getEmailUsername(), this.serverSettings.getEmailPassword());
            }
        }
        catch (EmailException emailException) {
            // empty catch block
        }
    }

    public String send() throws EmailException {
        this.validateReceiver();
        try {
            return this.send(this.serverSettings.getEmailServerAddress());
        }
        catch (EmailException e) {
            if (!StringUtilities.isEmpty(this.serverSettings.getOptionalServerDomain())) {
                logger.log(Level.INFO, "Retry to send email using an optional server domain: " + this.serverSettings.getOptionalServerDomain());
                System.out.println("Retry to send email using an optional server domain: " + this.serverSettings.getOptionalServerDomain());
                String mailServer = this.lookupMailServer(this.serverSettings.getOptionalServerDomain());
                if (StringUtilities.isEmpty(mailServer)) {
                    System.out.println("No mail server found for the given server domain.");
                } else {
                    return this.send(mailServer);
                }
            }
            throw e;
        }
    }

    protected String send(String emailServer) throws EmailException {
        this.buildMessage(emailServer);
        logger.log(Level.INFO, StringUtilities.join("Start to send email to ", this.getAllReceivers().toString(), " using server: ", emailServer));
        System.out.println(StringUtilities.join("Start to send email to ", this.getAllReceivers().toString(), " using server: ", emailServer));
        try {
            return this.sendMessage();
        }
        catch (EmailException e) {
            LoggerUtilities.logException(e);
            logger.log(Level.SEVERE, StringUtilities.join("Fail to send email to ", this.getFailedReceivers().toString(), " using server: ", emailServer));
            throw e;
        }
    }

    protected abstract void setContent() throws MessagingException;

    protected void setContent(Object content, String contentType) throws MessagingException {
        this.message.setContent(content, this.getContentTypeString());
        this.updateContentType(contentType);
    }

    protected void updateContentType(String contentType) {
        this.contentType = contentType;
    }

    protected void buildMessage(String emailServerAddress) throws EmailException {
        this.buildMessage(emailServerAddress, true);
    }

    private void buildMessage(String emailServerAddress, boolean isEmailServerValidated) throws EmailException {
        this.message = new MimeMessage(this.createMailSession(emailServerAddress, isEmailServerValidated));
        try {
            this.setSubject();
            this.setContent();
            this.validateContent();
            this.setFrom();
            this.setTo();
            this.setCc();
            this.setBcc();
            this.setReplyTo();
            this.message.setSentDate(new Date());
        }
        catch (MessagingException e) {
            throw new EmailException(e);
        }
    }

    protected String sendMessage() throws EmailException {
        try {
            logger.log(Level.INFO, "Sending email... ");
            Transport.send((Message)this.message);
            logger.log(Level.INFO, "Email was successfully sent to " + this.getAllReceivers());
            return this.message.getMessageID();
        }
        catch (SendFailedException sfe) {
            this.sentResult.clear();
            if (sfe.getValidSentAddresses() != null) {
                this.sentResult.addValidSentAddresses(sfe.getValidSentAddresses(), this.toList, this.ccList);
                logger.log(Level.FINE, "Valid sent addresses: " + Arrays.toString(sfe.getValidSentAddresses()));
            }
            if (sfe.getValidUnsentAddresses() != null) {
                this.sentResult.addValidUnsentAddresses(sfe.getValidUnsentAddresses(), this.toList, this.ccList);
                logger.log(Level.SEVERE, "Valid unsent addresses: " + Arrays.toString(sfe.getValidUnsentAddresses()));
            }
            if (sfe.getInvalidAddresses() != null) {
                this.sentResult.addInvalidAddresses(sfe.getInvalidAddresses(), this.toList, this.ccList);
                logger.log(Level.SEVERE, "Invalid addresses: " + Arrays.toString(sfe.getInvalidAddresses()));
            }
            throw new EmailException(sfe);
        }
        catch (MessagingException me) {
            this.sentResult.clear();
            this.sentResult.getValidUnsentToAddresses().addAll(this.toList);
            this.sentResult.getValidUnsentCcAddresses().addAll(this.ccList);
            throw new EmailException(me);
        }
    }

    /*
     * Exception decompiling
     */
    public void sendMessage(File file) throws EmailException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveEmail(List<String> to, List<String> cc, List<String> bcc, String fileName) {
        ByteArrayOutputStream os = null;
        try {
            if (this.message == null) {
                this.buildMessage(this.serverSettings.getEmailServerAddress(), false);
            }
            os = new ByteArrayOutputStream();
            this.message.setRecipients(Message.RecipientType.TO, (Address[])this.toInternetAddressArray(to));
            this.message.setRecipients(Message.RecipientType.CC, (Address[])this.toInternetAddressArray(cc));
            this.message.setRecipients(Message.RecipientType.BCC, (Address[])this.toInternetAddressArray(bcc));
            this.message.writeTo((OutputStream)os);
            String encryptedMail = Utility.encrypt(os.toString(UTF8));
            Utility.createFile(encryptedMail.getBytes(UTF8), fileName, true);
        }
        catch (Exception e) {
            try {
                LoggerUtilities.logException(e);
            }
            catch (Throwable throwable) {
                IOUtilities.closeOutputStream(os);
                throw throwable;
            }
            IOUtilities.closeOutputStream(os);
        }
        IOUtilities.closeOutputStream(os);
    }

    protected Session createMailSession(String emailServer) throws EmailException {
        return this.createMailSession(emailServer, true);
    }

    protected Session createMailSession(String emailServer, boolean validateEmailServer) throws EmailException {
        Properties properties = new Properties();
        properties.setProperty(MAIL_TRANSPORT_PROTOCOL, SMTP);
        if (validateEmailServer) {
            this.validateEmailServer(emailServer);
        }
        properties.setProperty(MAIL_HOST, Optional.ofNullable(emailServer).orElse(EMPTY_STRING));
        properties.setProperty(MAIL_PORT, this.serverSettings.getEmailServerPort().toString());
        properties.setProperty(MAIL_SMTP_CONNECTIONTIMEOUT, Integer.toString(60000));
        properties.setProperty(MAIL_SMTP_TIMEOUT, Integer.toString(60000));
        properties.setProperty(MAIL_SMTP_SENDPARTIAL, "true");
        properties.setProperty(MAIL_FROM, this.fromAddress.getAddressString());
        properties.setProperty(MAIL_SMTP_FROM, this.fromAddress.getAddressString());
        String elho = this.getEHLOResponse();
        properties.put(MAIL_SMTP_LOCALHOST, elho);
        logger.log(Level.FINEST, "set EHLO response:" + elho + " for email server " + emailServer);
        if (this.serverSettings.isAuthenticatable()) {
            properties.setProperty(MAIL_SMTP_AUTH, "true");
            this.authenticator = new SMTPAuthenticator(this.serverSettings.getEmailUsername(), this.serverSettings.getEmailPassword());
        }
        if (this.serverSettings.isSslEnable()) {
            properties.setProperty(MAIL_SMTP_SSL_ENABLE, "true");
        }
        if (this.serverSettings.isTlsEnable()) {
            properties.setProperty(MAIL_SMTP_STARTTLS_ENABLE, "true");
            properties.setProperty(MAIL_SMTP_STARTTLS_REQUIRED, "true");
        }
        if (this.serverSettings.isSslEnable() || this.serverSettings.isTlsEnable()) {
            if (this.serverSettings.isDisableCertValidation()) {
                properties.setProperty(MAIL_SMTP_SSL_TRUST, emailServer);
            } else {
                properties.setProperty(MAIL_SMTP_SSL_CHECK_SERVER_IDENTITY, "true");
            }
        }
        Session session = Session.getInstance((Properties)properties, (Authenticator)this.authenticator);
        if (this.isDebugEnabled()) {
            session.setDebug(true);
        }
        return session;
    }

    private String getEHLOResponse() {
        Object ehlo = EMPTY_STRING;
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            ehlo = localhost.getCanonicalHostName();
            if (!((String)ehlo).contains(".") && !Utility.isValidIPAddr((String)ehlo)) {
                InetAddress[] addr;
                for (InetAddress address : addr = InetAddress.getAllByName((String)ehlo)) {
                    if (!(address instanceof Inet6Address) || address.isLoopbackAddress() || address.isLinkLocalAddress()) continue;
                    ehlo = "[IPv6:" + Utility.shortenIpv6Address(address.getHostAddress()) + "]";
                }
                return ehlo;
            }
            if (((String)ehlo).equals(localhost.getHostAddress())) {
                ehlo = "[" + (String)ehlo + "]";
            }
        }
        catch (UnknownHostException e) {
            logger.log(Level.WARNING, "Failed to get InetAddress! " + e.getMessage());
        }
        return ehlo;
    }

    protected void setSubject() throws MessagingException {
        if (!StringUtilities.isEmpty(this.subject)) {
            this.message.setSubject(this.subject, this.getCharset());
        }
    }

    protected void setFrom() throws MessagingException {
        this.message.setFrom((Address)this.fromAddress.getAddress());
    }

    protected void setTo() throws MessagingException {
        if (this.toList.size() > 0) {
            this.message.setRecipients(Message.RecipientType.TO, (Address[])this.toInternetAddressArray(this.toList));
        }
    }

    protected void setCc() throws MessagingException {
        if (this.ccList.size() > 0) {
            this.message.setRecipients(Message.RecipientType.CC, (Address[])this.toInternetAddressArray(this.ccList));
        }
    }

    protected void setBcc() throws MessagingException {
        if (this.bccList.size() > 0) {
            this.message.setRecipients(Message.RecipientType.BCC, (Address[])this.toInternetAddressArray(this.bccList));
        }
    }

    protected void setReplyTo() throws MessagingException {
        if (this.replyList.size() > 0) {
            this.message.setReplyTo((Address[])this.toInternetAddressArray(this.replyList));
        } else {
            this.message.setReplyTo((Address[])new InternetAddress[]{this.fromAddress.getAddress()});
        }
    }

    protected InternetAddress[] toInternetAddressArray(List<String> addresses) throws MessagingException {
        InternetAddress[] ia = new InternetAddress[addresses.size()];
        int index = 0;
        for (String address : addresses) {
            if (StringUtilities.isEmpty(address)) continue;
            try {
                ia[index] = new InternetAddress(address);
                ++index;
            }
            catch (AddressException e) {
                throw new MessagingException("Invalid server address for mail session: " + address);
            }
        }
        return ia;
    }

    protected List<String> generateAddressList(Address[] addresses) {
        ArrayList<String> target = new ArrayList<String>();
        for (Address address : addresses) {
            target.add(address.toString());
        }
        return target;
    }

    protected String lookupMailServer(String serverDomain) {
        Object domainName = serverDomain;
        if (StringUtilities.isEmpty((String)domainName)) {
            try {
                domainName = InetAddress.getLocalHost().getHostName() + ".com";
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        MXRecordLookup recordLookup = new MXRecordLookup((String)domainName);
        return recordLookup.getMailServer();
    }

    private void validateEmailServer(String emailServerAddress) throws EmailException {
        if (StringUtilities.isEmpty(emailServerAddress)) {
            this.sentResult.clear();
            this.sentResult.getValidUnsentToAddresses().addAll(this.toList);
            this.sentResult.getValidUnsentCcAddresses().addAll(this.ccList);
            throw new EmailException("Cannot find valid server address for mail session");
        }
    }

    private void validateReceiver() throws EmailException {
        if (this.toList.size() + this.ccList.size() + this.bccList.size() == 0) {
            throw new EmailException("At least one receiver address required");
        }
    }

    private void validateContent() throws EmailException, MessagingException {
        try {
            if (this.message.getContent() == null) {
                throw new EmailException("The content of the message cannot be null!");
            }
        }
        catch (IOException e) {
            throw new EmailException(e);
        }
    }

    protected String getContentString() {
        return this.content == null ? EMPTY_STRING : this.content.toString();
    }

    protected String getContentTypeString() {
        String contentTypeString = this.contentType == null ? TEXT_PLAIN : this.contentType;
        return StringUtilities.join(contentTypeString, ";charset=", this.getCharset());
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    protected boolean isDebugEnabled() {
        return this.debug;
    }

    protected String getCharset() {
        return StringUtilities.isEmpty(this.charset) ? UTF8 : this.charset;
    }

    public List<String> getAllReceivers() {
        ArrayList<String> result = new ArrayList<String>(this.toList);
        result.addAll(this.ccList);
        result.addAll(this.bccList);
        return result;
    }

    public String getFromAddress(List<String> suggestedEmailAddresses) {
        return this.fromAddress.getAddressString(suggestedEmailAddresses);
    }

    public String getFailedReceivers() {
        ArrayList<String> result = new ArrayList<String>(this.getFailedToAddresses());
        result.addAll(this.getFailedCcAddresses());
        result.addAll(this.getFailedBccAddresses());
        return result.size() > 0 ? StringUtilities.listToString(result) : EMPTY_STRING;
    }

    private void set(List<String> source, List<String> target) {
        if (source != null) {
            for (String entry : source) {
                target.add(entry);
            }
        }
    }

    public void setTo(List<String> toList) {
        this.set(toList, this.toList);
    }

    public void setCc(List<String> ccList) {
        this.set(ccList, this.ccList);
    }

    public void setBcc(List<String> bccList) {
        this.set(bccList, this.bccList);
    }

    public void setReplyList(List<String> replyList) {
        this.set(replyList, this.replyList);
    }

    public void setFrom(String fromAddress) {
        if (fromAddress != null) {
            this.serverSettings.setEmailSender(fromAddress);
            this.fromAddress.setSpecifiedAddress(this.serverSettings.getEmailSender());
        }
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public List<String> getFailedToAddresses() {
        ArrayList<String> result = new ArrayList<String>(this.sentResult.getInvalidToAddresses());
        result.addAll(this.sentResult.getValidUnsentToAddresses());
        return result;
    }

    public List<String> getFailedCcAddresses() {
        ArrayList<String> result = new ArrayList<String>(this.sentResult.getInvalidCcAddresses());
        result.addAll(this.sentResult.getValidUnsentCcAddresses());
        return result;
    }

    public List<String> getFailedBccAddresses() {
        ArrayList<String> result = new ArrayList<String>(this.sentResult.getInvalidBccAddresses());
        result.addAll(this.sentResult.getValidUnsentBccAddresses());
        return result;
    }

    public MimeMessage getMessage() {
        return this.message;
    }

    public static HashMap<String, String[]> getMailServerDomainNameMap(String to, String cc) throws MessagingException {
        String[] array;
        int index;
        String emailAddress;
        HashMap<String, String[]> domainMailAddressesMap = new HashMap<String, String[]>();
        int i = 0;
        String domainName = null;
        InternetAddress[] addresses = null;
        if (to != null) {
            addresses = InternetAddress.parse((String)to, (boolean)false);
        }
        if (addresses != null) {
            for (i = 0; i < addresses.length; ++i) {
                emailAddress = addresses[i].toString();
                index = emailAddress.indexOf(64);
                if (index >= emailAddress.length()) continue;
                domainName = emailAddress.substring(index + 1);
                array = domainMailAddressesMap.get(domainName);
                if (array == null) {
                    array = new String[2];
                    array[0] = EMPTY_STRING;
                    domainMailAddressesMap.put(domainName, array);
                } else if (array[0].length() > 0) {
                    array[0] = array[0] + EMAIL_SEPARATOR_0;
                }
                array[0] = array[0] + emailAddress;
            }
        }
        addresses = null;
        if (cc != null) {
            addresses = InternetAddress.parse((String)cc, (boolean)false);
        }
        if (addresses != null) {
            for (i = 0; i < addresses.length; ++i) {
                emailAddress = addresses[i].toString();
                index = emailAddress.indexOf(64);
                if (index >= emailAddress.length()) continue;
                domainName = emailAddress.substring(index + 1);
                array = domainMailAddressesMap.get(domainName);
                if (array == null) {
                    array = new String[2];
                    array[1] = EMPTY_STRING;
                    domainMailAddressesMap.put(domainName, array);
                } else if (array[1].length() > 0) {
                    array[1] = array[1] + EMAIL_SEPARATOR_0;
                }
                array[1] = array[1] + emailAddress;
            }
        }
        return domainMailAddressesMap;
    }
}

