/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.ldap;

import com.sygate.scm.common.configobject.schema.DirectoryServer;
import com.sygate.scm.common.configobject.schema.ReplicationDirectoryServer;
import com.sygate.scm.common.valueobject.ValueObject;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.ldap.LdapPath;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class LdapValueObject
extends ValueObject {
    private static final long serialVersionUID = 1911948149707194086L;
    static final String LDAP_PROTOCAL = "ldap:";
    static final String LDAPS_PROTOCAL = "ldaps:";
    static final String COLON = ":";
    static final long DEFAULT_PORT = 389L;
    static final long DEFAULT_SSL_PORT = 636L;
    private String serverAddress;
    private Long port;
    private String serverName;
    private TYPE type;
    private Boolean useSSL;
    private Boolean disableCertValidation;
    private String username;
    private transient String password;
    private String baseDN;
    private String filter;
    private DirectoryServer server;
    private String serverId;
    private String authenticationErrorMessage;
    private int errorCode = 0;
    private String errorMsg = null;
    private List<DirectoryServer> replicationServers = new ArrayList<DirectoryServer>();

    public static LdapValueObject newInstance(String serverAddress, Long port, String serverName, Integer type, Boolean useSSL, Boolean disableCertValidation, String username, String password, String baseDN) {
        return new LdapValueObject(serverAddress, port, serverName, type, useSSL, disableCertValidation, username, password, baseDN);
    }

    public static LdapValueObject newInstance(String ldapPath, String serverName, Integer type, Boolean useSSL, Boolean disableCertValidation, String username, String password, String baseDN) {
        LdapValueObject vo = new LdapValueObject(null, null, serverName, type, useSSL, disableCertValidation, username, password, baseDN);
        vo.parse(ldapPath);
        return vo;
    }

    public static LdapValueObject newInstance(DirectoryServer ds) {
        if (ds == null) {
            throw new IllegalArgumentException("The parameter DirectoryServer cannot be null!");
        }
        LdapValueObject instance = new LdapValueObject(ds.getServerAddress(), ds.getOptPort(), ds.getName(), ds.getType(), ds.getOptUseSSL(), ds.getOptDisableCertValidate(), ds.getOptUsername(), ds.getOptPassword(), ds.getOptBaseDN());
        instance.setReplicationServers(ds);
        instance.server = ds;
        instance.serverId = ds.getOptGuid();
        return instance;
    }

    public static LdapValueObject newNull() {
        return new LdapValueObject();
    }

    private LdapValueObject() {
        this(null, null, null, null, null, null, null, null, null);
    }

    private LdapValueObject(String serverAddress, Long port, String serverName, Integer type, Boolean useSSL, Boolean disableCertValidation, String username, String password, String baseDN) {
        this.serverAddress = serverAddress;
        this.port = port;
        this.serverName = serverName;
        this.setType(type);
        this.useSSL = useSSL;
        this.disableCertValidation = disableCertValidation;
        this.username = username;
        this.password = password;
        this.baseDN = baseDN;
    }

    public void setType(Integer type) {
        this.type = TYPE.ADDC.getValue().equals(type) ? TYPE.ADDC : (TYPE.LDAP.getValue().equals(type) ? TYPE.LDAP : TYPE.UNKNOWN);
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    void parse(String ldapPath) {
        String urlWithoutLdap;
        if (StringUtilities.isEmpty(ldapPath)) {
            return;
        }
        String path = ldapPath.toLowerCase();
        if (path.startsWith(LDAPS_PROTOCAL)) {
            this.useSSL = Boolean.TRUE;
        }
        if ((urlWithoutLdap = StringUtilities.substringAfter(path, "//")).indexOf(COLON) != -1) {
            this.serverAddress = StringUtilities.substringBefore(urlWithoutLdap, COLON);
            String port = StringUtilities.substringAfter(urlWithoutLdap, this.serverAddress + COLON);
            this.port = this.parsePort(StringUtilities.substringBefore(port, "/"));
        } else {
            this.serverAddress = StringUtilities.substringBefore(urlWithoutLdap, "/");
            this.port = this.parsePort("");
        }
    }

    long parsePort(String port) {
        try {
            return Long.parseLong(port);
        }
        catch (NumberFormatException e) {
            return Boolean.TRUE.equals(this.isSSLUsed()) ? 636L : 389L;
        }
    }

    public void setReplicationServers(DirectoryServer ds) {
        if (ds == null) {
            return;
        }
        ReplicationDirectoryServer repServer = ds.getOptReplicationDirectoryServer();
        if (repServer != null) {
            for (DirectoryServer server : repServer.getDirectoryServer()) {
                this.replicationServers.add(server);
            }
        }
    }

    public void setAuthenticationErrorMessage(String authenticationErrorMessage) {
        this.authenticationErrorMessage = authenticationErrorMessage;
    }

    public boolean isAuthenticationFailed() {
        return !StringUtilities.isEmpty(this.authenticationErrorMessage);
    }

    public String getAuthenticationErrorMessage() {
        return this.authenticationErrorMessage;
    }

    public String getLdapPath() {
        if (this.server != null) {
            return LdapPath.getLdapAddress(this.server);
        }
        return LdapPath.getLdapPath(this.serverAddress, this.getPortString(), null, this.useSSL);
    }

    public String getLdapPathWithBaseDN() {
        return LdapPath.getLdapPath(this.serverAddress, this.getPortString(), this.baseDN, this.useSSL);
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public Long getPort() {
        return this.port;
    }

    public String getPortString() {
        return null == this.port ? "" : this.port.toString();
    }

    public String getServerName() {
        return this.serverName;
    }

    public TYPE getType() {
        return this.type;
    }

    public Boolean isSSLUsed() {
        if (this.server == null) {
            return this.useSSL;
        }
        return this.server.getOptUseSSL() != null ? this.server.getOptUseSSL() : this.server.getDefUseSSL();
    }

    public Boolean isDisableCertValidation() {
        if (this.server == null) {
            return this.disableCertValidation;
        }
        return Optional.ofNullable(this.server.getOptDisableCertValidate()).orElse(this.server.getDefDisableCertValidate());
    }

    public String getUsername() {
        if (this.server == null) {
            return this.getInternalUsername(this.username);
        }
        return this.getInternalUsername(this.server.getOptUsername());
    }

    private String getInternalUsername(String name) {
        String result = name == null ? "admin" : name;
        return result.replaceAll("\"", "");
    }

    public String getPassword() {
        return this.password == null ? "" : this.password.trim();
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public List<DirectoryServer> getReplicationServers() {
        return this.replicationServers;
    }

    public String getFilter() {
        return this.filter == null ? "" : this.filter.trim();
    }

    public String getDirectoryServerId() {
        return this.serverId == null ? "" : this.serverId;
    }

    public void setDirectoryServerId(String serverId) {
        this.serverId = serverId;
    }

    public void setBaseDN(String baseDN) {
        this.baseDN = baseDN;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public List<LdapValueObject> getReplicationServerObjects() {
        ArrayList<LdapValueObject> result = new ArrayList<LdapValueObject>();
        for (DirectoryServer server : this.replicationServers) {
            LdapValueObject vo = LdapValueObject.newInstance(server.getServerAddress(), this.getPort(), this.getServerName(), this.getType().getValue(), this.isSSLUsed(), this.isDisableCertValidation(), this.getUsername(), this.getPassword(), this.getBaseDN());
            vo.setDirectoryServerId(server.getOptGuid());
            result.add(vo);
        }
        return result;
    }

    public static enum TYPE {
        ADDC(DirectoryServer.ADDC),
        LDAP(DirectoryServer.LDAP),
        UNKNOWN(-1);

        private Integer value;

        private TYPE(Integer value) {
            this.value = value;
        }

        public Integer getValue() {
            return this.value;
        }
    }
}

