/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.ldap;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.schema.DirectoryServer;
import com.sygate.scm.common.configobject.schema.SemClientGroup;
import com.sygate.scm.util.CollectionUtils;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.ldap.LdapPath;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;

public class LdapUtilsLegacy {
    public static DirectoryServer retrieveDirectoryServerForGroupAdTree(SemClientGroup groupAdTree, List<DirectoryServer> listDirectoryServer) {
        String AdId = LdapUtilsLegacy.retrieveDirectoryServerIdFromAdNode(groupAdTree);
        DirectoryServer adServer = null;
        if (!StringUtilities.isEmpty(AdId)) {
            adServer = LdapUtilsLegacy.searchDirectoryServerById(listDirectoryServer, AdId);
        }
        if (adServer == null) {
            adServer = LdapUtilsLegacy.searchDirectoryServerByAdPath(groupAdTree.getOptADsPath(), listDirectoryServer);
        }
        return adServer;
    }

    private static DirectoryServer searchDirectoryServerById(List<DirectoryServer> listDirectoryServer, String id) {
        System.out.println("LdapUtilsLegacy>>retrieveDirectoryServerById: id=" + id);
        for (DirectoryServer server : listDirectoryServer) {
            String guid = server.getOptGuid();
            if (guid == null || !guid.equals(id)) continue;
            return server;
        }
        return null;
    }

    private static String retrieveDirectoryServerIdFromAdNode(SemClientGroup groupAdTree) {
        Integer type = groupAdTree.getOptType();
        if (SemClientGroup.ADNODE.equals(type) || SemClientGroup.ADTREE.equals(type)) {
            String dirServerId = groupAdTree.getOptDirectoryServerRefId();
            if (StringUtilities.isEmpty(dirServerId)) {
                AbstractSchema parent = groupAdTree.getParent();
                if (!(parent instanceof SemClientGroup)) {
                    return null;
                }
                return LdapUtilsLegacy.retrieveDirectoryServerIdFromAdNode((SemClientGroup)parent);
            }
            return dirServerId;
        }
        return null;
    }

    public static DirectoryServer searchDirectoryServerByAdPath(String adsPath, List<DirectoryServer> listDirectoryServer) {
        if (CollectionUtils.isNullOrEmpty(listDirectoryServer)) {
            return null;
        }
        String path = adsPath;
        path = path != null ? path.trim() : "";
        LdapPath lp = new LdapPath(path);
        lp.parse();
        path = lp.getPartServer();
        System.out.println("LdapUtilsLegacy>> searchDirectoryServerByAdPath: path=" + path + ", AdsPath=" + adsPath);
        String hostNameFromAdPath = null;
        for (int k = 0; k < listDirectoryServer.size(); ++k) {
            String hostNameFromAdServer;
            DirectoryServer ds = listDirectoryServer.get(k);
            if (ds == null) continue;
            Object address = ds.getServerAddress();
            if (ds.getOptPort() != null) {
                address = (String)address + ":" + ds.getOptPort().toString();
            }
            System.out.println("LdapUtilsLegacy>> searchDirectoryServerByAdPath: #" + k + ", ds address=" + ((String)address).trim() + " and path=" + path);
            if (path.equalsIgnoreCase(((String)address).trim())) {
                System.out.println("LdapUtilsLegacy>> searchDirectoryServerByAdPath: ds found! address=" + ((String)address).trim());
                return ds;
            }
            if (hostNameFromAdPath == null) {
                hostNameFromAdPath = path;
                int end = path.indexOf(58);
                if (end >= 0) {
                    hostNameFromAdPath = path.substring(0, end);
                }
                hostNameFromAdPath = LdapUtilsLegacy.getHostName(hostNameFromAdPath);
                System.out.println("LdapUtilsLegacy>> searchDirectoryServerByAdPath:Host name from AdPath:" + hostNameFromAdPath);
            }
            if (hostNameFromAdPath == null || !hostNameFromAdPath.equalsIgnoreCase(hostNameFromAdServer = LdapUtilsLegacy.getHostName(((String)address).trim().substring(0, ((String)address).trim().indexOf(58))))) continue;
            System.out.println("LdapUtilsLegacy>> searchDirectoryServerByAdPath: ds found! address=" + ((String)address).trim() + " and hostName=" + hostNameFromAdServer);
            return ds;
        }
        return null;
    }

    private static String getHostName(String path) {
        InetAddress address = null;
        String hostName = path;
        try {
            address = InetAddress.getByName(path);
            hostName = address.getHostName();
            System.out.println("LdapUtilsLegacy>>  getHostName() " + address.getHostName() + "=" + address.getHostAddress());
        }
        catch (UnknownHostException e) {
            System.out.println("LdapUtilsLegacy>>  getHostName() " + path + ":" + e.getMessage());
        }
        return hostName;
    }
}

