/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.ldap;

import com.sygate.scm.common.configobject.schema.DirectoryServer;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.SymantecMessageDigest;
import com.sygate.scm.util.Utility;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.validator.routines.InetAddressValidator;

public class LdapPath {
    public static final String LDAP_PATH_HEADER = "LDAP:";
    public static final String LDAP_PATH_PREFIX = "LDAP://";
    public static final String LDAPS_PATH_HEADER = "LDAPS:";
    public static final String LDAPS_PATH_PREFIX = "LDAPS://";
    public static final int BINDINGMODE_UNKNOWN = 0;
    public static final int BINDINGMODE_ROOT = 1;
    public static final int BINDINGMODE_SERVER = 2;
    public static final int BINDINGMODE_SERVER_PORT = 3;
    public static final int BINDINGMODE_LOCAL_OBJECT = 4;
    public static final int BINDINGMODE_REMOTE_OBJECT = 5;
    public static final int BINDINGTYPE_UNKNOWN = 0;
    public static final int BINDINGTYPE_NORMAL = 1;
    public static final int BINDINGTYPE_SSL = 2;
    private String m_ldapPath = null;
    private int m_bindingType = 0;
    private int m_bindingMode = 0;
    private String m_server = null;
    private String m_port = null;
    private String m_currentCommonName = null;
    private String m_currentOU = null;
    private ArrayList<String> m_listCommonNames = null;
    private ArrayList<String> m_listDomainComponents = null;
    private ArrayList<String> m_listOUs = null;
    private String m_partServer = null;
    private String m_partDN = null;

    public LdapPath() {
    }

    public LdapPath(String ldapPath) {
        this.m_ldapPath = ldapPath;
    }

    private void init() {
        this.m_bindingMode = 0;
        this.m_server = null;
        this.m_port = null;
        this.m_currentCommonName = null;
        this.m_currentOU = null;
        if (this.m_listCommonNames != null) {
            this.m_listCommonNames.clear();
        }
        if (this.m_listDomainComponents != null) {
            this.m_listDomainComponents.clear();
        }
        if (this.m_listOUs != null) {
            this.m_listOUs.clear();
        }
    }

    public void setPath(String ldapPath) {
        this.m_ldapPath = ldapPath;
        this.init();
    }

    public String getPath() {
        return this.m_ldapPath;
    }

    public String getPartServer() {
        return this.m_partServer;
    }

    public String getPartDN() {
        return this.m_partDN;
    }

    public int getBindingMode() {
        return this.m_bindingMode;
    }

    public String getServer() {
        return this.m_server;
    }

    public String getPort() {
        return this.m_port;
    }

    public int getPortInt() {
        try {
            return Integer.parseInt(this.m_port);
        }
        catch (Throwable ex) {
            return -1;
        }
    }

    public String getCurrentCN() {
        return this.m_currentCommonName;
    }

    public List<String> getCNList() {
        return this.m_listCommonNames;
    }

    public String getCNPath() {
        if (this.m_listCommonNames == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.m_listCommonNames.size(); ++i) {
            String cn = this.m_listCommonNames.get(i).toString();
            if (i != 0) {
                buf.append("/");
            }
            buf.append(cn);
        }
        return buf.toString();
    }

    public String getCurrentOU() {
        return this.m_currentOU;
    }

    public List<String> getOUList() {
        return this.m_listOUs;
    }

    public String getOUPath() {
        if (this.m_listOUs == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.m_listOUs.size(); ++i) {
            String ou = this.m_listOUs.get(i).toString();
            if (i != 0) {
                buf.append("/");
            }
            buf.append(ou);
        }
        return buf.toString();
    }

    public List<String> getDCList() {
        return this.m_listDomainComponents;
    }

    public String getDomainName() {
        if (this.m_listDomainComponents == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.m_listDomainComponents.size(); ++i) {
            String dc = this.m_listDomainComponents.get(i).toString();
            if (i != 0) {
                buf.append(".");
            }
            buf.append(dc);
        }
        return buf.toString();
    }

    public int getLdapPathType() {
        if (this.m_ldapPath == null) {
            return 0;
        }
        if (this.m_ldapPath.startsWith(LDAPS_PATH_HEADER)) {
            return 2;
        }
        if (this.m_ldapPath.startsWith(LDAP_PATH_HEADER)) {
            return 1;
        }
        return 0;
    }

    public boolean parse() {
        String[] dns;
        this.m_partServer = "";
        this.m_partDN = "";
        if (this.m_ldapPath == null) {
            this.m_bindingMode = 0;
            return false;
        }
        if (this.m_ldapPath.equals(LDAP_PATH_HEADER) || this.m_ldapPath.equals(LDAPS_PATH_HEADER)) {
            this.m_bindingMode = 1;
            return true;
        }
        String prefix = null;
        if (this.m_ldapPath.startsWith(LDAPS_PATH_PREFIX)) {
            this.m_bindingType = 2;
            prefix = LDAPS_PATH_PREFIX;
        } else if (this.m_ldapPath.startsWith(LDAP_PATH_PREFIX)) {
            this.m_bindingType = 1;
            prefix = LDAP_PATH_PREFIX;
        } else {
            this.m_bindingType = 0;
            this.m_bindingMode = 0;
            return false;
        }
        String path = this.m_ldapPath.substring(prefix.length(), this.m_ldapPath.length());
        int index_of_slash = path.indexOf("/");
        int index_of_equal = path.indexOf("=");
        if (index_of_slash > -1 || index_of_equal < 0) {
            String host = path;
            if (index_of_slash > -1) {
                host = path.substring(0, index_of_slash);
                path = path.substring(index_of_slash + 1, path.length());
                this.m_partServer = host;
            } else {
                this.m_partServer = path;
            }
            int i = host.indexOf(":");
            if (i < 0) {
                this.m_server = host;
                this.m_bindingMode = 2;
            } else {
                this.m_server = host.substring(0, i);
                this.m_port = host.substring(i + 1, host.length());
                this.m_bindingMode = 3;
            }
            if (index_of_equal < 0) {
                return true;
            }
        } else {
            this.m_bindingMode = 4;
        }
        this.m_partDN = path.trim().replaceAll("(\\s*,\\s*)", ",");
        for (String component : dns = path.split(",")) {
            index_of_equal = component.indexOf("=");
            if (index_of_equal < 0) {
                if (this.m_bindingMode == 2 || this.m_bindingMode == 3) {
                    return true;
                }
                this.m_bindingMode = 0;
                return false;
            }
            String name = component.substring(0, index_of_equal).trim();
            String value = component.substring(index_of_equal + 1, component.length()).trim();
            if (name.equalsIgnoreCase("CN")) {
                if (this.m_currentCommonName == null) {
                    this.m_currentCommonName = value;
                }
                if (this.m_listCommonNames == null) {
                    this.m_listCommonNames = new ArrayList();
                }
                this.m_listCommonNames.add(value);
            } else if (name.equalsIgnoreCase("OU")) {
                if (this.m_currentOU == null) {
                    this.m_currentOU = value;
                }
                if (this.m_listOUs == null) {
                    this.m_listOUs = new ArrayList();
                }
                this.m_listOUs.add(value);
            } else if (name.equalsIgnoreCase("DC") || name.equalsIgnoreCase("o")) {
                if (this.m_listDomainComponents == null) {
                    this.m_listDomainComponents = new ArrayList();
                }
                this.m_listDomainComponents.add(value);
            }
            if (this.m_bindingMode != 2 && this.m_bindingMode != 3) continue;
            this.m_bindingMode = 5;
        }
        return true;
    }

    public void print() {
        int i;
        System.out.println("===== LdapPath: Begin ====================");
        System.out.println("m_ldapPath=" + this.m_ldapPath);
        System.out.println("m_partServer=" + this.m_partServer);
        System.out.println("m_partDN=" + this.m_partDN);
        System.out.println("m_bindingType=" + this.m_bindingType);
        System.out.println("m_bindingMode=" + this.m_bindingMode);
        System.out.println("m_server=" + (this.m_server == null ? "<unknown>" : this.m_server));
        System.out.println("m_port=" + (this.m_port == null ? "<unknown>" : this.m_port));
        System.out.println("m_currentCommonName=" + (this.m_currentCommonName == null ? "<unknown>" : this.m_currentCommonName));
        if (this.m_listCommonNames == null) {
            System.out.println("m_listCommonNames=<unknown>");
        } else {
            System.out.println("m_listCommonNames count=" + this.m_listCommonNames.size());
            for (i = 0; i < this.m_listCommonNames.size(); ++i) {
                System.out.println("\t#" + i + ", " + this.m_listCommonNames.get(i).toString());
            }
        }
        if (this.m_listOUs == null) {
            System.out.println("m_listOUs=<unknown>");
        } else {
            System.out.println("m_listOUs count=" + this.m_listOUs.size());
            for (i = 0; i < this.m_listOUs.size(); ++i) {
                System.out.println("\t#" + i + ", " + this.m_listOUs.get(i).toString());
            }
        }
        if (this.m_listDomainComponents == null) {
            System.out.println("m_listDomainComponents=<unknown>");
        } else {
            System.out.println("m_listDomainComponents count=" + this.m_listDomainComponents.size());
            for (i = 0; i < this.m_listDomainComponents.size(); ++i) {
                System.out.println("\t#" + i + ", " + this.m_listDomainComponents.get(i).toString());
            }
        }
        System.out.println("cn path=" + this.getCNPath());
        System.out.println("ou path=" + this.getOUPath());
        System.out.println("domain name=" + this.getDomainName());
        System.out.println("===== LdapPath: End ====================");
    }

    public static String getParentBaseDN(String baseDN) {
        if (baseDN == null) {
            return null;
        }
        int index = baseDN.indexOf(",");
        if (index > -1) {
            if (index - 1 > -1 && "\\".equals(baseDN.substring(index - 1, index))) {
                return LdapPath.getParentBaseDN(baseDN.substring(index + 1));
            }
            return baseDN.substring(index + 1);
        }
        return "";
    }

    public static String generateGuidByLdapPathAndName(String ldapPath, String name) {
        try {
            MessageDigest md = SymantecMessageDigest.getInstance();
            md.update(ldapPath.getBytes(Charset.defaultCharset()));
            if (name != null) {
                md.update(name.getBytes(Charset.defaultCharset()));
            }
            String hash = Utility.toHexString(md.digest());
            return hash;
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
            return new GUIDGenerator().getGUIDString();
        }
    }

    public static String getLdapPath(String serverHostName, String serverPort, String searchBase, boolean ssl) {
        if (serverHostName == null || serverHostName.length() < 1) {
            return null;
        }
        if (InetAddressValidator.getInstance().isValidInet6Address(serverHostName)) {
            serverHostName = Utility.checkAndAddBrackets(serverHostName);
        }
        StringBuffer buf = new StringBuffer();
        buf.append((ssl ? LDAPS_PATH_PREFIX : LDAP_PATH_PREFIX) + serverHostName);
        if (serverPort != null && serverPort.length() > 0) {
            buf.append(":" + serverPort);
        }
        if (searchBase != null && searchBase.length() > 0) {
            buf.append("/" + searchBase);
        }
        return buf.toString();
    }

    public static String getLdapAddress(DirectoryServer aDS) {
        String optBaseDN = aDS.getOptBaseDN() == null ? "" : aDS.getOptBaseDN();
        try {
            optBaseDN = URLEncoder.encode(optBaseDN, "UTF-8");
            optBaseDN = optBaseDN.replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e1) {
            LoggerUtilities.logException(e1);
        }
        boolean ssl = aDS.getOptUseSSL() != null ? aDS.getOptUseSSL() : aDS.getDefUseSSL();
        String ldapPath = LdapPath.getLdapPath(aDS.getServerAddress().trim(), aDS.getOptPort() == null ? "" : aDS.getOptPort().toString(), optBaseDN, ssl);
        ldapPath = ldapPath.charAt(ldapPath.length() - 1) == '/' ? ldapPath.substring(0, ldapPath.length() - 1) : ldapPath;
        return ldapPath;
    }
}

