/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.ini;

import com.sygate.scm.util.ini.IniDocument;
import com.sygate.scm.util.ini.IniElement;

public abstract class IniNode {
    protected boolean m_isRoot = false;
    protected IniDocument m_document = null;
    protected IniElement m_parent = null;
    protected IniNode m_nextSibling = null;
    protected IniNode m_prevSibling = null;
    protected String m_name = "";

    protected IniNode() {
    }

    public boolean isRoot() {
        return this.m_isRoot;
    }

    public IniElement getParent() {
        return this.m_parent;
    }

    protected void setParent(IniElement parent) {
        this.m_parent = parent;
    }

    public IniDocument getDocument() {
        return this.m_document;
    }

    protected void setDocument(IniDocument document) {
        this.m_document = document;
    }

    public IniNode getNextSibling() {
        return this.m_nextSibling;
    }

    public IniNode getPrevSibling() {
        return this.m_prevSibling;
    }

    public String getName() {
        return this.m_name;
    }

    protected void setName(String name) {
        this.m_name = name;
    }

    public int getIndex() {
        int index = 0;
        IniNode node = this.m_prevSibling;
        while (node != null) {
            ++index;
            node = node.m_prevSibling;
        }
        return index;
    }

    public String getPath() {
        Object path = this.getName();
        for (IniElement parent = this.getParent(); parent != null; parent = parent.getParent()) {
            path = parent.getPath() + this.m_document.getSetting().getPathSeparator() + (String)path;
        }
        return path;
    }

    public abstract boolean validate();

    public abstract String toString();
}

