/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.ini;

import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.ini.IniComment;
import com.sygate.scm.util.ini.IniDocument;
import com.sygate.scm.util.ini.IniElement;
import com.sygate.scm.util.ini.IniNode;
import com.sygate.scm.util.ini.IniProperty;
import com.sygate.scm.util.ini.IniRoot;
import com.sygate.scm.util.ini.IniSection;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class IniFile {
    IniDocument m_document = new IniDocument();
    IniRoot m_root = this.m_document.createRoot();

    public IniDocument getDocument() {
        return this.m_document;
    }

    public IniRoot getRoot() {
        return this.m_root;
    }

    public boolean read(String fileName, String charsetName) {
        boolean result = false;
        try (FileInputStream is = new FileInputStream(fileName);
             BufferedReader f = new BufferedReader(new InputStreamReader((InputStream)is, charsetName == null ? "UTF-8" : charsetName));){
            String line;
            IniElement parent = this.m_root;
            while ((line = f.readLine()) != null) {
                parent = this.parseStringLine(line, parent);
            }
            result = true;
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean read(String zipFilePath, String entryName, String charsetName) {
        boolean result = false;
        try (ZipFile zipFile = new ZipFile(zipFilePath);){
            String charsetNameUsed;
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            String string = charsetNameUsed = charsetName == null ? "UTF-8" : charsetName;
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().equalsIgnoreCase(entryName)) continue;
                InputStream is = zipFile.getInputStream(entry);
                try {
                    try (BufferedReader f = new BufferedReader(new InputStreamReader(is, charsetNameUsed));){
                        String line;
                        IniElement parent = this.m_root;
                        while ((line = f.readLine()) != null) {
                            parent = this.parseStringLine(line, parent);
                        }
                        result = true;
                    }
                    return result;
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                    return result;
                }
            }
        }
        catch (IOException ex) {
            LoggerUtilities.logException(ex);
        }
        return result;
    }

    public boolean read(String fileName) {
        boolean result = false;
        try (RandomAccessFile f = new RandomAccessFile(fileName, "r");){
            String line;
            IniElement parent = this.m_root;
            while ((line = f.readLine()) != null) {
                parent = this.parseStringLine(line, parent);
            }
            result = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            LoggerUtilities.log(String.format("Could not find ini file: %s", fileName));
            LoggerUtilities.log(fileNotFoundException.getMessage());
        }
        catch (IOException ex) {
            LoggerUtilities.logException(ex);
        }
        return result;
    }

    private IniElement parseStringLine(String line, IniElement parent) {
        IniElement newParent = parent;
        IniNode node = this.parseLine(line);
        if (node != null) {
            if (node instanceof IniElement) {
                if (parent.getParent() != null) {
                    parent = parent.getParent();
                }
                parent.addChild(node);
                newParent = (IniElement)node;
            } else {
                parent.addChild(node);
            }
        }
        return newParent;
    }

    private IniNode parseLine(String line) {
        String l = line.trim();
        if (this.isComment(l)) {
            String str = this.getCommentString(l);
            return this.m_document.createComment(str);
        }
        if (l.length() < 1) {
            return this.m_document.createSeparator();
        }
        if (this.isSection(l)) {
            String possibleComments;
            int startPos = line.indexOf(this.m_document.getSetting().getSectionBeginningSign());
            int endPos = line.indexOf(this.m_document.getSetting().getSectionEndingSign());
            String str = line.substring(startPos + 1, endPos);
            IniComment commentNode = null;
            if (endPos + 1 < l.length() && this.isComment(possibleComments = l.substring(endPos + 1).trim())) {
                possibleComments = this.getCommentString(possibleComments);
                commentNode = this.m_document.createComment(possibleComments);
            }
            return this.m_document.createSection(str, commentNode);
        }
        int index = l.indexOf(this.m_document.getSetting().getNameValueSeparator());
        if (index > -1) {
            String value;
            String sign;
            String name = l.substring(0, index).trim();
            int endPos = -1;
            List<String> commentSigns = this.m_document.getSetting().getCommentSign();
            Iterator<String> it = commentSigns.iterator();
            while (it.hasNext() && (endPos = l.indexOf(sign = it.next())) == -1) {
            }
            IniComment commentNode = null;
            if (endPos != -1) {
                value = l.substring(index + 1, endPos).trim();
                if (endPos + 1 < l.length()) {
                    String possibleComments = l.substring(endPos + 1).trim();
                    possibleComments = this.getCommentString(possibleComments);
                    commentNode = this.m_document.createComment(possibleComments);
                }
            } else {
                value = l.substring(index + 1, l.length()).trim();
            }
            return this.m_document.createProperty(name, value, commentNode);
        }
        return null;
    }

    private String getCommentString(String line) {
        line = line.trim();
        List<String> commentSigns = this.m_document.getSetting().getCommentSign();
        for (String sign : commentSigns) {
            if (!line.startsWith(sign)) continue;
            return line.substring(sign.length());
        }
        return line;
    }

    private boolean isComment(String line) {
        line = line.trim();
        List<String> commentSigns = this.m_document.getSetting().getCommentSign();
        for (String sign : commentSigns) {
            if (!line.startsWith(sign)) continue;
            return true;
        }
        return false;
    }

    private boolean isSection(String line) {
        boolean hasStart = line.startsWith(this.m_document.getSetting().getSectionBeginningSign());
        if (!hasStart) {
            return false;
        }
        int pos = line.indexOf(this.m_document.getSetting().getSectionEndingSign());
        if (pos != -1) {
            if (pos + 1 < line.length()) {
                String restString = line.substring(pos + 1).trim();
                return restString.length() == 0 || this.isComment(restString);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(String fileName) {
        if (this.m_root == null) {
            return false;
        }
        OutputStream fos = null;
        try {
            fos = new BufferedOutputStream(new FileOutputStream(fileName));
            this.saveNode(this.m_root, fos);
            fos.flush();
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }

    private boolean saveNode(IniNode node, OutputStream fos) throws Exception {
        if (node == null || fos == null) {
            return false;
        }
        String line = null;
        if (!(node.isRoot() || node instanceof IniSection && !this.m_document.getSetting().isSectionEnabled())) {
            line = node.toString() + System.getProperty("line.separator");
            fos.write(line.getBytes(Charset.defaultCharset()));
        }
        if (!(node instanceof IniElement)) {
            return true;
        }
        IniElement e = (IniElement)node;
        int count = e.getChildrenCount();
        for (int i = 0; i < count; ++i) {
            IniNode child = e.getChild(i);
            this.saveNode(child, fos);
        }
        return true;
    }

    public String getProperty(String sectionName, String propertyName) {
        IniProperty prop;
        IniSection section;
        String propertyValue = null;
        if (this.m_root != null && (section = this.m_root.getSectionByName(sectionName)) != null && (prop = section.getPropertyByName(propertyName)) != null) {
            propertyValue = prop.getValue();
        }
        return propertyValue;
    }

    public void addComment(String comment) {
        if (this.m_root != null) {
            this.m_root.addSeparator();
            this.m_root.addComment(comment);
            this.m_root.addSeparator();
        }
    }

    public boolean addProperties(String sectionName, Properties properties) {
        if (this.m_root == null) {
            return false;
        }
        IniSection section = this.m_root.getSectionByName(sectionName);
        if (section != null) {
            Enumeration<Object> e = properties.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = (String)properties.get(key);
                section.addProperty(key, val, true);
            }
        }
        return true;
    }
}

