/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.ini;

import com.sygate.scm.util.ini.IniComment;
import com.sygate.scm.util.ini.IniDocument;
import com.sygate.scm.util.ini.IniNode;
import com.sygate.scm.util.ini.IniProperty;
import com.sygate.scm.util.ini.IniSection;
import com.sygate.scm.util.ini.IniSeparator;
import java.util.ArrayList;

public abstract class IniElement
extends IniNode {
    protected ArrayList<IniNode> m_children = null;

    protected IniElement() {
    }

    public ArrayList<IniNode> getChildren() {
        return this.m_children;
    }

    public int getChildrenCount() {
        return this.m_children != null ? this.m_children.size() : 0;
    }

    public IniNode getChild(int index) {
        int count = this.getChildrenCount();
        if (index >= count) {
            return null;
        }
        return this.m_children.get(index);
    }

    public IniNode getFirstChild() {
        if (this.getChildrenCount() == 0) {
            return null;
        }
        return this.m_children.get(0);
    }

    public IniNode getLastChild() {
        int count = this.getChildrenCount();
        if (count == 0) {
            return null;
        }
        return this.m_children.get(count - 1);
    }

    public boolean addChild(IniNode child) {
        int count;
        if (child == null) {
            return false;
        }
        if (this.m_children == null) {
            this.m_children = new ArrayList();
        }
        if ((count = this.m_children.size()) == 0) {
            this.m_children.add(child);
        } else {
            IniNode lastChild = this.m_children.get(count - 1);
            lastChild.m_nextSibling = child;
            child.m_prevSibling = lastChild;
            this.m_children.add(child);
        }
        child.setParent(this);
        return true;
    }

    public boolean insertChild(int index, IniNode child) {
        if (child == null) {
            return false;
        }
        if (index < 0) {
            return false;
        }
        if (this.m_children == null) {
            if (index > 0) {
                return false;
            }
            this.m_children = new ArrayList();
            this.m_children.add(child);
            child.setParent(this);
            return true;
        }
        int count = this.m_children.size();
        if (index == count) {
            this.m_children.add(child);
            child.setParent(this);
            return true;
        }
        if (index > count) {
            return false;
        }
        IniNode node = this.m_children.get(index);
        node.m_prevSibling.m_nextSibling = child;
        child.m_prevSibling = node.m_prevSibling;
        node.m_prevSibling = child;
        child.m_nextSibling = node;
        this.m_children.add(index, child);
        child.setParent(this);
        return true;
    }

    public IniNode removeChild(int i) {
        if (this.m_children == null) {
            return null;
        }
        int count = this.m_children.size();
        if (i >= count) {
            return null;
        }
        IniNode node = this.m_children.remove(i);
        if (node == null) {
            return null;
        }
        node.m_prevSibling.m_nextSibling = node.m_nextSibling;
        node.m_nextSibling.m_prevSibling = node.m_prevSibling;
        node.setParent(null);
        node.m_prevSibling = null;
        node.m_nextSibling = null;
        return node;
    }

    public boolean removeChild(IniNode node) {
        if (this.m_children == null) {
            return false;
        }
        if (node == null) {
            return false;
        }
        boolean ret = this.m_children.remove(node);
        if (ret) {
            if (null != node.m_prevSibling) {
                node.m_prevSibling.m_nextSibling = node.m_nextSibling;
            }
            if (null != node.m_nextSibling) {
                node.m_nextSibling.m_prevSibling = node.m_prevSibling;
            }
            node.setParent(null);
            node.m_prevSibling = null;
            node.m_nextSibling = null;
        }
        return ret;
    }

    public IniProperty addProperty(String name, String value, boolean aboveSeparator) {
        IniProperty prop = this.getDocument().createProperty();
        prop.setName(name);
        prop.setValue(value);
        boolean result = false;
        if (aboveSeparator) {
            int index = this.getIndexOfLastProperty();
            result = this.insertChild(index + 1, prop);
        } else {
            result = this.addChild(prop);
        }
        return result ? prop : null;
    }

    public String[] getChildrenNames() {
        int count = this.getChildrenCount();
        String[] names = new String[count];
        for (int i = 0; i < count; ++i) {
            IniNode node = this.m_children.get(i);
            names[i] = node.getName();
        }
        return names;
    }

    public IniNode getChildByName(String name) {
        int count = this.getChildrenCount();
        if (count < 1) {
            return null;
        }
        for (int i = 0; i < count; ++i) {
            IniNode node = this.m_children.get(i);
            if (!node.getName().equals(name)) continue;
            return node;
        }
        return null;
    }

    public IniNode getChildByPath(String path) {
        ArrayList<String> listPath = IniDocument.pathToList(path, this.getDocument().getSetting().getPathSeparator());
        if (listPath == null || listPath.size() < 1) {
            return null;
        }
        IniElement parent = this;
        for (int i = 0; i < listPath.size(); ++i) {
            String name = listPath.get(i);
            IniNode node = parent.getChildByName(name);
            if (node == null) {
                return null;
            }
            if (i == listPath.size() - 1) {
                return node;
            }
            if (!(node instanceof IniElement)) {
                return null;
            }
            parent = (IniElement)node;
        }
        return null;
    }

    public IniSection getSectionByName(String name) {
        IniNode node = this.getChildByName(name);
        if (node == null || !(node instanceof IniSection)) {
            return null;
        }
        return (IniSection)node;
    }

    public IniSection getSectionByPath(String path) {
        IniNode node = this.getChildByPath(path);
        if (node == null || !(node instanceof IniSection)) {
            return null;
        }
        return (IniSection)node;
    }

    public IniProperty getPropertyByName(String name) {
        IniNode node = this.getChildByName(name);
        if (node == null || !(node instanceof IniProperty)) {
            return null;
        }
        return (IniProperty)node;
    }

    public IniProperty getPropertyByPath(String path) {
        IniNode node = this.getChildByPath(path);
        if (node == null || !(node instanceof IniProperty)) {
            return null;
        }
        return (IniProperty)node;
    }

    public ArrayList<IniSection> addSection(String path) {
        String name;
        IniSection section;
        ArrayList<String> listPath = IniDocument.pathToList(path, this.getDocument().getSetting().getPathSeparator());
        if (listPath == null || listPath.size() < 1) {
            return null;
        }
        ArrayList<IniSection> result = new ArrayList<IniSection>();
        IniElement parent = this;
        for (int i = 0; i < listPath.size() && ((section = parent.getSectionByName(name = listPath.get(i))) != null || parent.addChild(section = this.getDocument().createSection(name))); ++i) {
            parent = section;
            result.add(section);
        }
        return result;
    }

    public IniSection addSingleSection(String name) {
        IniSection section = this.getDocument().createSection(name);
        if (!this.addChild(section)) {
            return null;
        }
        return section;
    }

    public IniProperty addProperty(String sectionPath, String name, String value, boolean aboveSeparator) {
        IniElement section = this;
        if (sectionPath != null && sectionPath.length() > 0 && (section = this.getSectionByPath(sectionPath)) == null) {
            return null;
        }
        return section.addProperty(name, value, aboveSeparator);
    }

    public IniComment addComment(String comment) {
        IniComment node = this.getDocument().createComment(comment);
        if (!this.addChild(node)) {
            return null;
        }
        return node;
    }

    public IniSeparator addSeparator() {
        IniSeparator node = this.getDocument().createSeparator();
        if (!this.addChild(node)) {
            return null;
        }
        return node;
    }

    public int getIndexOfLastProperty() {
        int count = this.getChildrenCount();
        if (count < 1) {
            return -1;
        }
        for (int i = count - 1; i >= 0; --i) {
            IniNode child = this.m_children.get(i);
            if (child instanceof IniSeparator) continue;
            return i;
        }
        return -1;
    }
}

