/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.ini;

import com.sygate.scm.util.ini.IniComment;
import com.sygate.scm.util.ini.IniProperty;
import com.sygate.scm.util.ini.IniRoot;
import com.sygate.scm.util.ini.IniSection;
import com.sygate.scm.util.ini.IniSeparator;
import com.sygate.scm.util.ini.IniSetting;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class IniDocument {
    protected IniSetting m_setting = new IniSetting();

    public IniSetting getSetting() {
        return this.m_setting;
    }

    public void setSetting(IniSetting setting) {
        this.m_setting = setting;
    }

    public IniSeparator createSeparator() {
        IniSeparator node = new IniSeparator();
        node.setDocument(this);
        node.setName(this.generateNameForSeparator(node));
        node.setValue(this.m_setting.getDefaultIniSeparator());
        return node;
    }

    public String generateNameForSeparator(IniSeparator separator) {
        return "Separator" + separator.hashCode();
    }

    public IniComment createComment() {
        IniComment node = new IniComment();
        node.setDocument(this);
        node.setName(this.generateNameForComment(node));
        return node;
    }

    public IniComment createComment(String comment) {
        IniComment node = new IniComment(comment);
        node.setDocument(this);
        node.setName(this.generateNameForComment(node));
        return node;
    }

    public String generateNameForComment(IniComment comment) {
        return "Comment" + comment.hashCode();
    }

    public IniSection createSection(String name) {
        return this.createSection(name, null);
    }

    public IniSection createSection(String name, IniComment comNode) {
        IniSection node = new IniSection(name, comNode);
        node.setDocument(this);
        return node;
    }

    public IniProperty createProperty() {
        IniProperty node = new IniProperty();
        node.setDocument(this);
        return node;
    }

    public IniProperty createProperty(String name, String value, IniComment commentNode) {
        IniProperty node = new IniProperty();
        node.setName(name);
        node.setValue(value);
        node.setComment(commentNode);
        node.setDocument(this);
        return node;
    }

    public IniRoot createRoot() {
        IniRoot root = new IniRoot();
        root.setDocument(this);
        return root;
    }

    public static ArrayList<String> pathToList(String path, String pathSeparator) {
        if (path == null || path.length() < 1) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(path, pathSeparator);
        while (st.hasMoreElements()) {
            String s = (String)st.nextElement();
            list.add(s);
        }
        return list;
    }
}

