/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util.db;

import com.sygate.scm.util.StringUtilities;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class JDBCDriverHelper {
    public static final int READ_SOCKET_TIMEOUT_SEC_DEFAULT = 1800;
    public static final String MSJDBC_SOCKET_TIMEOUT_ATTR = "mssqlSocketReadTimeout";
    private static Logger logger = Logger.getLogger(JDBCDriverHelper.class.toString());

    public static boolean updateJDBCDriverToMSJDBC(Element resourceElement, boolean trustServerCert) {
        boolean result = false;
        if (resourceElement == null) {
            return result;
        }
        StringBuilder msjdbcUrl = new StringBuilder("jdbc:sqlserver");
        String driverClassName = resourceElement.getAttribute("driverClassName");
        if ("net.sourceforge.jtds.jdbc.Driver".equals(driverClassName)) {
            try {
                driverClassName = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
                resourceElement.setAttribute("driverClassName", driverClassName);
                String url = resourceElement.getAttribute("url");
                int posUptoDriverName = url.indexOf("://");
                int posUptoDbName = url.indexOf("/", posUptoDriverName + 3);
                int posUptoParams = url.indexOf(";", posUptoDbName);
                msjdbcUrl.append(url.substring(posUptoDriverName, posUptoDbName)).append(";databaseName=");
                if (posUptoParams != -1) {
                    String[] params;
                    msjdbcUrl.append(url.substring(posUptoDbName + 1, posUptoParams));
                    String paramString = url.substring(posUptoParams + 1);
                    for (String param : params = paramString.split(";")) {
                        if (param.contains("instance=")) {
                            msjdbcUrl.append(";instanceName=").append(param.substring(param.indexOf("=") + 1));
                        }
                        if (!param.contains("domain=")) continue;
                        msjdbcUrl.append(";integratedSecurity=true");
                        resourceElement.setAttribute("domain", param.substring(param.indexOf("=") + 1));
                        msjdbcUrl.append(";domain=").append(param.substring(param.indexOf("=") + 1));
                    }
                } else {
                    msjdbcUrl.append(url.substring(posUptoDbName + 1));
                }
                msjdbcUrl.append(JDBCDriverHelper.getEncryptSettingForMSJDBC(trustServerCert));
                resourceElement.setAttribute("url", msjdbcUrl.toString());
                resourceElement.setAttribute(MSJDBC_SOCKET_TIMEOUT_ATTR, Integer.toString(1800));
                result = true;
            }
            catch (Exception exc) {
                logger.log(Level.SEVERE, "Exception converting jTDS url to MS JDBC", exc);
                logger.log(Level.SEVERE, "url formed :" + msjdbcUrl.toString());
            }
        } else if ("com.microsoft.sqlserver.jdbc.SQLServerDriver".equals(driverClassName) && StringUtilities.isEmpty(resourceElement.getAttribute(MSJDBC_SOCKET_TIMEOUT_ATTR))) {
            resourceElement.setAttribute(MSJDBC_SOCKET_TIMEOUT_ATTR, Integer.toString(1800));
            result = true;
        }
        return result;
    }

    public static boolean updateJDBCURL(Element resourceElement, boolean updateSocketTimeout) throws IOException {
        boolean updated = false;
        if (resourceElement != null) {
            Object url = resourceElement.getAttribute("url");
            if (StringUtilities.isEmpty((String)url)) {
                throw new IOException("ROOT.xml was corrupted. No 'url' attribute in Resource.");
            }
            String urlLowerCase = ((String)url).toLowerCase();
            if (urlLowerCase.startsWith("jdbc:jtds:sqlserver:") && urlLowerCase.indexOf(";socketkeepalive") < 0) {
                url = (String)url + ";socketkeepalive=true";
                resourceElement.setAttribute("url", (String)url);
                logger.log(Level.INFO, "updateJDBCURL>> added socketKeepALive to url. url = " + (String)url);
                updated = true;
            } else if (urlLowerCase.startsWith("jdbc:sqlanywhere:") && urlLowerCase.indexOf(";TO=60".toLowerCase()) < 0) {
                url = ((String)url).replace(";host=127.0.0.1;port=", ";TO=60;host=127.0.0.1;port=");
                resourceElement.setAttribute("url", (String)url);
                logger.log(Level.INFO, "JDBCDriverHelper> updateJDBCURL>> Added timeout to url. url = " + (String)url);
                updated = true;
            }
            if (urlLowerCase.startsWith("jdbc:jtds:sqlserver:")) {
                if (urlLowerCase.indexOf(";socketTimeout".toLowerCase()) < 0) {
                    url = (String)url + ";socketTimeout=720";
                    resourceElement.setAttribute("url", (String)url);
                    logger.log(Level.INFO, "updateJDBCURL>> added socketTimeout to url. url = " + (String)url);
                    updated = true;
                } else if (updateSocketTimeout) {
                    String oldSocketTimeoutString = ";socketTimeout=1800";
                    if (((String)url).indexOf(oldSocketTimeoutString) > -1) {
                        logger.log(Level.INFO, "updateJDBCURL>> Current url = " + (String)url);
                        url = ((String)url).replace(oldSocketTimeoutString, ";socketTimeout=720");
                        resourceElement.setAttribute("url", (String)url);
                        logger.log(Level.INFO, "updateJDBCURL>> updated socket Timeout. Updated url = " + (String)url);
                        updated = true;
                    }
                } else {
                    logger.log(Level.INFO, "updateJDBCURL>> Not updating as long query timeout has changed");
                }
            }
        } else {
            throw new IOException("ROOT.xml was corrupted. No Resource element!");
        }
        return updated;
    }

    public static boolean getIsMSJDBCDriver() {
        return Boolean.getBoolean("msjdbc");
    }

    public static void setMSJDBCDriver() {
        System.setProperty("msjdbc", "true");
    }

    public static String getDriverClassForSQLServer(boolean isMSJDBCDriver) {
        if (isMSJDBCDriver) {
            return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        }
        return "net.sourceforge.jtds.jdbc.Driver";
    }

    public static String getEncryptSettingForMSJDBC(boolean trustServerCert) {
        return ";encrypt=true;trustServerCertificate=" + String.valueOf(trustServerCert);
    }

    public static String getDomainString(String dbDomain) {
        if (!StringUtilities.isEmpty(dbDomain)) {
            return ";domain=" + dbDomain;
        }
        return "";
    }

    public static String getValueForParam(String url, String param) {
        String[] valuePairs;
        if (JDBCDriverHelper.isEmpty(url) || JDBCDriverHelper.isEmpty(param)) {
            return null;
        }
        int index = url.indexOf(";");
        if (index < 0) {
            return null;
        }
        if (index == url.length() - 1) {
            return null;
        }
        String result = null;
        String parameterString = url.substring(index);
        for (String valuePair : valuePairs = parameterString.split(";")) {
            String parameterName;
            if (JDBCDriverHelper.isEmpty(valuePair) || (index = valuePair.indexOf("=")) < 0 || index == valuePair.length() - 1 || JDBCDriverHelper.isEmpty(parameterName = valuePair.substring(0, index)) || !parameterName.trim().equalsIgnoreCase(param.trim())) continue;
            result = valuePair.substring(index + 1);
            break;
        }
        return result;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() <= 0;
    }

    public static boolean isIntegratedLogin(String url, String domain, String msjdbcUrlPrefix) {
        boolean result = false;
        if (!JDBCDriverHelper.isEmpty(url) && url.contains(msjdbcUrlPrefix)) {
            boolean isIntSecOn;
            String strIntSec = JDBCDriverHelper.getValueForParam(url, "integratedSecurity");
            boolean bl = isIntSecOn = strIntSec == null ? false : Boolean.valueOf(strIntSec);
            if (isIntSecOn && !JDBCDriverHelper.isEmpty(domain)) {
                return result;
            }
            String domainNameInUrl = JDBCDriverHelper.getValueForParam(url, "domain");
            if (!JDBCDriverHelper.isEmpty(domainNameInUrl)) {
                result = true;
            }
        }
        return result;
    }

    public static boolean setEncryptInJDBCDriverUrl(Element resourceElement, boolean encryptValue) {
        boolean result = false;
        if (resourceElement == null) {
            return result;
        }
        String driverClassName = resourceElement.getAttribute("driverClassName");
        if (!"com.microsoft.sqlserver.jdbc.SQLServerDriver".equals(driverClassName)) {
            return result;
        }
        String url = resourceElement.getAttribute("url");
        String targetUrl = JDBCDriverHelper.replaceEncryptValueInJDBCUrl(url, encryptValue);
        resourceElement.setAttribute("url", targetUrl);
        result = true;
        return result;
    }

    public static String replaceEncryptValueInJDBCUrl(String url, boolean encryptValue) {
        StringBuilder targetUrl = new StringBuilder("");
        if (StringUtilities.isEmpty(url)) {
            return targetUrl.toString();
        }
        String[] params = url.split(";");
        String param = null;
        for (int idx = 0; idx < params.length; ++idx) {
            param = params[idx];
            if (param.contains("encrypt=")) {
                targetUrl.append("encrypt=").append(Boolean.valueOf(encryptValue).toString().toLowerCase());
            } else if (!StringUtilities.isEmpty(param)) {
                targetUrl.append(param);
            }
            if (idx == params.length - 1) continue;
            targetUrl.append(";");
        }
        return targetUrl.toString();
    }
}

