/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.RunCommandHandler;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.ZipInputStreamProxy;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class ZipUtil {
    private static final int BUFFER_SIZE = 262144;
    public static final char METHOD_ARCHIVE = 'a';
    public static final char METHOD_DELETE = 'd';
    public static final char METHOD_REPLACE = 'r';
    public static final char METHOD_EXTRACT = 'e';
    private static final String FILE_TYPE_FILE = "file";
    private static final String FILE_TYPE_DIRECTORY = "folder";
    public static final String PT_NAME = "SEPMPackageTool.exe";
    public static final int MIN_COMPRESS_LEVEL = 0;
    public static final int MAX_COMPRESS_LEVEL = 9;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addFilesToZip(int compressionLevel, String zipFilePath, ArrayList<String> listFiles) throws IOException {
        if (listFiles == null || listFiles.size() < 1) {
            return true;
        }
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        ZipOutputStream zos = null;
        try {
            fos = new FileOutputStream(zipFilePath);
            bos = new BufferedOutputStream(fos, 262144);
            zos = new ZipOutputStream(bos);
            if (compressionLevel > -1) {
                zos.setLevel(compressionLevel);
            }
            for (String file : listFiles) {
                File fileNew = new File(file);
                ZipUtil.zipFiles(fileNew, fileNew.getParent(), zos, false);
            }
            zos.finish();
        }
        catch (Throwable throwable) {
            IOUtilities.closeOutputStream(zos);
            IOUtilities.closeOutputStream(bos);
            IOUtilities.closeOutputStream(fos);
            throw throwable;
        }
        IOUtilities.closeOutputStream(zos);
        IOUtilities.closeOutputStream(bos);
        IOUtilities.closeOutputStream(fos);
        return true;
    }

    private static boolean checkFile(String path, String type) {
        File aFile;
        if (path != null && (aFile = new File(path)) != null && aFile.exists()) {
            boolean is_dir = aFile.isDirectory();
            return type.equalsIgnoreCase(FILE_TYPE_FILE) && !is_dir || type.equalsIgnoreCase(FILE_TYPE_DIRECTORY) && is_dir;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFilesToExistingZip(File zipFile, ArrayList<String> files) throws IOException {
        ZipInputStream zin = null;
        ZipOutputStream zout = null;
        File tempFile = null;
        try {
            boolean renameOk;
            tempFile = File.createTempFile(zipFile.getName(), null);
            if (!tempFile.delete()) {
                System.out.println("could not delete temp file:" + tempFile.getCanonicalPath());
            }
            if (!(renameOk = zipFile.renameTo(tempFile))) {
                throw new RuntimeException("could not rename the file " + zipFile.getAbsolutePath() + " to " + tempFile.getAbsolutePath());
            }
            byte[] buf = new byte[1024];
            zin = new ZipInputStream(new FileInputStream(tempFile));
            zout = new ZipOutputStream(new FileOutputStream(zipFile));
            ZipEntry entry = zin.getNextEntry();
            while (entry != null) {
                int len;
                String name = entry.getName();
                zout.putNextEntry(new ZipEntry(name));
                while ((len = zin.read(buf)) > 0) {
                    zout.write(buf, 0, len);
                }
                entry = zin.getNextEntry();
            }
            zin.close();
            for (String file : files) {
                File fileNew = new File(file);
                System.out.println(Utility.getPerformanceLog(file, file + " added to zip", true));
                ZipUtil.zipFiles(fileNew, fileNew.getParent(), zout, false);
                System.out.println(Utility.getPerformanceLog(file, file + " added to zip", false));
            }
        }
        catch (Throwable throwable) {
            IOUtilities.closeOutputStream(zout);
            IOUtilities.closeInputStream(zin);
            if (tempFile != null && !tempFile.delete()) {
                System.out.println("could not delete temp file:" + tempFile.getCanonicalPath());
            }
            throw throwable;
        }
        IOUtilities.closeOutputStream(zout);
        IOUtilities.closeInputStream(zin);
        if (tempFile != null && !tempFile.delete()) {
            System.out.println("could not delete temp file:" + tempFile.getCanonicalPath());
        }
    }

    public static boolean runBT(char method, String src_package, String working_folder, String output_folder, String[] file_filter, String ptEXEFile, StringBuffer toolLogs) throws Exception {
        if (src_package != null) {
            switch (method) {
                case 'a': {
                    if (!ZipUtil.checkFile(working_folder, FILE_TYPE_DIRECTORY)) break;
                    return ZipUtil.executePT(method, src_package, working_folder, output_folder, file_filter, ptEXEFile, toolLogs);
                }
                case 'd': {
                    if (!ZipUtil.checkFile(output_folder, FILE_TYPE_DIRECTORY)) break;
                    return ZipUtil.executePT(method, src_package, working_folder, output_folder, file_filter, ptEXEFile, toolLogs);
                }
                case 'e': {
                    if (!ZipUtil.checkFile(output_folder, FILE_TYPE_DIRECTORY)) break;
                    return ZipUtil.executePT(method, src_package, working_folder, output_folder, file_filter, ptEXEFile, toolLogs);
                }
                case 'r': {
                    if (!ZipUtil.checkFile(working_folder, FILE_TYPE_DIRECTORY) || !ZipUtil.checkFile(output_folder, FILE_TYPE_DIRECTORY)) break;
                    return ZipUtil.executePT(method, src_package, working_folder, output_folder, file_filter, ptEXEFile, toolLogs);
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean executePT(char method, String src_package, String working_folder, String output_folder, String[] file_filter, String ptEXEFile, StringBuffer toolLogs) throws Exception {
        if (ptEXEFile != null) {
            boolean bl;
            ArrayList<Object> cmdList = new ArrayList<Object>();
            cmdList.add("\"" + ptEXEFile + "\"");
            File tempF = new File(src_package);
            src_package = tempF.getCanonicalPath();
            cmdList.add("\"" + method + "!" + src_package + "\"");
            if (working_folder != null) {
                tempF = new File(working_folder);
                working_folder = tempF.getCanonicalPath();
                cmdList.add("-w");
                cmdList.add("\"" + working_folder + "\"");
            }
            if (output_folder != null) {
                tempF = new File(output_folder);
                output_folder = tempF.getCanonicalPath();
                cmdList.add("-o");
                cmdList.add("\"" + output_folder + "\"");
            }
            if (file_filter != null) {
                cmdList.add("-f");
                for (String s : file_filter) {
                    cmdList.add("\"" + s + "\"");
                }
            }
            Process process = null;
            String[] cmdArr = (String[])cmdList.toArray(String[]::new);
            process = RunCommandHandler.getInstance().getProcess(cmdArr);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.defaultCharset()));
            try {
                String line;
                toolLogs.append(System.getProperty("line.separator"));
                toolLogs.append("Begin:: Logs from SEPM Package Tool, time :: ");
                toolLogs.append(System.currentTimeMillis());
                toolLogs.append(System.getProperty("line.separator"));
                while ((line = reader.readLine()) != null) {
                    toolLogs.append(line);
                }
                toolLogs.append(System.getProperty("line.separator"));
                toolLogs.append("End:: Logs from SEPM Package Tool, time :: ");
                toolLogs.append(System.currentTimeMillis());
                toolLogs.append(System.getProperty("line.separator"));
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LoggerUtilities.logException(e);
                        throw e;
                    }
                }
                catch (Throwable throwable3) {
                    RunCommandHandler.getInstance().closeProcess(process);
                    throw throwable3;
                }
            }
            reader.close();
            RunCommandHandler.getInstance().closeProcess(process);
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extractFileFromJAR(String fileJar, String source, String dest) {
        try {
            JarFile jar = new JarFile(fileJar);
            ZipEntry entry = jar.getEntry(source);
            if (entry == null) {
                jar.close();
                return null;
            }
            File fe = new File(entry.getName());
            File efile = new File(dest, fe.getName());
            BufferedInputStream in = null;
            BufferedOutputStream out = null;
            try {
                int nBytes;
                in = new BufferedInputStream(jar.getInputStream(entry));
                out = new BufferedOutputStream(new FileOutputStream(efile));
                byte[] buffer = new byte[262144];
                while ((nBytes = ((InputStream)in).read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, nBytes);
                }
                ((OutputStream)out).flush();
            }
            catch (Throwable throwable) {
                IOUtilities.closeOutputStream(out);
                IOUtilities.closeInputStream(in);
                jar.close();
                throw throwable;
            }
            IOUtilities.closeOutputStream(out);
            IOUtilities.closeInputStream(in);
            jar.close();
            return efile.getAbsolutePath();
        }
        catch (Throwable e) {
            LoggerUtilities.logException(e);
            return null;
        }
    }

    public static boolean unzipFile(String zipFile, String destinationFolder) throws IOException {
        return ZipUtil.unzipFile(new File(zipFile), destinationFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unzipFile(File zipFile, String destinationFolder) throws IOException {
        BufferedInputStream bis;
        FileInputStream fis;
        block6: {
            boolean bl;
            if (zipFile == null || destinationFolder == null || !zipFile.exists()) {
                System.out.println("ZipUtil >> unzipFile > error: a parameter is null or specified file doesn't exist");
                return false;
            }
            System.out.println("ZipUtil >> unzipFile > zipFile=" + zipFile + " destinationFolder=" + destinationFolder);
            File dest = new File(destinationFolder);
            if (!dest.exists() && !dest.mkdirs()) {
                System.out.println("ZipUtil >> unzipFile > unable to create destination folder:" + destinationFolder);
                return false;
            }
            if (!dest.isDirectory()) {
                System.out.println("ZipUtil >> unzipFile > destination folder is not a directory!");
                return false;
            }
            fis = null;
            bis = null;
            try {
                fis = new FileInputStream(zipFile.getAbsoluteFile());
                bis = new BufferedInputStream(fis, 262144);
                if (!ZipUtil.unzipFromInputStream(bis, destinationFolder)) break block6;
                bl = true;
            }
            catch (Throwable throwable) {
                IOUtilities.closeInputStream(bis);
                IOUtilities.closeInputStream(fis);
                throw throwable;
            }
            IOUtilities.closeInputStream(bis);
            IOUtilities.closeInputStream(fis);
            return bl;
        }
        System.out.println("Error occur when unzipping " + zipFile.getName() + ", will try another way to unzip it");
        IOUtilities.closeInputStream(bis);
        IOUtilities.closeInputStream(fis);
        fis = new FileInputStream(zipFile.getAbsoluteFile());
        bis = new BufferedInputStream(fis, 262144);
        boolean bl = ZipUtil.unzipFromInputStream(bis, destinationFolder, 1);
        IOUtilities.closeInputStream(bis);
        IOUtilities.closeInputStream(fis);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unzipBytes(byte[] zipBytes, String destinationExistingFolder) {
        BufferedInputStream bis;
        ByteArrayInputStream fis;
        boolean result;
        block4: {
            if (zipBytes == null || zipBytes.length < 1) {
                return false;
            }
            result = false;
            fis = null;
            bis = null;
            try {
                fis = new ByteArrayInputStream(zipBytes);
                bis = new BufferedInputStream(fis);
                if (ZipUtil.unzipFromInputStream(bis, destinationExistingFolder)) {
                    result = true;
                    break block4;
                }
                System.out.println("Error occur when unzipping, will try another way to unzip it");
                IOUtilities.closeInputStream(bis);
                IOUtilities.closeInputStream(fis);
                fis = new ByteArrayInputStream(zipBytes);
                bis = new BufferedInputStream(fis, 262144);
                result = ZipUtil.unzipFromInputStream(bis, destinationExistingFolder, 1);
            }
            catch (Throwable throwable) {
                IOUtilities.closeInputStream(bis);
                IOUtilities.closeInputStream(fis);
                throw throwable;
            }
        }
        IOUtilities.closeInputStream(bis);
        IOUtilities.closeInputStream(fis);
        return result;
    }

    public static boolean unzipFromInputStream(InputStream is, String destinationExistingFolder) {
        return ZipUtil.unzipFromInputStream(is, destinationExistingFolder, 0);
    }

    public static boolean unzipFromInputStream(InputStream is, String destinationExistingFolder, int unzipType) {
        boolean result = false;
        try (ZipInputStreamProxy zis = new ZipInputStreamProxy(unzipType, is);){
            result = ZipUtil.unzipFromInputStream(zis, destinationExistingFolder);
        }
        catch (Exception e) {
            LoggerUtilities.logException(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean unzipFromInputStream(ZipInputStreamProxy zis, String destinationExistingFolder) {
        if (zis == null) {
            return false;
        }
        boolean result = true;
        try {
            ZipEntry entry = null;
            int numFilesExtracted = 0;
            File destinationAsFile = new File(destinationExistingFolder);
            while ((entry = zis.getNextEntry()) != null) {
                block15: {
                    FileOutputStream fos;
                    BufferedOutputStream bos;
                    String name = entry.getName();
                    String newFilePath = destinationExistingFolder + File.separator + name;
                    File newFile = new File(newFilePath);
                    if (!newFile.getCanonicalPath().toLowerCase().startsWith(destinationAsFile.getCanonicalPath().toLowerCase())) {
                        System.out.println("Error: File " + name + " has a path that falls outside the intended destination folder.");
                        return false;
                    }
                    if (entry.isDirectory()) {
                        File dir = new File(destinationExistingFolder + File.separator + name);
                        if (!dir.exists() && !dir.mkdirs()) {
                            System.out.println("Fail to create the folder " + destinationExistingFolder + File.separator + name);
                        }
                    } else {
                        int count;
                        String newFolderName;
                        File newFolder;
                        int seperatorIndex = name.lastIndexOf(File.separator);
                        if (seperatorIndex == -1 && (seperatorIndex = name.lastIndexOf("/")) == -1) {
                            seperatorIndex = name.lastIndexOf("\\");
                        }
                        if (seperatorIndex != -1 && !(newFolder = new File(destinationExistingFolder, newFolderName = name.substring(0, seperatorIndex))).exists() && !newFolder.mkdirs()) {
                            System.out.println("Fail to create the folder " + newFolderName);
                        }
                        byte[] data = new byte[262144];
                        bos = null;
                        fos = null;
                        fos = new FileOutputStream(newFilePath);
                        bos = new BufferedOutputStream(fos, 262144);
                        while ((count = zis.read(data, 0, 262144)) != -1) {
                            bos.write(data, 0, count);
                        }
                        bos.flush();
                        IOUtilities.closeOutputStream(bos);
                        IOUtilities.closeOutputStream(fos);
                    }
                    break block15;
                    catch (Throwable ex) {
                        boolean bl;
                        try {
                            result = false;
                            LoggerUtilities.logException(ex);
                            bl = false;
                        }
                        catch (Throwable throwable) {
                            IOUtilities.closeOutputStream(bos);
                            IOUtilities.closeOutputStream(fos);
                            throw throwable;
                        }
                        IOUtilities.closeOutputStream(bos);
                        IOUtilities.closeOutputStream(fos);
                        return bl;
                    }
                }
                ++numFilesExtracted;
            }
            if (numFilesExtracted <= 0) return false;
            return true;
        }
        catch (Throwable ex) {
            result = false;
            LoggerUtilities.logException(ex);
        }
        return result;
    }

    public static String zipData(int compressionLevel, String folderName) throws IOException {
        return ZipUtil.zipData(compressionLevel, folderName, false);
    }

    protected static String zipData(int compressionLevel, String folderName, boolean sortByFileName) throws IOException {
        File file = new File(folderName);
        String zipFileName = file.getAbsolutePath() + ".zip";
        ZipUtil.zipData(compressionLevel, folderName, zipFileName, sortByFileName);
        return zipFileName;
    }

    public static boolean zipData(int compressionLevel, String folderName, String zipFileName) throws IOException {
        return ZipUtil.zipData(compressionLevel, folderName, zipFileName, false);
    }

    public static boolean zipSortData(String folderName, String zipFileName) throws IOException {
        return ZipUtil.zipData(-1, folderName, zipFileName, true);
    }

    public static boolean zipData(String folderName, String zipFileName) throws IOException {
        return ZipUtil.zipData(-1, folderName, zipFileName, false);
    }

    public static boolean zipData(int compressionLevel, String folderName, String zipFileName, boolean sortByFileName) throws IOException {
        return ZipUtil.zipData(compressionLevel, folderName, zipFileName, sortByFileName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zipData(int compressionLevel, String folderName, String zipFileName, boolean sortByFileName, boolean forceLinuxSlash) throws IOException {
        File file = new File(folderName);
        if (!file.exists()) {
            return false;
        }
        if (!file.isDirectory()) {
            return false;
        }
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        ZipOutputStream zos = null;
        boolean result = false;
        try {
            fos = new FileOutputStream(zipFileName);
            bos = new BufferedOutputStream(fos, 262144);
            zos = new ZipOutputStream((OutputStream)bos, Charset.defaultCharset());
            if (compressionLevel > -1) {
                zos.setLevel(compressionLevel);
            }
            ZipUtil.zipFiles(file, folderName, zos, sortByFileName, forceLinuxSlash);
            zos.finish();
            result = true;
        }
        catch (Throwable throwable) {
            IOUtilities.closeOutputStream(zos);
            IOUtilities.closeOutputStream(bos);
            IOUtilities.closeOutputStream(fos);
            throw throwable;
        }
        IOUtilities.closeOutputStream(zos);
        IOUtilities.closeOutputStream(bos);
        IOUtilities.closeOutputStream(fos);
        return result;
    }

    public static boolean zipFile(int compressionLevel, String filePath, String folderName, String zipFilePath) throws IOException {
        return ZipUtil.zipFile(compressionLevel, filePath, folderName, zipFilePath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean zipFile(int compressionLevel, String filePath, String folderName, String zipFilePath, boolean sortByFileName) throws IOException {
        File file = new File(filePath);
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            return false;
        }
        boolean result = false;
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        ZipOutputStream zos = null;
        try {
            fos = new FileOutputStream(zipFilePath);
            bos = new BufferedOutputStream(fos, 262144);
            zos = new ZipOutputStream((OutputStream)bos, Charset.defaultCharset());
            if (compressionLevel > -1) {
                zos.setLevel(compressionLevel);
            }
            ZipUtil.zipFiles(file, folderName, zos, sortByFileName);
            zos.finish();
            result = true;
        }
        catch (Throwable throwable) {
            IOUtilities.closeOutputStream(zos);
            IOUtilities.closeOutputStream(bos);
            IOUtilities.closeOutputStream(fos);
            throw throwable;
        }
        IOUtilities.closeOutputStream(zos);
        IOUtilities.closeOutputStream(bos);
        IOUtilities.closeOutputStream(fos);
        return result;
    }

    public static void zipFiles(File file, String folderToZip, ZipOutputStream zos) throws IOException {
        ZipUtil.zipFiles(file, folderToZip, zos, false);
    }

    protected static void zipFiles(File file, String folderToZip, ZipOutputStream zos, boolean sortByFileName) throws IOException {
        ZipUtil.zipFiles(file, folderToZip, zos, sortByFileName, false);
    }

    protected static void zipFiles(File file, String folderToZip, ZipOutputStream zos, boolean sortByFileName, boolean forceLinuxSlash) throws IOException {
        if (file.isDirectory()) {
            String[] fileList = file.list();
            if (fileList != null && fileList.length > 0) {
                for (String f : fileList) {
                    ZipUtil.zipFiles(new File(file, f), folderToZip, zos, sortByFileName, forceLinuxSlash);
                }
            }
        } else {
            byte[] data = new byte[262144];
            String absolutePath = file.getAbsolutePath();
            String zipEntryName = absolutePath.substring(folderToZip.length() + 1, absolutePath.length());
            if (forceLinuxSlash) {
                zipEntryName = zipEntryName.replace(System.getProperty("file.separator").charAt(0), '/');
            }
            try (FileInputStream fis = new FileInputStream(file);
                 BufferedInputStream bis = new BufferedInputStream(fis, 262144);){
                int count;
                ZipEntry zipEntry = new ZipEntry(zipEntryName);
                zos.putNextEntry(zipEntry);
                while ((count = bis.read(data, 0, 262144)) != -1) {
                    zos.write(data, 0, count);
                }
                zos.closeEntry();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zipData(int compressionLevel, String[] fileNames, String folderName, String zipFileName, boolean sortByFileName) throws IOException {
        File[] files = new File[fileNames.length];
        int j = 0;
        for (int i = 0; i < fileNames.length; ++i) {
            File file = new File(fileNames[i]);
            if (!file.exists()) continue;
            files[j++] = file;
        }
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        ZipOutputStream zos = null;
        boolean result = false;
        try {
            fos = new FileOutputStream(zipFileName);
            bos = new BufferedOutputStream(fos, 262144);
            zos = new ZipOutputStream((OutputStream)bos, Charset.defaultCharset());
            if (compressionLevel > -1) {
                zos.setLevel(compressionLevel);
            }
            ZipUtil.zipFiles(files, folderName, zos, sortByFileName);
            zos.finish();
            result = true;
        }
        catch (Throwable throwable) {
            IOUtilities.closeOutputStream(zos);
            IOUtilities.closeOutputStream(bos);
            IOUtilities.closeOutputStream(fos);
            throw throwable;
        }
        IOUtilities.closeOutputStream(zos);
        IOUtilities.closeOutputStream(bos);
        IOUtilities.closeOutputStream(fos);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void zipFiles(File[] files, String folderToZip, ZipOutputStream zos, boolean sortByFileName) throws IOException {
        for (File file : files) {
            if (file.isDirectory()) {
                if (!sortByFileName) {
                    File[] fileList = file.listFiles();
                    if (fileList == null) continue;
                    for (File f : fileList) {
                        ZipUtil.zipFiles(f, folderToZip, zos, sortByFileName);
                    }
                    continue;
                }
                TreeMap<String, File> map = new TreeMap<String, File>();
                File[] fileList = file.listFiles();
                if (fileList != null) {
                    for (File f : fileList) {
                        map.put(f.getName(), f);
                    }
                }
                for (File f : map.values()) {
                    ZipUtil.zipFiles(f, folderToZip, zos, sortByFileName);
                }
                continue;
            }
            FileInputStream fis = null;
            BufferedInputStream bis = null;
            byte[] data = new byte[262144];
            try {
                int count;
                String zipEntryName = file.getName();
                fis = new FileInputStream(file);
                bis = new BufferedInputStream(fis, 262144);
                ZipEntry zipEntry = new ZipEntry(zipEntryName);
                zos.putNextEntry(zipEntry);
                while ((count = bis.read(data, 0, 262144)) != -1) {
                    zos.write(data, 0, count);
                }
                zos.closeEntry();
            }
            catch (Throwable throwable) {
                IOUtilities.closeInputStream(bis);
                IOUtilities.closeInputStream(fis);
                throw throwable;
            }
            IOUtilities.closeInputStream(bis);
            IOUtilities.closeInputStream(fis);
        }
    }

    public static boolean deleteFolder(String folderName) {
        File folderToDelete = new File(folderName);
        if (folderToDelete.exists()) {
            String[] filesOrFolders = folderToDelete.list();
            if (filesOrFolders != null) {
                for (int i = 0; i < filesOrFolders.length; ++i) {
                    File thisFile = new File(folderName, filesOrFolders[i]);
                    if (thisFile.isDirectory()) {
                        ZipUtil.deleteFolder(folderName + System.getProperty("file.separator") + filesOrFolders[i]);
                        continue;
                    }
                    Utility.delete(thisFile);
                }
            }
            return folderToDelete.delete();
        }
        return true;
    }

    public static InputStream getUnZippedInputstream(ZipInputStream zis) throws IOException {
        byte[] buff = new byte[262144];
        int count = 0;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        while ((count = zis.read(buff, 0, 262144)) != -1) {
            outStream.write(buff, 0, count);
        }
        outStream.close();
        return new ByteArrayInputStream(outStream.toByteArray());
    }

    public static boolean zipFileWithPermission(String folderToZip, String zipFileName, Map<String, Integer> fileNameAndPermission) throws Exception {
        try (FileOutputStream fos = new FileOutputStream(zipFileName);
             BufferedOutputStream bos = new BufferedOutputStream(fos, 262144);
             ZipArchiveOutputStream zos = new ZipArchiveOutputStream((OutputStream)bos);){
            File dir = new File(folderToZip);
            ZipUtil.zipFileWithPermission(dir, zos, "", fileNameAndPermission);
        }
        return true;
    }

    private static boolean zipFileWithPermission(File folderToZip, ZipArchiveOutputStream zos, String prefix, Map<String, Integer> fileNameAndPermission) throws Exception {
        for (File file : folderToZip.listFiles()) {
            if (file.isDirectory()) {
                ZipUtil.zipFileWithPermission(file, zos, prefix + file.getName() + File.separator, fileNameAndPermission);
                continue;
            }
            ZipArchiveEntry entry = new ZipArchiveEntry(prefix + file.getName());
            if (fileNameAndPermission.containsKey(file.getName())) {
                int permission = fileNameAndPermission.get(file.getName());
                entry.setUnixMode(permission);
                System.out.println("ZipUtil.zipFileWithPermission(): set EXE permission to: " + entry.getName());
            }
            zos.putArchiveEntry(entry);
            FileInputStream fis = new FileInputStream(file);
            IOUtils.copy((InputStream)fis, (OutputStream)zos);
            fis.close();
            zos.closeArchiveEntry();
        }
        return true;
    }
}

