/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;

public class ZipInputStreamProxy
extends InputStream {
    private static final int ZIP_INPUT_STREAM_BY_JAVA = 0;
    private static final int ZIP_INPUT_STREAM_BY_APACHE = 1;
    public static final int ZIP_INPUT_STREAM_DEFAULT = 0;
    public static final int ZIP_INPUT_STREAM_EXCEPTION = 1;
    InputStream zis = null;

    public ZipInputStreamProxy(InputStream is) {
        this(0, is);
    }

    public ZipInputStreamProxy(int zipInputStreamType, InputStream is) {
        if (is == null) {
            throw new IllegalArgumentException("inputstream closed");
        }
        switch (zipInputStreamType) {
            case 0: {
                this.zis = new ZipInputStream(is);
                break;
            }
            case 1: {
                this.zis = new ZipArchiveInputStream(is);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal zip inputstream type");
            }
        }
    }

    public ZipEntry getNextEntry() throws IOException {
        if (this.zis == null) {
            throw new IOException("Zip stream closed");
        }
        if (this.zis instanceof ZipInputStream) {
            return ((ZipInputStream)this.zis).getNextEntry();
        }
        if (this.zis instanceof ZipArchiveInputStream) {
            return ((ZipArchiveInputStream)this.zis).getNextZipEntry();
        }
        return null;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.zis == null) {
            throw new IOException("Zip stream closed");
        }
        return this.zis.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.zis != null) {
            this.zis.close();
        }
    }

    @Override
    public int read() throws IOException {
        if (this.zis == null) {
            throw new IOException("Zip stream closed");
        }
        return this.zis.read();
    }
}

