/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.XmlUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlParser {
    private static Logger logger = Logger.getLogger(XmlParser.class.getName());
    Document document = null;
    DocumentBuilder builder = XmlParser.getDocumentBuilder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean readXmlFile(String fileName) {
        boolean bl;
        logger.log(Level.INFO, "readXmlFile >> fileName: {0}", fileName);
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            fis = new FileInputStream(fileName);
            bis = new BufferedInputStream(fis);
            this.document = this.builder.parse(bis);
            bl = this.document != null;
        }
        catch (IOException | SAXException exc) {
            try {
                logger.log(Level.WARNING, "readXmlFile >> Failed to read with error: {0}", exc.getMessage());
            }
            catch (Throwable throwable) {
                IOUtilities.closeInputStream(fis);
                IOUtilities.closeInputStream(bis);
                throw throwable;
            }
            IOUtilities.closeInputStream(fis);
            IOUtilities.closeInputStream(bis);
            return false;
        }
        IOUtilities.closeInputStream(fis);
        IOUtilities.closeInputStream(bis);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean readXmlByets(byte[] data) {
        boolean bl;
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(data);
            this.document = this.builder.parse(bais);
            bl = this.document != null;
        }
        catch (Exception e) {
            try {
                LoggerUtilities.logException(e);
            }
            catch (Throwable throwable) {
                IOUtilities.closeInputStream(bais);
                throw throwable;
            }
            IOUtilities.closeInputStream(bais);
            return false;
        }
        IOUtilities.closeInputStream(bais);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveXml(String fileName) {
        boolean result = false;
        BufferedOutputStream fos = null;
        try {
            fos = new BufferedOutputStream(new FileOutputStream(fileName));
            result = this.writeXml(fos);
            ((OutputStream)fos).flush();
            IOUtilities.closeOutputStream(fos);
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
        }
        finally {
            IOUtilities.closeOutputStream(fos);
        }
        return result;
    }

    public boolean writeXml(OutputStream os) {
        try {
            XMLHelper.serialize(this.document, os);
            return true;
        }
        catch (Exception ex) {
            LoggerUtilities.logException(ex);
            return false;
        }
    }

    public Document newDocument() {
        this.document = this.builder.newDocument();
        return this.document;
    }

    public Document getDocument() {
        return this.document;
    }

    public Element getRootElement() {
        return this.document.getDocumentElement();
    }

    public final Element getElementByPath(ArrayList<String> listPath) {
        return XmlParser.getElementByPath(listPath, this.document);
    }

    static final DocumentBuilder getDocumentBuilder() {
        try {
            return XmlUtils.getSecureDocumentBuilder();
        }
        catch (Exception e) {
            LoggerUtilities.logException(e);
            return null;
        }
    }

    public static Element getNextElement(Element currentElement, boolean searchSibling) {
        Node node;
        Node node2 = node = searchSibling ? currentElement.getNextSibling() : currentElement.getFirstChild();
        while (!(node instanceof Element) && node != null) {
            node = node.getNextSibling();
        }
        return node != null ? (Element)node : null;
    }

    public static final Element getElementByPath(ArrayList<String> listPath, Document doc) {
        Element e = doc.getDocumentElement();
        if (e == null) {
            return null;
        }
        if (e.getNodeName().equals(listPath.get(0))) {
            listPath.remove(0);
        }
        if (listPath.size() < 1) {
            return e;
        }
        return XmlParser.getChildElementByPath(listPath, e);
    }

    public static final Element getChildElementByPath(ArrayList<String> listPath, Element parentElement) {
        if (parentElement == null) {
            return null;
        }
        if (listPath == null || listPath.size() < 1) {
            return null;
        }
        Element e = parentElement;
        for (int i = 0; i < listPath.size() && (e = XmlParser.getNextElement(e, false)) != null; ++i) {
            String path = listPath.get(i);
            boolean found = false;
            while (e != null) {
                if (e.getNodeName().equals(path)) {
                    found = true;
                    break;
                }
                e = XmlParser.getNextElement(e, true);
            }
            if (found) continue;
            e = null;
            break;
        }
        return e;
    }

    public static final ArrayList<Element> getChildElementsByPath(ArrayList<String> listPath, Element parentElement) {
        ArrayList<Element> elements = new ArrayList<Element>(2);
        if (parentElement == null) {
            return null;
        }
        if (listPath == null || listPath.size() < 1) {
            return null;
        }
        Element e = parentElement;
        for (int i = 0; i < listPath.size() && (e = XmlParser.getNextElement(e, false)) != null; ++i) {
            String path = listPath.get(i);
            while (e != null) {
                if (e.getNodeName().equals(path)) {
                    elements.add(e);
                }
                e = XmlParser.getNextElement(e, true);
            }
        }
        return elements;
    }

    public static final Element getFirstChildElement(Element e, String nodeName) {
        NodeList nl = e.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase(nodeName)) continue;
            return (Element)node;
        }
        return null;
    }

    public static final Element getNextMatchingSibling(Node e, String nodeName) {
        if (e == null) {
            return null;
        }
        Node node = e.getNextSibling();
        if (node != null && node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase(nodeName)) {
            return (Element)node;
        }
        return XmlParser.getNextMatchingSibling(node, nodeName);
    }

    public static final Vector<Node> getChildElements(Element e, String nodeName) {
        Vector<Node> v = new Vector<Node>();
        NodeList nl = e.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase(nodeName)) continue;
            v.add(node);
        }
        return v;
    }
}

