/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.util.QName;
import com.sygate.scm.util.XPath;
import com.sygate.scm.util.XPathElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.xml.transform.TransformerException;

public class XPathSchemaUtil {
    public static final QName VECTOR = new QName("vector");
    public static final QName DEFAULT = new QName("default");
    private static Set<String> methodsWhichAreNotAvailableInClass = new HashSet<String>();

    public static Object xpath(AbstractSchema context, String xpath) throws TransformerException {
        return XPathSchemaUtil.xpath(context, xpath, DEFAULT);
    }

    public static Object xpath(AbstractSchema context, XPath xpath) throws TransformerException {
        return XPathSchemaUtil.xpath(context, xpath, DEFAULT);
    }

    public static Object xpath(AbstractSchema context, String xpath, QName qname) throws TransformerException {
        XPath xpathObject = null;
        try {
            xpathObject = new XPath(xpath);
        }
        catch (IllegalArgumentException iae) {
            throw new TransformerException(iae);
        }
        return XPathSchemaUtil.xpath(context, xpathObject, qname);
    }

    public static Object xpath(AbstractSchema context, XPath xpath, QName qname) throws TransformerException {
        if (xpath == null) {
            throw new NullPointerException("xpath was null");
        }
        Object retValue = null;
        AbstractSchema currentContext = context;
        if (xpath.gotoRoot()) {
            currentContext = XPathSchemaUtil.getRoot(context);
        }
        for (int i = 0; i < xpath.size(); ++i) {
            Vector<AbstractSchema> children = null;
            XPathElement pathElement = xpath.getXPathElement(i);
            if (pathElement.isAttribute()) {
                retValue = XPathSchemaUtil.getAttributeValue(currentContext, pathElement);
                continue;
            }
            if (pathElement.isTextNode()) {
                retValue = XPathSchemaUtil.getAttributeValue(currentContext, pathElement.getTextNodePathElement());
                continue;
            }
            if (pathElement.isRecursive()) {
                children = XPathSchemaUtil.getAllChilrenOfType(currentContext, pathElement.getObjectType());
            } else {
                int type = pathElement.getObjectType();
                children = currentContext.getChildren(type);
            }
            if (children.isEmpty()) {
                if (i == xpath.size()) {
                    throw new TransformerException("Path does not evaluate to an existing node: " + xpath);
                }
                retValue = null;
                break;
            }
            Object object = null;
            boolean isLastPath = i + 1 >= xpath.size();
            int conditionalType = pathElement.getContitionalType();
            switch (conditionalType) {
                case 0: {
                    if (isLastPath && qname == VECTOR) {
                        return children;
                    }
                    object = children.get(pathElement.getCount());
                    break;
                }
                case 1: {
                    object = children.get(pathElement.getCount());
                    break;
                }
                case 2: {
                    object = XPathSchemaUtil.getChildBasedOnAttributeConditional(children, pathElement);
                    break;
                }
            }
            if (!isLastPath) {
                currentContext = (AbstractSchema)object;
                retValue = currentContext;
                continue;
            }
            retValue = object;
        }
        if (qname == VECTOR && !(retValue instanceof Vector) && retValue != null) {
            Vector v = new Vector();
            v.add(retValue);
            retValue = v;
        }
        return retValue;
    }

    private static AbstractSchema getRoot(AbstractSchema context) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        AbstractSchema root = context;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    public static Vector<AbstractSchema> getAllChilrenOfType(AbstractSchema currentContext, int objectType) {
        Vector<AbstractSchema> childrenOfType = new Vector<AbstractSchema>();
        Vector<AbstractSchema> children = currentContext.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            AbstractSchema child = children.get(i);
            if (child.getObjectType() == objectType) {
                childrenOfType.add(child);
                continue;
            }
            childrenOfType.addAll(XPathSchemaUtil.getAllChilrenOfType(child, objectType));
        }
        return childrenOfType;
    }

    private static Object getChildBasedOnAttributeConditional(Vector<AbstractSchema> children, XPathElement pathElement) throws TransformerException {
        for (AbstractSchema schemaObject : children) {
            String attributeValue = (String)XPathSchemaUtil.getAttributeValue(schemaObject, pathElement.getConditionalLeftHandSide());
            if (!pathElement.getConditionalValue().equals(attributeValue)) continue;
            return schemaObject;
        }
        return null;
    }

    private static Object getAttributeValue(AbstractSchema schemaObject, XPathElement pathE) throws TransformerException {
        try {
            Class<?> theClass = schemaObject.getClass();
            Method method = null;
            String methodKey = theClass.getName() + "/" + pathE.getAttributeOptMethod();
            try {
                if (!methodsWhichAreNotAvailableInClass.contains(methodKey)) {
                    method = theClass.getMethod(pathE.getAttributeOptMethod(), new Class[0]);
                }
            }
            catch (NoSuchMethodException nsme) {
                methodsWhichAreNotAvailableInClass.add(methodKey);
            }
            if (method == null) {
                method = theClass.getMethod(pathE.getAttributeMethod(), new Class[0]);
            }
            Object value = method.invoke((Object)schemaObject, new Object[0]);
            return value;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
            TransformerException e = new TransformerException("Xpath parsing error: ");
            e.initCause(exception);
            throw e;
        }
    }
}

