/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.util;

import com.sygate.scm.common.configobject.schema.SchemaObjectManager;
import java.util.StringTokenizer;

public class XPathElement {
    public static final int NO_CONDITIONAL = 0;
    public static final int INDEX = 1;
    public static final int ATTRIBUTE_CONDITION = 2;
    public static final int CHILDREN_STRING_CONDITION = 3;
    private static SchemaObjectManager schemaObjectManager = new SchemaObjectManager();
    private static final String TEXT_NODE = "text()";
    private static final XPathElement TEXT_NODE_PATH_ELEMENT = new XPathElement("@Content");
    private boolean isAttribute = false;
    private boolean isRecursive = false;
    private String attributeMethod = null;
    private String attributeOptMethod = null;
    private String attributeDefMethod = null;
    private int conditionalType = 0;
    private int index = 0;
    private String name = null;
    private int objectType;
    private String conditionalValue;
    private XPathElement conditionalLeftHandSide;
    private boolean isTextNode;

    public XPathElement(String xpathElement) {
        this(xpathElement, false);
    }

    public XPathElement(String xpathElement, boolean isRecursive) {
        int lastAmp;
        this.isRecursive = isRecursive;
        if (xpathElement == null || xpathElement.length() == 0) {
            throw new IllegalArgumentException("xpathElement cannot be null or empty");
        }
        this.name = xpathElement;
        int conditionalBegin = xpathElement.indexOf(91);
        int conditionalEnd = xpathElement.lastIndexOf(93);
        if (conditionalBegin > -1 && conditionalEnd > -1) {
            String conditional = this.name.substring(conditionalBegin + 1, conditionalEnd);
            this.parseConditional(conditional);
            this.name = this.name.substring(0, conditionalBegin);
        } else if (conditionalBegin > -1 || conditionalEnd > -1) {
            throw new IllegalArgumentException("malformed expression");
        }
        if (this.isAttribute(this.name)) {
            this.isAttribute = true;
            this.name = this.name.substring(1);
            this.attributeMethod = "get" + this.name;
            this.attributeOptMethod = "getOpt" + this.name;
            this.attributeDefMethod = "getDef" + this.name;
        }
        if ((lastAmp = this.name.lastIndexOf(64)) != 0 && lastAmp != -1) {
            throw new IllegalArgumentException("malformed xpath expression: @ in wrong place: " + xpathElement);
        }
        if (!this.isAttribute) {
            this.objectType = schemaObjectManager.getObjectTypeByName(this.name);
        }
        if (TEXT_NODE.equals(this.name)) {
            this.isTextNode = true;
        }
    }

    private boolean isAttribute(String xpathElement) {
        return xpathElement.startsWith("@");
    }

    private void parseConditional(String conditional) {
        int equalsIndex = conditional.indexOf(61);
        if (equalsIndex < 0) {
            this.conditionalType = 1;
            this.index = Integer.parseInt(conditional) - 1;
        } else {
            StringTokenizer tokenizer = new StringTokenizer(conditional, "=\"");
            String leftHandSide = tokenizer.nextToken();
            this.conditionalLeftHandSide = new XPathElement(leftHandSide);
            this.conditionalType = this.isAttribute(leftHandSide) ? 2 : 3;
            this.conditionalValue = tokenizer.nextToken();
        }
    }

    public String getAttributeMethod() {
        return this.attributeMethod;
    }

    public String getAttributeOptMethod() {
        return this.attributeOptMethod;
    }

    public String getAttributeDefMethod() {
        return this.attributeDefMethod;
    }

    public int getContitionalType() {
        return this.conditionalType;
    }

    public String getConditionalValue() {
        return this.conditionalValue;
    }

    public XPathElement getConditionalLeftHandSide() {
        return this.conditionalLeftHandSide;
    }

    public int getCount() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAttribute() {
        return this.isAttribute;
    }

    public int getObjectType() {
        return this.objectType;
    }

    public boolean isTextNode() {
        return this.isTextNode;
    }

    public boolean isRecursive() {
        return this.isRecursive;
    }

    public XPathElement getTextNodePathElement() {
        return TEXT_NODE_PATH_ELEMENT;
    }

    public String toString() {
        return this.getName();
    }
}

